#!/usr/bin/perl -w
my %page; 
#####################################################################
$page{title} = 'Monitoring of heterogenous environments';
$page{author} = 'Olutoyin Oshin. Email:ooshin@us.ibm.com';
$page{copyright} = 'Copyright 2001 IBM';
#####################################################################

#####################################################################
#Load CGI modules.  Use CGI::Carp to send errors to browser
#instead of error log
#####################################################################

use CGI qw/:standard :html3/;
use CGI::Carp qw(fatalsToBrowser);
use Net::Telnet ();
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use URI::Heuristic;
use XML::Parser;
use Text::Wrap;
use Getopt::Std;

#Enforce good programming practice, and give good error messages
use strict;

#Declare global variables
use vars qw($hostname $commd $login $passwd $telnet @commandResult
            $cgi $diskspace_SN_AIX $diskspace_HP $printMode 
            @machinenames $whichost $loopDone $diff_commd 
            $fontColor $windowsUrl $NTfontColor @versionWIN
            @identifier @platformIdentifier @versionWIN_fontColor
            @hostnameToPrint $indlevel @sectnums $parabuf @elements
           );

########################################################################
# hostnames.xml is the xml file that contains the hostnames,passwords
# and platform types. The file is opened and parsed by the xml parser
########################################################################
my $elementCount = 0;
my $machinenameCount = 0;
my $NTorUNIX = 0;
my $breakloop = 0;
my $win = 0;
my $platformType = 'platformType';
my $fromWindowsVersion = 0;
$commandResult[0] = "-&99";
my $p=new XML::Parser(Style=>'Stream');
$p->parsefile("hostnames.xml");
$loopDone = @machinenames;

#####################################################################
#Note:
#The telnet function requires the exact PROMPT at login, to function
#properly. This resulted in the creation of a USER on each host. 
#Also the program was designed to work with the default prompt.
#for AIX, Solaris, and HP-UX the default is $
#####################################################################
$cgi = new CGI;
$diskspace_SN_AIX = $cgi->param('diskspace_SN_AIX');
$diskspace_HP = $cgi->param('diskspace_HP');

if (defined($diskspace_SN_AIX)) {
    $hostname = $diskspace_SN_AIX;
    $diff_commd = 'SN_AIX';
    $printMode = '2';
    retrievePasswords();
}

if (defined($diskspace_HP)) {
    $hostname = $diskspace_HP;
    $diff_commd = 'HP';
    $printMode = '2';
    retrievePasswords();
}

for (my $i = 0; $i < @machinenames; $i++) {
    $hostname = $machinenames[$i];
    $login = $elements[$i*3];
    $passwd = $elements[($i*3)+1];
    $platformType = $elements[($i*3)+2];
    $whichost = $i;
    $printMode = '1';
    if ($platformType eq "WINDOWS") {
        $fromWindowsVersion = 1;
        windows_version();
    } else {
        $fromWindowsVersion =0;
        sn_aix_hp_version();
    }
}

########################################################################
# subroutine StartTag:
# This subroutine is required by the parser. It calls the sub StartTag 
# whenever it sees the start tag for an element. The first parameter is 
# a reference to the parser object, and the second is a string that 
# contains the element type name.
########################################################################
 sub StartTag {
  my ($expat,$eltype)=@_;

  if ($eltype eq "hostname_start") {
    $indlevel=-1;
    $sectnums[0]=0;
    $parabuf="";
  } elsif ($eltype eq "hostname") {
    ++$sectnums[++$indlevel];
    $sectnums[$indlevel+1]=0;
    $machinenames[$machinenameCount] = $_{name};
    $machinenameCount++;
  } elsif ($eltype eq "username") {
  } elsif ($eltype eq "password") {
  } elsif ($eltype eq "os") {
  } else {
    die "invalid element: $eltype";
  }
}

########################################################################
# subroutine Text:
# This subroutine stores the text up to the next start tag, end tag, 
# processing instruction, or comment into $_.
########################################################################
sub Text {
  tr/\n/ /;
  s/^\s+//;
  s/\s+$//;
  return if $_ eq "";
  $parabuf=$_;
}

########################################################################
# subroutineb EndTag:
# This subroutine wraps up all data
########################################################################
sub EndTag {
  my ($expat,$eltype)=@_;
  if ($eltype eq "hostname_start") {
  } elsif ($eltype eq "hostname") {
    --$indlevel;
  } elsif ($eltype eq "username" || $eltype eq "password" || $eltype eq "os") {
    my $ind=' ' x (4*$indlevel);
    $elements[$elementCount] = wrap($ind,$ind,$parabuf);
    $elementCount++;
  }
}

########################################################################
# Subroutine retrievePasswords
# This method extracts the login and password of the hostname.
########################################################################
sub  retrievePasswords{
   my $indexOfHostname;
   for (my $i = 0; $i < @machinenames; $i++) {
      if ($hostname eq $machinenames[i]) {
         $indexOfHostname = i;
         $i = @machinenames;
      }
   }
   $login = $elements[$indexOfHostname*3];
   $passwd = $elements[($indexOfHostname*3)+1];
   calcDiskspace();
}

#####################################################################
# Subroutine mainPage
# This constructs the main html page and displays the results 
#####################################################################
sub mainPage {
   my $ta = 0;
   my $platformToPrint;
   my $localhostname = `hostname`;
   $localhostname =~ s/^\s+//;
   $localhostname =~ s/\s+$//;

   print "Content-type: text/html\n\n";
   print $cgi->start_html(-title=>$page{title},
                          -author=>$page{author},
                          -meta=>{'copyright'=>$page{copyright}}
                         );

    print "
    <html>
    <head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">
                     <title>Monitoring of heterogenous environments</title>
                     </head>
                     <center>
                     <H1> Monitoring of heterogenous environment </H1>
                     <table border=1 cellpadding=1>
                     <tr align=center>
                     <td><b>Platform<br></b></td>
                     <td><b>Hostname</b></td>
                     <td><b>Version</b></td>
                     <td><b>Diskspace</b></td>
     ";
   for ($ta =0; $ta < @machinenames; $ta++) {
      if (defined($platformIdentifier[$ta]) && $platformIdentifier[$ta] eq 'AIX') {
         $platformToPrint = "AIX";
      }elsif ($platformIdentifier[$ta] eq 'SOLARIS') {
         $platformToPrint = "SOLARIS";
      }elsif ($platformIdentifier[$ta] eq 'HP-UX') {
         $platformToPrint = "HP-UX";
      }elsif ($platformIdentifier[$ta] eq 'LINUX') {
         $platformToPrint = "LINUX";
      }else {
         $platformToPrint = "WINDOWS";
      }

   print "
   <tr>
   <td align=center rowspan=1><b>$platformToPrint</b></a><b></td>
   ";
   if (($identifier[$ta] eq "FAILED") || ($identifier[$ta] eq "PASSWORD EXPIRED")) {
     print "
     <td align=center><b>$hostnameToPrint[$ta]</b></td>
     ";
   }else{
      print "
      <td align=center><a href=\"http://$hostnameToPrint[$ta]/whoAmI.html\"><b>$hostnameToPrint[$ta]</b></a></td>
      ";
   }
   print "
   <td align=center><b><font color=$versionWIN_fontColor[$ta]>$identifier[$ta]</font></b></a><b></td>
   ";

   if (($identifier[$ta] eq "FAILED") || ($identifier[$ta] eq "PASSWORD EXPIRED")) {
     print "<td align=center><b>Show Disk Space</b></td>";
   } else {
      if (($platformToPrint eq "WINDOWS")) {
         print "<td align=center><a href=\"http://$hostnameToPrint[$ta]/cgi-bin/MHE/diskspaceWin.pl\" name=show_disk_space><b>Show Disk Space</b></a><b></td>";
      }elsif($platformToPrint eq "HP-UX"){ 
         print "<td align=center><a href=\"http://$localhostname/cgi-bin/MHE/mhe.pl?diskspace_HP=$hostnameToPrint[$ta]\" name=show_disk_space><b>Show Disk Space</b></a><b></td>";
      }else {
         print "<td align=center><a href=\"http://$localhostname/cgi-bin/MHE/mhe.pl?diskspace_SN_AIX=$hostnameToPrint[$ta]\" name=show_disk_space><b>Show Disk Space</b></a><b></td>";
      }
   }
   }

   print "
   </table>
   </center>
   </body>
   </html>
   ";
}

#####################################################################
# Subroutine mainAction:
# This routine performs the telnet function and calls the appropriate
# print function
#####################################################################
sub  mainAction{
   $telnet = Net::Telnet->new
   (
   Timeout=>7, Prompt=>'/[\$%#>] $/', Host=>$hostname, Errmode=>'return'
   );
    my $commandLine;
    if (defined($telnet)) {
        $telnet->login($login, $passwd);
        @commandResult = $telnet->cmd($commd);
        $platformType =~ s/^\s+//; 
        $platformType =~ s/\s+$//; 
        if ($platformType eq "AIX") {
            $commandLine= $telnet->getline;
            $commandLine= $telnet->getline;
            if ($commandLine =~ m/3004-609/) {
                   $commandResult[0] = "PASSWORD EXPIRED";
            }
         }
        $telnet->close;
    } else {
        $commandResult[0] = "-&99";
    }

    if ($printMode eq '1') {
        printVersionResult();
    }
    if ($printMode eq '2') {
        printCmdResult();
    }
}

#####################################################################
# Subroutine printResult
# Assigns the values of the version of each host and calls mainpage
# to print.
#####################################################################
sub  printVersionResult{
    my $resultSN = 0; 
    my $resultAIX = 0;
    my $resultHP = 0;
    my $resultLINUX = 0;
    my $commResult = "";
    my $parser = "";

    if (defined($commandResult[0])) {
       $commResult = $commandResult[0];
       $parser = $commandResult[0];
    }

    if ($printMode eq '1'  && ($fromWindowsVersion eq "0")) {
        if (!($commResult eq '-&99') && !($commResult eq 'PASSWORD EXPIRED') ) {
            $fontColor = "green";
            my @store = split(" ",$parser);
            my $space = " ";
            my $dot = ".";
            $resultSN = $store[0].$space.$store[2];
            $resultAIX = $store[0].$space.$store[3].$dot.$store[2];
            $resultHP = $store[0].$space.$store[2];
            $resultLINUX = $store[0].$space.$store[2];
            } else
            {
            $fontColor = "FF0000";
            $resultSN = "FAILED";
            $resultAIX = "FAILED";
            $resultHP =  "FAILED";
            $resultLINUX = "FAILED";
               if ($commResult eq "PASSWORD EXPIRED") {
                  $resultAIX = "PASSWORD EXPIRED";
               }
            }

        $versionWIN[$win] = '$versionWIN_'.$hostname;
        
        $versionWIN_fontColor[$win] = $fontColor;
        if ($platformType eq "SOLARIS") {
             $identifier[$win] = $resultSN;
             $platformIdentifier[$win] = "SOLARIS";
             $hostnameToPrint[$win] = $hostname;
        }
        if ($platformType eq "AIX") {
            $identifier[$win] = $resultAIX;
            $platformIdentifier[$win] = "AIX"; 
            $hostnameToPrint[$win] = $hostname;
        }
        if ($platformType eq "HP-UX") {
            $identifier[$win] = $resultHP;
            $platformIdentifier[$win] = "HP-UX";
            $hostnameToPrint[$win] = $hostname;
        }
        if ($platformType eq "LINUX") {
            $identifier[$win] = $resultLINUX;
            $platformIdentifier[$win] = "LINUX";
            $hostnameToPrint[$win] = $hostname;
        }                                     
        $win++;
        }
    if ($whichost eq ($loopDone-1))
        {
        mainPage();
        exit;
        }
}

#####################################################################
# subroutine printCmdResult
# prints te results of a query
#####################################################################
sub printCmdResult {
print "Content-type: text/html\n\n";
print <<END_OF_PAGE;
<html>
<title>Machine Query</title>
<h1>$hostname</h1>
<B>Results from the command: <big><i>$commd</i></big></B>
</html>
END_OF_PAGE
    if ($printMode eq '2')
        {
        print "<PRE>";
        print "<br><B>$commandResult[0]</B></br>";
        print "</PRE>";
        print "<PRE>";
        for (my $i = 1; $i < @commandResult; $i++)
            {
            print "$commandResult[$i]";
            }
        print "</PRE>";
        }
    exit;
}

#####################################################################
# sub sn_aix_hp_version:
# This routine set version command for AIX, Solaris, and HP-UX
#####################################################################
sub sn_aix_hp_version {
  $commd = 'uname -a';
  mainAction();
}

#####################################################################
# sub windows_version:
# This routine set version command for Windows
#####################################################################
sub windows_version {
   my $NTHost_1;
   my $NTHost_2;
   my $NTHost_3;
    $windowsUrl = 'http://'.$hostname.'/cgi-bin/MHE/MHEWindows.pl';
    my $ua = LWP::UserAgent->new();
    $ua->agent("Schmozilla/v9.14 Platinum");
    my $req = HTTP::Request->new(GET => $windowsUrl);
    my $response = $ua->request($req);
    if ($response->is_error())
        {
        $NTfontColor = "FF0000";
        $versionWIN[$win] = '$versionWIN_'.$hostname;
        $versionWIN_fontColor[$win] = $NTfontColor;
        $identifier[$win] = "FAILED";
        $hostnameToPrint[$win] = $hostname;
        $win++;
        } else
        {
        $NTfontColor = "green";
        $versionWIN[$win] = '$versionWIN_'.$hostname;
        $versionWIN_fontColor[$win] = $NTfontColor;
        $identifier[$win] = $response->content();
        $identifier[$win] =~ s/^\s+//;
        $identifier[$win] =~ s/\s+$//;
        $hostnameToPrint[$win] = $hostname;
        $win++;
        }
        if ($printMode == '1') {
          printVersionResult();
         }else{
         printCmdResult();
            }

}

#####################################################################
# sub calcDiskspace:
# This routine sets the command for the disk space.
#####################################################################
sub calcDiskspace {
    if ($diff_commd eq 'HP')
        {
        $commd = 'bdf';
        }
    if ($diff_commd eq 'SN_AIX')
        {
        $commd = 'df -k';
        }
    mainAction();
}
