/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.JCScrollbar;
import jclass.bwt.ScrolledWindowConverter;
import jclass.bwt.Viewport;

public class JCScrolledWindow
extends JCContainer
implements KeyListener,
JCAdjustmentListener {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NONE = 2;
    public static final int DISPLAY_VERTICAL_ONLY = 3;
    public static final int DISPLAY_HORIZONTAL_ONLY = 4;
    int sb_display = 0;
    int sb_offset;
    private JCScrollbar vert_sb = new JCScrollbar(1);
    private JCScrollbar horiz_sb = new JCScrollbar(0);
    int keystroke;
    private static final String base = "scrolledwindow";
    private static int nameCounter;
    protected Component viewport;
    Rectangle rect = new Rectangle();

    public JCScrolledWindow() {
        this(null, null);
    }

    public JCScrolledWindow(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.viewport = new Viewport();
        if (this.getClass().getName().equals("jclass.bwt.JCScrolledWindow")) {
            this.getParameters(applet);
        }
        this.addInternal(this.vert_sb);
        this.vert_sb.addAdjustmentListener(this);
        this.addInternal(this.horiz_sb);
        this.horiz_sb.addAdjustmentListener(this);
    }

    protected void getParameters() {
        super.getParameters();
        ScrolledWindowConverter.getParams(this);
    }

    public int getScrollbarDisplay() {
        return this.sb_display;
    }

    public void setScrollbarDisplay(int n) {
        ScrolledWindowConverter.checkDisplay(n);
        this.sb_display = n;
        this.layout();
    }

    public int getScrollbarOffset() {
        return this.sb_offset;
    }

    public void setScrollbarOffset(int n) {
        this.sb_offset = n;
        this.layout();
    }

    public Component getViewport() {
        return this.viewport;
    }

    int sb_size() {
        if (this.sb_display == 1) {
            return 16 + this.sb_offset;
        }
        return 0;
    }

    protected int preferredWidth() {
        int n;
        int n2 = n = this.viewport != null ? this.viewport.preferredSize().width : 0;
        if (n > 0) {
            return n + this.sb_size();
        }
        return 100;
    }

    protected int preferredHeight() {
        int n;
        int n2 = n = this.viewport != null ? this.viewport.preferredSize().height : 0;
        if (n > 0) {
            return n + this.sb_size();
        }
        return 100;
    }

    protected int getViewportWidth() {
        return this.viewport.preferredSize().width;
    }

    protected int getViewportHeight() {
        return this.viewport.preferredSize().height;
    }

    public Component add(Component component) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component);
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(string, component);
        }
        return component;
    }

    public Component add(Component component, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, n);
        }
        return component;
    }

    public void add(Component component, Object object) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, object);
        }
    }

    public void add(Component component, Object object, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, object, n);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component);
            if (!(component instanceof Container)) {
                component.addKeyListener(this);
            }
        }
    }

    protected void addInternal(Component component) {
        if (component.getParent() != this) {
            super.addImpl(component, null, -1);
        }
    }

    public void addNotify() {
        this.addInternal(this.viewport);
        super.addNotify();
    }

    public JCScrollbar getVertScrollbar() {
        return this.vert_sb;
    }

    public JCScrollbar getHorizScrollbar() {
        return this.horiz_sb;
    }

    protected void setHorizScrollbarValues() {
    }

    protected void setHorizScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.horiz_sb.setValues(n, n2, n3, n4);
        this.horiz_sb.setBlockIncrement(n2);
        this.horiz_sb.setUnitIncrement(10);
        this.setHorizScrollbarValues();
    }

    protected void setVertScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.vert_sb.setValues(n, n2, n3, n4);
        this.vert_sb.setBlockIncrement(n2);
        this.vert_sb.setUnitIncrement(10);
        this.setVertScrollbarValues();
    }

    protected void setVertScrollbarValues() {
    }

    protected int reshapeHeader(int n, int n2, int n3) {
        return 0;
    }

    protected int headerHeight() {
        return 0;
    }

    protected void reshapeViewport(int n, int n2, int n3, int n4) {
        this.viewport.reshape(n, n2, n3, n4);
    }

    public void layout() {
        JCComponent jCComponent;
        int n;
        int n2;
        int n3;
        boolean bl;
        boolean bl2;
        if (this.getPeer() == null) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = this.headerHeight();
        n10 = this.getViewportWidth();
        n11 = this.getViewportHeight();
        JCScrolledWindow jCScrolledWindow = this;
        synchronized (jCScrolledWindow) {
            n6 = this.size().width - this.insets().left - this.insets().right;
            n7 = this.size().height - this.insets().top - this.insets().bottom;
            n8 = n7 - n12;
            n9 = n6;
            if (this.sb_display == 2) {
                bl2 = false;
                bl = false;
            } else if (this.sb_display == 1) {
                bl2 = true;
                bl = true;
            } else if (n8 >= n11 && n9 >= n10 && this.sb_display == 0) {
                n9 = n6;
                n8 = n7;
                bl2 = false;
                bl = false;
            } else {
                bl = this.sb_display != 4;
                boolean bl3 = bl2 = this.sb_display != 3;
                if (n11 <= n8 && this.sb_display != 3) {
                    n9 = n6;
                    bl = false;
                } else {
                    n9 = n6 - (16 + this.sb_offset);
                }
                if (n10 <= n9 && this.sb_display != 4) {
                    n8 = n7;
                    bl2 = false;
                }
            }
            n8 = bl2 ? n7 - (16 + this.sb_offset) : n7;
            int n13 = n9 = bl ? n6 - (16 + this.sb_offset) : n6;
            if (bl2) {
                n4 = !bl ? n6 : n9;
            }
            if (bl) {
                n5 = !bl2 ? n7 : n8;
            }
            n3 = this.insets().left;
            n2 = this.insets().top;
            int n14 = this.insets().left;
            int n15 = bl2 ? this.size().height - this.insets().bottom - 16 : this.size().height;
            int n16 = bl ? this.size().width - this.insets().right - 16 : n6;
            int n17 = this.insets().top;
        }
        int n18 = this.reshapeHeader(n3, n2, n9);
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 += n18;
            n17 += n18;
            n5 -= n18;
            n20 = n19 = this.vert_sb.getValue();
            n19 = Math.max(0, Math.min(n19, n11 - (n8 -= n18)));
            if (n19 != n20) {
                this.scrollVertical(null, n19);
            }
            n21 = n11;
            n = n8;
            if (this.viewport instanceof JCComponent) {
                jCComponent = (JCComponent)this.viewport;
                n18 = 2 * jCComponent.shadow + jCComponent.insets.top + jCComponent.insets.bottom;
                n -= n18;
                n21 -= n18;
            }
        }
        this.setVertScrollbarValues(n19, n, 0, n21);
        serializable = this;
        synchronized (serializable) {
            n20 = n19 = this.horiz_sb.getValue();
            n19 = Math.max(0, Math.min(n19, n10 - n9));
            if (n19 != n20) {
                this.scrollHorizontal(null, n19);
            }
            n21 = n10;
            n = n9;
            if (this.viewport instanceof JCComponent) {
                jCComponent = (JCComponent)this.viewport;
                int n22 = 2 * jCComponent.shadow + jCComponent.insets.left + jCComponent.insets.right;
                n -= n22;
                n21 -= n22;
            }
        }
        this.setHorizScrollbarValues(n19, n, 0, n21);
        this.reshapeViewport(n3, n2, n9, n8);
        serializable = this.viewport.location();
        Dimension dimension = this.viewport.size();
        if (bl) {
            this.vert_sb.reshape(((Point)serializable).x + dimension.width + this.sb_offset, ((Point)serializable).y, 16, n5);
        }
        this.vert_sb.show(bl);
        if (bl2) {
            this.horiz_sb.reshape(((Point)serializable).x, ((Point)serializable).y + dimension.height + this.sb_offset, n4, 16);
        }
        this.horiz_sb.show(bl2);
    }

    protected void scrollHorizontal(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getHorizOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setHorizOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.width) {
            component.repaint();
            return;
        }
        int n4 = this.rect.width - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            jCComponent.copyArea(graphics, this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
            jCComponent.repaint(graphics, this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
        } else {
            graphics.copyArea(this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
            component.repaint(this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getVertOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setVertOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.height) {
            component.repaint();
            return;
        }
        int n4 = this.rect.height - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            jCComponent.copyArea(graphics, this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
            jCComponent.repaint(graphics, this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
        } else {
            graphics.copyArea(this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
            component.repaint(this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollVertical(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollVertical((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    protected void scrollHorizontal(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollHorizontal(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollHorizontal((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    public void scrollVertical(int n) {
        this.vert_sb.setValue(n);
        this.scrollVertical(null, this.vert_sb.getValue());
    }

    public void scrollHorizontal(int n) {
        this.horiz_sb.setValue(n);
        this.scrollHorizontal(null, this.horiz_sb.getValue());
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                this.keystroke = 1002;
                this.scrollVertical(this.vert_sb.getValue() - this.vert_sb.getBlockIncrement());
                break;
            }
            case 34: {
                this.keystroke = 1003;
                this.scrollVertical(this.vert_sb.getValue() + this.vert_sb.getBlockIncrement());
                break;
            }
            case 36: {
                this.keystroke = 1000;
                this.scrollVertical(0);
                break;
            }
            case 35: {
                this.keystroke = 1001;
                this.scrollVertical(this.vert_sb.getMaximum());
                break;
            }
            case 37: {
                this.keystroke = 1006;
                this.scrollHorizontal(this.horiz_sb.getValue() - this.horiz_sb.getUnitIncrement());
                break;
            }
            case 39: {
                this.keystroke = 1007;
                this.scrollHorizontal(this.horiz_sb.getValue() + this.horiz_sb.getUnitIncrement());
                break;
            }
        }
        this.keystroke = 0;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        if (jCAdjustmentEvent.getSource() == this.vert_sb) {
            this.scrollVertical(jCAdjustmentEvent, this.vert_sb.getValue());
            return;
        }
        if (jCAdjustmentEvent.getSource() == this.horiz_sb) {
            this.scrollHorizontal(jCAdjustmentEvent, this.horiz_sb.getValue());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

