/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: bwtgui.java $ $Revision: 2.1 $ $Date: 1997/11/21 16:54:29 $ $Locker: $  KL Group Inc.

package jclass.bwt.demos.awt_vs_bwt;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCButtonEvent;
import jclass.bwt.JCButtonListener;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnList;
import jclass.bwt.JCSpinBox;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCTabManager;
import jclass.bwt.JCTabManagerEvent;
import jclass.bwt.JCTabManagerListener;
import jclass.bwt.JCTextField;
import jclass.contrib.ContribFrame;
import jclass.util.JCImageCreator;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

import java.awt.*;
import java.util.Vector;

public class bwtgui extends java.applet.Applet
implements JCTabManagerListener, JCButtonListener, JCActionListener, 
JCItemListener, JCSpinBoxListener {

final static String[] upPixels = {
	"             ",
	"             ",
	"             ",
	"             ",
	"      x      ",
	"     xxx     ",
	"    xxxxx    ",
	"   xxxxxxx   ",
	"  xxxxxxxxx  ",
    "             ",
    "             ",
    "             ",
    "             "
};

final static String[] leftPixels = {
	"             ",
	"             ",
	"        x    ",
	"       xx    ",
	"      xxx    ",
	"     xxxx    ",
	"    xxxxx    ",
	"     xxxx    ",
	"      xxx    ",
    "       xx    ",
    "        x    ",
    "             ",
    "             "
};

final static String[] rightPixels = {
	"             ",
	"             ",
	"    x        ",
	"    xx       ",
	"    xxx      ",
	"    xxxx     ",
	"    xxxxx    ",
	"    xxxx     ",
	"    xxx      ",
    "    xx       ",
    "    x        ",
    "             ",
    "             "
};

final static String[] columnLabels = { 
	"Title", "Author", "Price", "Qty", "In Stock", "Pages", "Publisher"
};

final static int[] alignments = {
	BWTEnum.LEFT, BWTEnum.LEFT, BWTEnum.RIGHT, BWTEnum.RIGHT,
	BWTEnum.CENTER, BWTEnum.RIGHT, BWTEnum.LEFT, 
};

final static int[] orderAlignments = {
	BWTEnum.LEFT, BWTEnum.RIGHT, BWTEnum.RIGHT, BWTEnum.RIGHT, BWTEnum.RIGHT,
};

final static String[] data = {
"Presenting Java|"+
"John December|"+
"[color=red]$25.00|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"207|"+
"Sams.net",

"The Official Internet World\n60 Minute Guide to Java|"+
"Ed Tittel\n"+
"Mark Gaither|"+
"[color=red]$19.99|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"256|"+
"IDG Books",

"Hooked on Java|"+
"Arthur van Hoff\n"+
"Sami Shaio\n"+
"Orca Starbuck|"+
"[color=red]$29.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"|"+
"Addison-Wesley",

"Teach Yourself Java in 21 Days|"+
"Laura Lemay\n"+
"Charles L. Perkins|"+
"[color=red]$39.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"527|"+
"Sams.net",

"Programming with Java!|"+
"Tim Ritchey|"+
"[color=red]$35.00|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"389|"+
"New Riders",

"Java in a Nutshell: \nA Desktop Quick Reference\nfor Java Programmers|"+
"David Flanagan|"+
"[color=red]$14.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"450|"+
"O'Reilly",

"Java Primer Plus|"+
"Paul Tyma\n"+
"Gabriel Torok\n"+
"Troy Downing|"+
"[color=red]$39.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"600|"+
"Waite Group Press",

"Web Site Programming With Java|"+
"David Harms\n"+
"Barton Fiske\n"+
"Jeffrey Rice|"+
"[color=red]$39.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"578|"+
"McGraw-Hill",

"Java for C/C++ Programmers|"+
"Michael C. Daconta|"+
"[color=red]$39.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"500|"+
"John Wiley & Sons, Inc.",

"Active Java|"+
"Adam Freeman\n"+
"Darrel Ince|"+
"[color=red]$25.95|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"235|"+
"Addison-Wesley",

"Essential Java:\nDeveloping Interactive Applets|"+
"Jason Manger|"+
"[color=red]$39.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"352|"+
"McGraw-Hill",

"Java By Example|"+
"Jerry Jackson\n"+
"Alan L. McClellan|"+
"[color=red]$34.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"345|"+
"SunSoft Press",

"Instant Java|"+
"John A. Pew|"+
"[color=red]$29.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"340|"+
"SunSoft Press",

"The Java Handbook|"+
"Patrick Naughton|"+
"[color=red]$27.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"450|"+
"Osborne/McGraw-Hill",

"Core Java|"+
"Gary Cornell\n"+
"Cay S. Horstmann|"+
"[color=red]$39.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"600|"+
"SunSoft Press",

"Programming JavaScript\nfor Netscape 2.0|"+
"Tim Ritchey|"+
"[color=red]$35.00|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"300|"+
"New Riders",

"Teach Yourself Java for Macintosh\nin 21 Days|"+
"Laura Lemay\n"+
"Charles L. Perkins\n"+
"with Timothy Webster|"+
"[color=red]$40.00|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"500|"+
"Hayden",

"Java Programming EXplorer|"+
"Neil Bartlett\n"+
"Alex Leslie\n"+
"Steve Simkin|"+
"[color=red]$39.99|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"848|"+
"Coriolis Group Books",

"Java Unleashed|"+
"Michael Morrison, et al.|"+
"[color=red]$49.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"1000|"+
"Sams.net",

"Java Programmer's Library|"+
"Suleiman Lalani\n"+
"Kris Jamsa|"+
"[color=red]$49.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"556|"+
"Jamsa Press",

"The Complete Idiot's Guide\nto JavaScript|"+
"Aaron Weiss\n"+
"Scott J. Walter|"+
"[color=red]$19.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"|"+
"Que",

"The Java Programming Language|"+
"Ken Arnold\n"+
"James Gosling|"+
"[color=red]$34.50|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"334|"+
"Addison-Wesley",

"Special Edition: Using Java|"+
"Alex Newman, et al.|"+
"[color=red]$49.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"869|"+
"Que",

"Java Programming Basics|"+
"Edith Au\n"+
"Dave Makower\n"+
"Pencom Web Works|"+
"[color=red]$34.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"352|"+
"MIS:Press/M&T Books",

"Java Manual of Style|"+
"Nathan Gurewich\n"+
"Ori Gurewich|"+
"[color=red]$24.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"|"+
"Ziff-Davis",

"Teach Yourself JavaScript In A Week|"+
"Arman Damesh|"+
"[color=red]$35.99|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"|"+
"Sams.net",

"Java Essentials\nFor C & C++ Programmers|"+
"Boone Barry|"+
"[color=red]$29.95|"+
"|"+
"[IMG=../../images/x16.gif]|"+
"|"+
"Addison-Wesley",

"The Java Programming Language|"+
"David H. Friedel, Jr.\n"+
"Anthony Potts|"+
"[color=red]$24.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"300|"+
"Coriolis Group Books",

"Java Programming for the Internet|"+
"Michael D. Thomas\n"+
"Pratik R. Patel\n"+
"Alan D. Hudson\n"+
"Donald A. Ball|"+
"[color=red]$49.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"760|"+
"Ventana Press",

"Writing Java Applets|"+
"John Rodley|"+
"[color=red]$39.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"450|"+
"Coriolis Group Books",

"Making Sense of Java:\nA Guide for Managers\nand the Rest of Us|"+
"Bruce Simpson\n"+
"John Mitchell\n"+
"Brian Christeson\n"+
"Rehan Zaidi\n"+
"Jonathan Levine|"+
"[color=red]$29.95|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"|"+
"Prentice Hall",

"Danny Goodman's JavaScript Handbook|"+
"Danny Goodman|"+
"[color=red]$34.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"544|"+
"IDG Books",

"JavaScript for the Macintosh|"+
"Matt Shobe\n"+
"Tim Ritchey|"+
"[color=red]$40.00|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"300|"+
"Hayden",

"Creating Cool Web Applets with Java|"+
"Paul J. Perry|"+
"[color=red]$29.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"300|"+
"IDG Books",

"JavaScript & Netscape 2 Wizardry|"+
"Dan Shafer|"+
"[color=red]$34.99|"+
"|"+
"[IMG=../../images/check16.gif]|"+
"500|"+
"Coriolis Group Books",
};

// Important components in the gui
JCMultiColumnList list = new JCMultiColumnList(null, this, "booklist");
JCMultiColumnList sw;
JCTextField price_text, total_text;
JCSpinBox qty_text;
JCButton add_button, order_button;
JCTabManager tabman;

int numTabs;

public void init() {
	// Create arrow images for later use

	JCImageCreator upIC = new JCImageCreator(this, 13, 13);
	upIC.setColor('x', Color.red);
	upIC.setPixels(upPixels);
	Image up_arrow = upIC.create();

	JCImageCreator leftIC = new JCImageCreator(this, 13, 13);
	leftIC.setColor('x', Color.blue);
	leftIC.setPixels(leftPixels);
	Image left_arrow = leftIC.create();

	JCImageCreator rightIC = new JCImageCreator(this, 13, 13);
	rightIC.setColor('x', Color.blue);
	rightIC.setPixels(rightPixels);
	Image right_arrow = rightIC.create();

	setLayout(new JCGridLayout(BWTEnum.VARIABLE, 1, 10, 10));
	setBackground(Color.lightGray);

	// The Book List

	Panel l_pan = new Panel();
	l_pan.setLayout(new GridLayout(1,1));
	l_pan.setBackground(Color.lightGray);

	list.getList().setBackground(Color.white);
	list.getList().setFont(new Font("Dialog", Font.PLAIN, 10));
	list.setSpacing(10);
	list.setRowHeight(BWTEnum.VARIABLE);
	for (int i=0; i < data.length; i++) 
		list.addItem(JCUtilConverter.toVector(this, data[i], '|', true));
	list.setColumnButtons(columnLabels);
	list.setColumnAlignments(alignments);
	list.getHeader().setColumnAlignments(alignments);
	list.setPreferredSize(500, 175);

	list.addItemListener(this);
	list.addActionListener(this);
	l_pan.add(list);

	add(l_pan);

	// The Quantity Price Line

	Panel q_pan = new Panel();
	q_pan.setLayout(new FlowLayout());

	q_pan.add(new JCLabel("Qty"));
	q_pan.add(qty_text = new JCSpinBox(3));
	qty_text.addSpinBoxListener(this);

	q_pan.add(new JCLabel("@ Price "));
	q_pan.add(price_text = new JCTextField("", 7));

	price_text.setEditable(false);
	price_text.setShowCursorPosition(false);

	q_pan.add(new JCLabel(" = "));
	q_pan.add(total_text = new JCTextField("", 9));

	total_text.setEditable(false);
	total_text.setShowCursorPosition(false);

	q_pan.add(add_button = 
			  new JCButton("Add To Order", up_arrow, BWTEnum.STRING_RIGHT));
	add_button.addActionListener(this);
	add(q_pan);

	// The Tab Manager

	tabman = new JCTabManager(this, "wizard");

	// The Payment Tab

	Panel pay_pan = new Panel();
	pay_pan.setLayout(null);

	JCCheckboxGroup card_grp = new JCCheckboxGroup(
		JCString.parse(this, "[ALIGN=MIDDLE]Credit Card [IMG=../awt_vs_bwt/charge.gif]"));
	card_grp.add(new JCCheckbox("Visa"));
	card_grp.add(new JCCheckbox("Mastercard"));
	card_grp.add(new JCCheckbox("American Express"));
	pay_pan.add(card_grp);
	card_grp.reshape(0, 0, 200, 150);

	Panel pay_right_pan = new Panel();
	pay_right_pan.setLayout(new JCGridLayout(2,2));
	pay_right_pan.reshape(225, 30, 250, 150);

	TextField pay_tf;
	pay_right_pan.add(new JCLabel("Number :", this, "paylabel"));
	pay_right_pan.add(pay_tf = new TextField(20));
	pay_right_pan.add(new JCLabel("Expiry :", this, "paylabel"));
	pay_right_pan.add(pay_tf = new TextField(20));

	pay_pan.add(pay_right_pan);

	JCButton pay_button;
	pay_pan.add(pay_button = new JCButton("Prev", left_arrow, BWTEnum.STRING_RIGHT));
	pay_button.addActionListener(this);
	pay_button.reshape(155, 200, 80, 25);

	pay_pan.add(pay_button = new JCButton("Next", right_arrow, BWTEnum.STRING_LEFT));
	pay_button.addActionListener(this);
	pay_button.reshape(275, 200, 80, 25);


	// The Mailing Tab
	
	Panel mail_pan = new Panel();
	mail_pan.setLayout(null);

	Panel mail_sub_pan = new Panel();
	mail_sub_pan.reshape(0, 0, 475, 200);
	mail_sub_pan.setLayout(new JCGridLayout(4, 2));
	
	TextField mail_tf;
	TextArea mail_ta;
	mail_sub_pan.add(new JCLabel("Name :", this, "maillabel"));
	mail_sub_pan.add(mail_tf = new TextField());

	mail_sub_pan.add(new JCLabel("Company :", this, "maillabel"));
	mail_sub_pan.add(mail_tf = new TextField());

	mail_sub_pan.add(new JCLabel("Mailing Address :", this, "maillabel"));
	mail_sub_pan.add(mail_ta = new TextArea(3, 45));

	mail_sub_pan.add(new JCLabel("Comments :", this, "maillabel"));
	mail_sub_pan.add(mail_ta = new TextArea(3, 45));

	mail_pan.add(mail_sub_pan);

	JCButton mail_button;
	mail_pan.add(mail_button = 
			new JCButton("Prev", left_arrow, BWTEnum.STRING_RIGHT));
	mail_button.addActionListener(this);
	mail_button.reshape(155, 200, 80, 25);
	mail_pan.add(mail_button = new JCButton("Next", right_arrow, BWTEnum.STRING_LEFT));
	mail_button.addActionListener(this);
	mail_button.reshape(275, 200, 80, 25);

	
	// The Shipping Tab

	Panel ship_pan = new Panel();
	ship_pan.setLayout(null);

	JCCheckboxGroup ship_grp = new JCCheckboxGroup(this, "shipmethgrp");
	ship_grp.setTitle("Shipping Methods");
	ship_grp.setOrientation(BWTEnum.HORIZONTAL);
	ship_grp.add(new JCCheckbox("UPS"));
	ship_grp.add(new JCCheckbox("Air Mail"));
	ship_grp.add(new JCCheckbox("Surface Mail"));
	ship_pan.add(ship_grp);
	ship_grp.reshape(0, 0, 475, 70);

	JCCheckboxGroup ship_opt_grp = new JCCheckboxGroup(this, "shipoptgrp");
	ship_opt_grp.setTitle("Shipping Options");
	ship_opt_grp.setOrientation(BWTEnum.HORIZONTAL);
	ship_opt_grp.setRadioBehavior(false);
	ship_opt_grp.add(new JCCheckbox("Insurance ($5.00)"));
	ship_opt_grp.add(new JCCheckbox("Extra Padding ($5.00)"));
	ship_pan.add(ship_opt_grp);
	ship_opt_grp.reshape(0, 70, 475, 70);

	JCButton ship_button;
	ship_pan.add(ship_button = 
		new JCButton("Prev", left_arrow, BWTEnum.STRING_RIGHT));
	ship_button.addActionListener(this);
	ship_button.reshape(155, 200, 80, 25);

	ship_pan.add(ship_button = 
		new JCButton("Next", right_arrow, BWTEnum.STRING_LEFT));
	ship_button.addActionListener(this);
	ship_button.reshape(275, 200, 80, 25);


	// The Send Tab
	
	Panel send_pan = new Panel();
	send_pan.setLayout(null);

	Panel send_list_pan = new Panel();
	send_list_pan.setLayout(new GridLayout(1,1));
	send_list_pan.resize(470, 150);
	send_list_pan.add(sw = new JCMultiColumnList(null, this, "orderlist"));
	sw.setColumnAlignments(orderAlignments);
	send_pan.add(send_list_pan);

	send_pan.add(order_button = new JCButton(
			JCString.parse(this, "[ALIGN=MIDDLE]Send Order [IMG=../awt_vs_bwt/mail.gif]")));
	order_button.reshape(175, 160, 150, 30);
	order_button.addButtonListener(this);
	order_button.addButtonListener(this);
	order_button.addActionListener(this);
	
	JCButton send_button;
	send_pan.add(send_button = 
				new JCButton("Prev", left_arrow, BWTEnum.STRING_RIGHT));
	send_button.addActionListener(this);
	send_button.reshape(155, 200, 80, 25);
	send_pan.add(send_button = 
				new JCButton("Next", right_arrow, BWTEnum.STRING_LEFT));
	send_button.addActionListener(this);
	send_button.reshape(275, 200, 80, 25);


	// Finish setting up Tabs

	int page;
	numTabs = 0;
	page = tabman.addPage("Payment", pay_pan);
	tabman.getTab(page).setUserData(new Boolean(false));
	numTabs++;
	page = tabman.addPage("Mailing", mail_pan);
	tabman.getTab(page).setUserData(new Boolean(false));
	numTabs++;
	page = tabman.addPage("Shipping", ship_pan);
	tabman.getTab(page).setUserData(new Boolean(false));
	numTabs++;
	page = tabman.addPage("Send", send_pan);
	tabman.getTab(page).setUserData(new Boolean(true));
	numTabs++;
	tabman.setPreferredSize(500, 275);
	tabman.addTabManagerListener(this);
	add(tabman);
}

public void itemStateChanged(JCItemEvent ev) {
	if (ev.getSource() == list && ev.getStateChange() == JCItemEvent.SELECTED) 
		updatePriceFieldFromList();
} 

public void actionPerformed(JCActionEvent ev) {
	Component source = (Component) ev.getSource();
	if (source == list) {
		int index = list.getSelectedIndex();
		if (index >= 0) {
			Vector v = (Vector) list.getItem(index);
			int qty = qtyStringToInt((String) v.elementAt(3));
			v.setElementAt(String.valueOf(qty+1), 3);
			list.paintRow(index);
		}
		updatePriceFieldFromList();
	}

	else if (source == add_button) {
		int index = list.getSelectedIndex();
		if (index >= 0) {
			Vector v = (Vector) list.getItem(index);
			int qty = qtyStringToInt(qty_text.getText());
			v.setElementAt(String.valueOf(qty), 3);
			list.repaint();
		}
	}

	else if (source instanceof JCButton 
			 && ((JCButton)source).getName() .equals("Prev")) {
		int c = tabman.getCurrentTab();
		if (c > 0) 
			tabman.setCurrentTab(c-1, true);
		else
			tabman.setCurrentTab(numTabs-1, true);
	} 

	else if (source instanceof JCButton 
			 && ((JCButton)source).getName() .equals("Next")) {
		int c = tabman.getCurrentTab();
		if (c < numTabs-1) 
			tabman.setCurrentTab(c+1, true);
		else
			tabman.setCurrentTab(0, true);
	}

} 

public void spinBoxChangeBegin(JCSpinBoxEvent ev) {}
public void spinBoxChangeEnd(JCSpinBoxEvent ev) {
	updatePriceFieldFromField();
}

// Invoked before the button is armed (i.e. pushed).
public void buttonArmBegin(JCButtonEvent ev) {
	if (ev.getSource() == order_button) 
		order_button.setLabel(
			JCString.parse(this, "[ALIGN=MIDDLE]Send Order [IMG=../awt_vs_bwt/mail_m.gif]"));
}

// Invoked before the button is disarmed (i.e. released).
public void buttonDisarmBegin(JCButtonEvent ev) {
	if (ev.getSource() == order_button) 
		order_button.setLabel(
			JCString.parse(this, "[ALIGN=MIDDLE]Send Order [IMG=mail.gif]"));
}

// Invoked after the button is armed (i.e. pushed).
public void buttonArmEnd(JCButtonEvent e) {}

// Invoked after the button is disarmed (i.e. released).
public void buttonDisarmEnd(JCButtonEvent e) {}

// Invoked before the page is changed. 
public void tabManagerChangeBegin(JCTabManagerEvent ev) {}

// Invoked after the page is changed
public void tabManagerChangeEnd(JCTabManagerEvent e) {
	if (((Boolean)tabman.getTab(tabman.getCurrentTab()).getUserData()).
			booleanValue()) 
		totalOrder();
}

// Total up the order and place it in the send list
private void totalOrder() {
	int totalPrice = 0;
	boolean orderExists = false;
	JCVector fullOrder = new JCVector();
	JCVector allItems = list.getItems();
	sw.clear();
	for (int i = 0; i < allItems.size(); i++) {
		String qtyString = 
			(String) ((JCVector) allItems.elementAt(i)).elementAt(3);
		int qty = qtyStringToInt(qtyString);

		if (qty > 0) {
			orderExists = true;
			JCVector oneOrder = new JCVector();

			oneOrder.addElement((String)
				((JCVector) allItems.elementAt(i)).elementAt(0));
			oneOrder.addElement(qtyString);
			String priceString = cvtPrice((JCVector) allItems.elementAt(i));
			float price = priceStringToFloat(priceString);
			oneOrder.addElement("@ " + priceString);
			oneOrder.addElement(" = ");
			oneOrder.addElement("$ " + (qty * price));
			totalPrice += (qty * price);

			fullOrder.addElement(oneOrder);
		}
	}

	if (orderExists) {
		JCVector blankLine = new JCVector();
		fullOrder.addElement(blankLine);
		JCVector sumLine = new JCVector();
		sumLine.addElement(JCString.parse(this, "[FONT=Dialog-BOLD-10]Order Total"));
		sumLine.addElement("");
		sumLine.addElement("");
		sumLine.addElement("");
		sumLine.addElement(JCString.parse(this, "[FONT=Dialog-BOLD-10]$ " + totalPrice));
		fullOrder.addElement(sumLine);
	}

	sw.setItems(fullOrder);
	sw.setNumColumns(5);
}

// Convert the quantity string to an integer
private int qtyStringToInt(String qtyString) {
	int qty = 0;
	try {
		qty = Integer.valueOf(qtyString).intValue();
	} catch (NumberFormatException e) {}

	return qty;
}

// Convert the price string to a float
private float priceStringToFloat(String s) {
	float price = 0;
	try {
		price = Float.valueOf(s.substring(1)).floatValue();
	} catch (Exception e) {}

	return price;
}

String cvtPrice(Vector v) {
	Object price = v.elementAt(2);
	if (price instanceof JCString)
		return ((JCString)price).getString();
	return (price != null) ? price.toString() : "";
}

// Update the price text field from a list selection
private void updatePriceFieldFromList() {
	Vector v = (Vector) list.getSelectedItem();
	if (v != null) {
		String qtyString = (String)v.elementAt(3);
		if (qtyString == null)
			qtyString = new String("");
		qty_text.setText(qtyString);
		price_text.setText(cvtPrice(v));
		updatePriceField(qtyString, price_text.getText());
	}
}

// Update the price text field from an entry in the quantity text field
private void updatePriceFieldFromField() {
	Vector v = (Vector) list.getSelectedItem();
	if (v != null) 
		updatePriceField(qty_text.getText(), cvtPrice(v));
}

// Update the price text field with new data
private void updatePriceField(String qtyString, String priceString) {
	int qty = qtyStringToInt(qtyString);
	float price = priceStringToFloat(priceString);
	total_text.setText("$" + (price * qty));
}

public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("BWT Order Form");
	bwtgui gui = new bwtgui();
	gui.init();

	frame.add(gui);
	frame.pack();
	frame.show();
}
}
