/*
 * (c) Copyright 1996, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: launcher.java $ $Revision: 1.1 $
//            $Date: 1997/11/24 17:50:58 $  $Locker: $  KL Group Inc.

package jclass.bwt.demos.launcher;

import java.awt.*;
import jclass.bwt.*;
import jclass.util.JCString;
import java.applet.Applet;
import jclass.contrib.JCRowColLayout;
import jclass.contrib.ContribFrame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.BorderLayout;
import java.awt.Event;

/**
 * This program starts JClass BWT's demo programs
 **/
public class launcher extends java.applet.Applet
	implements Runnable, JCTabManagerListener, JCListListener,
JCActionListener {

static String[][] demos = {
	{ "Sample BWT App", "A BWT Sampler Application",
	  "jclass.bwt.demos.awt_vs_bwt.bwtgui" },
	{ "Sample AWT App", "An AWT Application similar\nto the BWT example above",
	  "jclass.bwt.demos.awt_vs_bwt.awtgui" },
	{ "Color Picker", "A Color Chooser implemented with BWT",
	  "jclass.bwt.demos.colorpicker.colorPicker" },
	{ "Print Dialogs", "Print Dialogs implemented with BWT",
	  "jclass.bwt.demos.printdlogs.PrintDlogs"}
};

private JCList demo_list;
private JCLabel demo_description;
private JCTabManager tab_manager;
private JCLabel kl_info;
private int currItem;

/**
 * Initialize demo launcher
 */
public void init() {
	setBackground(Color.lightGray);

	setLayout(new GridLayout(1,1));
	tab_manager = new JCTabManager();
	tab_manager.addTabManagerListener(this);

	demo_list = new JCList();
	demo_list.setAllowMultipleSelections(false);
	demo_list.setAutoSelect(true);
	for(int i = 0; i < demos.length; i++) {
		demo_list.addItem(demos[i][0]);
	}
	demo_list.addItemListener(this);
	demo_list.addActionListener(this);
	demo_description = new JCLabel("Double click on demo to start");
	demo_description.setHighlightThickness(2);
	Panel p = new Panel();
	p.setLayout(new BorderLayout(10,10));
	p.add("West",demo_list);
	p.add("Center",demo_description);

	kl_info = new JCLabel(JCString.parse(this,"Demos for JClass BWT by\n[IMAGE=../launcher/klg-corp.gif]"));
	tab_manager.addPage("Demos", p);
	tab_manager.addPage("Information\nAbout KL Group", kl_info);
	add(tab_manager);
	}

/**
 * Static method that starts the application
 */
public static void main(String args[]) {
	ContribFrame f = new ContribFrame("Demo Launcher");
	launcher l = new launcher();
	l.init();
	f.setLayout(new GridLayout(1,1));
	f.resize(400,300);
	f.add(l);
	f.show();	
}

public void run() {
}

public void tabManagerChangeBegin(JCTabManagerEvent e) {
}

public void tabManagerChangeEnd(JCTabManagerEvent e) {
}

public void itemStateChanged(JCItemEvent e) {
}

public void listItemSelectBegin(JCListEvent e) { 
}

public void listItemSelectEnd(JCListEvent e) {
	demo_description.setText(demos[e.getRow()][1]);
}

/**
 * Is called whenever a listener hears an event
 */
public void actionPerformed(JCActionEvent e) {
	int index = demo_list.getSelectedIndex();
	String classToCreate = demos[index][2];
	System.out.println("Creating an object of class \"" + classToCreate + "\"");
	try {
		Applet a = (Applet)Class.forName(classToCreate).newInstance();
		ContribFrame f = new ContribFrame(demos[index][0]);
		f.setLayout(new GridLayout(1,1));
		f.resize(500,400);
		f.add(a);
		a.init();
		a.start();
		f.show();
	} 
	catch(Exception ex) {
		System.out.println("No such class. Exception");
	}
}

}

