/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: lists.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:08:57 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCList;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import java.awt.*;

public class lists extends java.applet.Applet {

static int font_style_values[] = {
	Font.PLAIN, Font.BOLD, Font.ITALIC, 
};
static String font_style_names[] = {
	"plain", "bold", "italic", 
};
static String font_size_names[] = {
	"12", "14", "15", "20"
};

static String item_strings[] = {
	"check mark",
	"copy",
	"cut",
	"info",
	"x",
};

static String item_images[] = {
	"check16.gif",
	"copy16.gif",
	"cut16.gif",
	"info16.gif",
	"x16.gif",
};

static String color_names[] = {
    "red",
    "pink",
    "orange",
    "yellow",
    "green",
    "magenta",
    "cyan",
    "blue",
};
static Color color_values[] = {
    Color.red,
    Color.pink,
    Color.orange,
    Color.yellow,
    Color.green,
    Color.magenta,
    Color.cyan,
    Color.blue,
};

public void init() {
	JCList list = new JCList();
	setBackground(Color.lightGray);
    String font_names[] = getToolkit().getFontList();

	/*
	 * Image list
	 */
	list.setSpacing(5);
	list.setAllowMultipleSelections(true);
	for (int i=0; i < item_strings.length; i++) {
		String str = "[IMG=../images/" + item_images[i] + "]"
			+ "[HORIZ_SPACE=10][ALIGN=MIDDLE]"
			+ item_strings[i];
		list.addItem(JCString.parse(this, str));
	}
	add(list);

	/*
	 * Font list
	 */
	JCList font_window = new JCList(7, true);
	for (int i=0; i < font_names.length; i++) {
		for (int k=0; k < font_style_names.length; k++) {
			Font font = new Font(font_names[i], font_style_values[k], 14);
			JCString s = new JCString();
			s.add(font);
			s.add(font_names[i] + "-" + font_style_names[k] + "-" + 14);
			font_window.addItem(s);
		}
	}
	add(font_window);

	/*
	 * Color list
	 */
	list = new JCList();
	list.setFont(new Font("Dialog", Font.BOLD, 14));
	list.getList().setBackground(Color.darkGray);
	list.setSelectedBackground(Color.white);
	list.setAllowMultipleSelections(true);
	list.getList().setHighlightColor(Color.white);
	for (int i=0; i < color_names.length; i++) {
		JCString s = new JCString();
		s.add(color_values[i]);
		s.add(color_names[i]);
		list.addItem(s);
	}
	add(list);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Lists");

	lists l = new lists();
	l.init();

	fontChooser chooser = new fontChooser();
	chooser.init();
	l.add(chooser);

	frame.add(l);
	frame.pack();
	frame.show();
	chooser.start();
}
}

