/*****************************************************************************
 *
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
 * AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
 * WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
 * ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
 * AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
 * SOFTWARE IS HEREBY TRANSFERRED.
 *
 *  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
 * NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY KL GROUP INC.
 * OR ITS THIRD PARTY SUPPLIERS.
 *
 *  KL GROUP INC. AND ITS THIRD PARTY SUPPLIERS, ASSUME NO RESPONSIBILITY 
 * FOR THE USE OR INABILITY TO USE ANY OF ITS SOFTWARE.   THIS SOFTWARE IS 
 * PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, AND KL GROUP INC. EXPRESSLY 
 * DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Notice:  Notwithstanding any other lease or license that may pertain to,
 * or accompany the delivery of, this computer software, the rights of the
 * Government regarding its use, reproduction and disclosure are as set
 * forth in Section 52.227-19 of the FARS Computer Software-Restricted
 * Rights clause.
 *
 * (c) Copyright 1997 KL Group Inc.  Unpublished - all
 * rights reserved under the Copyright laws of the United States.
 *
 * RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
 * Government is subject to the restrictions as set forth in subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
 * at DFARS 52.227-7013.
 *
 * KL Group Inc.
 * 260 King Street East
 * Suite 300
 * Toronto, Ontario
 * Canada M5A 1K3
 * (416) 594-1026
 * (416) 594-1919 (FAX)
 *
 * RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
 * "restricted rights."  Use, duplication or disclosure is subject to the
 * restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
 * "Commercial Computer Software- Restricted Rights (April 1985)."  KL Group
 * Inc., 300-260 King Street E., Toronto, Ontario, Canada M5A 1K3.  If
 * the contract contains the Clause at 18-52.227-74 "Rights in Data General"
 * then the "Alternate III" clause applies.
 *
 * (c) Copyright 1997 KL Group Inc.
 * ALL RIGHTS RESERVED
 *
 *****************************************************************************/

package jclass.bwt.examples;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jclass.bwt.JCOutlinerPrinter;

/**
 * The outlinerPreview frame displays print pages and allows
 * the use to flip through the pages and send the current page or
 * all pages to the printer.
 */
public class outlinerPreview extends Frame implements WindowListener, ActionListener {

Button first_button;
Button prev_button;
Button next_button;
Button last_button;
Button print_button;
Button printall_button;
Button close_button;

ScrollPane pane;
JCOutlinerPrinter printable;
JCPrintPage print_page;

Label status;

int current_page = 0;
int num_pages = 0;
int width;
int height;

PrintJob job;

/**
 * Creates a new outlinerPreview frame
 */
public outlinerPreview(String title, JCOutlinerPrinter printable) {
	super(title);
	this.printable = printable;

	job = getToolkit().getPrintJob(this, title, null);
	if(job == null)
		return;

	Dimension pd = job.getPageDimension();
	this.width = (int)(pd.width * 1.3);
	this.height = (int)(pd.height * 1.3);
	printable.setPageDimensions(width, height);
	num_pages = printable.getNumPages();
	
	setLayout(new BorderLayout());
	setBackground(Color.lightGray);

	Panel buttons = new Panel();
	buttons.setLayout(new FlowLayout(FlowLayout.LEFT,1,1));
	buttons.add(first_button = new Button("First"));
	first_button.addActionListener(this);
	buttons.add(prev_button = new Button("Previous"));
	prev_button.addActionListener(this);
	buttons.add(next_button = new Button("Next"));
	next_button.addActionListener(this);
	buttons.add(last_button = new Button("Last"));
	last_button.addActionListener(this);
	buttons.add(print_button = new Button("Print"));
	print_button.addActionListener(this);
	buttons.add(printall_button = new Button("PrintAll"));
	printall_button.addActionListener(this);
	buttons.add(close_button = new Button("Close"));
	close_button.addActionListener(this);

	add(buttons, "North");

	pane = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
	pane.setSize((int)(width * 1.1), (int)(height * 1.1));
	pane.add(print_page = new JCPrintPage());
	print_page.setSize((int)(width * 1.1), (int)(height * 1.1));
	add(pane, "Center");

	add(status = new Label("", Label.LEFT), "South");

	addWindowListener(this);

	setSize(600,500);
	setVisible(true);
}

/**
 * Generates a new table page image and posts it to the JCPrintPage
 * canvas for display.
 */
public void showPage(int page) {
	if(job == null)
		return;

	current_page = page;
	Image image = createImage(width, height);
	Graphics gc = image.getGraphics();
	printable.drawPage(gc, page);
	print_page.setImage(image);
	gc.dispose();

	status.setText("Page " + current_page + " of " + num_pages + ".");
}

/**
 * ActionListener method
 */
public void actionPerformed(ActionEvent e) {
	if(e.getActionCommand().equals("First")) {
		showPage(1);
	} else if(e.getActionCommand().equals("Previous")) {
		if(current_page > 1)
			showPage(current_page - 1);
	} else if(e.getActionCommand().equals("Next")) {
		if(current_page + 1 <= num_pages)
			showPage(current_page + 1);
	} else if(e.getActionCommand().equals("Last")) {
		showPage(num_pages);
	} else if(e.getActionCommand().equals("Print")) {
		if(job != null) {
			Graphics gc = job.getGraphics();
			printable.drawPage(gc, current_page);
			gc.dispose();
		}
		job.end();
	} else if(e.getActionCommand().equals("PrintAll")) {
		if(job != null) {
			Graphics gc;
			for(int p = 1; p <= num_pages; p++) {
				gc = job.getGraphics();
				printable.drawPage(gc, p);
				gc.dispose();
			}
		}
		job.end();
	} else if(e.getActionCommand().equals("Close")) {
		setVisible(false);
		dispose();
	}
}

/**
 * WindowListener methods
 */
public void windowActivated(WindowEvent e) {}
public void windowClosed(WindowEvent e) {}

public void windowClosing(WindowEvent e) {
	setVisible(false);
	dispose();
}

public void windowDeactivated(WindowEvent e) {}
public void windowDeiconified(WindowEvent e) {}
public void windowIconified(WindowEvent e) {}
public void windowOpened(WindowEvent e) {}

}

class JCPrintPage extends Canvas {

Image page;

/**
 * Returns the image.
 */
public Image getImage() {
	return page;
}

/**
 * Sets the page image
 */
public void setImage(Image page) {
	this.page = page;
	repaint();
}

/**
 * Paints the table image centered on the screen.
 */
public void paint(Graphics gc) {
	Dimension d = this.getSize();

	gc.setColor(Color.gray);
	gc.fillRect(0, 0, d.width, d.height);

	if(page != null) {
		Dimension di = new Dimension(page.getWidth(this), page.getHeight(this));
		Point p = new Point((d.width - di.width)/2,(d.height - di.height)/2);
		gc.setColor(Color.black);
		gc.drawRect(p.x - 2, p.y - 2, di.width + 2, di.height + 2);
		gc.setColor(Color.white);
		gc.fillRect(p.x - 1, p.y - 1, di.width + 1, di.height + 1);
		
		gc.drawImage(page, p.x, p.y, this);
	}
}	

}