/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

package jclass.bwt.examples;

import jclass.bwt.BWTEnum;
import jclass.bwt.JCHeader;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.bwt.JCOutlinerPrinter;
import jclass.bwt.JCOutlinerPrintEvent;
import jclass.bwt.JCOutlinerPrintListener;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import jclass.util.JCString;
import jclass.util.JCVector;
import java.awt.*;
import java.awt.event.*;

import jclass.bwt.JCTextArea;

/**
 * This JDK 1.1 example demonstrates how to print a JCOutliner.
 */
public class outlinerPrint extends java.applet.Applet 
	implements ActionListener, JCOutlinerPrintListener {

JCOutliner	outliner;
Image		logo;
Checkbox	outline_cb;
Checkbox	header_cb;
Checkbox	allnodes_cb;
Image		content_icon;

final static String[] column_labels = { "Name", "Title", "Address", "Phone", "Salary" };
final static String dept[] = { "Management", "Accounting", "R&D" };

final static String mgmt_items[] = {
"01 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"02 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"03 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"04 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"05 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"06 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"07 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"08 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"09 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"10 John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
};

final static String accounting_items[] = {
"01 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"02 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"03 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"04 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"05 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"06 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"07 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"08 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"09 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"10 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"11 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"12 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"13 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"14 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"15 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"16 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"17 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"18 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"19 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"20 Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
};

final static String rd_items[] = {
"01 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"02 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"03 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"04 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"05 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"06 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"07 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"08 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"09 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"10 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"11 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"12 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"13 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"14 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"15 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"16 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"17 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"18 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"19 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"20 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"21 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"22 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"23 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"24 James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
};

final static String[][] item_data = { mgmt_items, accounting_items, rd_items };

public void init() {
	Image folder_opened = JCUtilConverter.toImage(this, "../images/foldero.gif");
	Image folder_closed = JCUtilConverter.toImage(this, "../images/folderc.gif");
	Image top = JCUtilConverter.toImage(this, "../images/top.gif");
	content_icon = JCUtilConverter.toImage(this, "../images/content.gif");
	logo = jclass.util.JCUtilConverter.toImage(this, "../images/klg_logo.gif");
	
	// Force outliner to be same size as applet
	setLayout(new BorderLayout());
	setBackground(Color.lightGray);

	JCOutlinerNodeStyle style = new JCOutlinerNodeStyle();
	style.setFolderOpenIcon(top);
	style.setFolderClosedIcon(top);

	JCOutlinerFolderNode root = new JCOutlinerFolderNode(null, "Personnel");
	root.setStyle(style);

	JCOutlinerNodeStyle folder_style = new JCOutlinerNodeStyle();
	folder_style.setFolderClosedIcon(folder_closed);
	folder_style.setFolderOpenIcon(folder_opened);
	folder_style.setShortcut(true);

	JCOutlinerNodeStyle nodestyle = new JCOutlinerNodeStyle();
	nodestyle.setItemIcon(content_icon);
	nodestyle.setFont(new Font("Dialog",Font.PLAIN,12));

	JCOutlinerFolderNode f = null;
	for (int i=0; i < dept.length; i++) {
		f = new JCOutlinerFolderNode(null, BWTEnum.FOLDER_CLOSED, dept[i]);
		f.setStyle(folder_style);
		root.addNode(f);
				
		String[] items = item_data[i];
		for (int j=0; j < items.length; j++) {
			JCVector label = outliner.getConverter().toVector(this, items[j], '|', false);
			JCOutlinerNode newItem = new JCOutlinerNode(label); 
			newItem.setStyle(nodestyle);
			f.addNode(newItem);
		}
	}
	// open the last folder
	f.setState(JCOutliner.FOLDER_OPEN_ALL);
	
	outliner = new JCOutliner(root);
	outliner.getOutliner().setBackground(Color.white);
	outliner.setPreferredSize(400, 300);
	outliner.setColumnLabels(column_labels);
	outliner.setNumColumns(column_labels.length);
	outliner.getDefaultNodeStyle().setShortcut(true);
			
	JCHeader header = outliner.getHeader();
	header.setBackground(Color.white);
	header.setForeground(Color.black);

	outliner.addPrintListener(this);

	add("Center", outliner);

	Panel options = new Panel();
	options.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	
	outline_cb = new Checkbox("OutlineOnEachPage");
	outline_cb.setState(true);
	options.add(outline_cb);
	header_cb = new Checkbox("HeaderOnEachPage");
	header_cb.setState(true);
	options.add(header_cb);
	allnodes_cb = new Checkbox("PrintAllNodes");
	allnodes_cb.setState(true);
	options.add(allnodes_cb);

	Button print_button = new Button("Preview");
	print_button.addActionListener(this);
	options.add(print_button);

	add("South", options);
}

public void actionPerformed(ActionEvent event) {
	if(event.getActionCommand().equals("Preview")) {
		JCOutlinerPrinter printer = outliner.getOutliner().getOutlinerPrinter();
		printer.setOutlineOnEachPage(outline_cb.getState());
		printer.setHeaderOnEachPage(header_cb.getState());
		printer.setPrintAllNodes(allnodes_cb.getState());
		printer.setPageMargins(new Insets(logo.getHeight(this) + 36, 72, 72, 72));
		outlinerPreview preview = new outlinerPreview("JCOutliner Print", printer);
		preview.showPage(1);
	}
}
 
public Insets insets() {
	return new Insets(5,5,5,5);
}

/*
 * Prints a logo and text on the top of every page
 */
public void printPageHeader(JCOutlinerPrintEvent e) {
	Graphics gc = e.getGraphics();
	Rectangle r = gc.getClipRect();

	gc.drawImage(logo, 0, (r.height - logo.getHeight(this))/2, this);

	gc.setFont(new Font("Dialog",Font.BOLD, 14));
	FontMetrics fm = gc.getFontMetrics();
	
	String note1 = "JCOutliner Printing";
	String note2 = "With Header/Footer Customization";

	int top = (r.height - fm.getHeight() * 2)/2 + fm.getAscent();
	gc.drawString(note1, r.width - fm.stringWidth(note1), top);
	gc.drawString(note2, r.width - fm.stringWidth(note2), top + fm.getHeight());	
}

/*
 * Prints the page number and text on the bottom of every page
 */
public void printPageFooter(JCOutlinerPrintEvent e) {
	Graphics gc = e.getGraphics();	
	Rectangle r = gc.getClipRect();

	FontMetrics fm = gc.getFontMetrics();

	String page = "Page " + e.getPage();
	String note = "Use JCOutlinerPrintListener to customize the header and footer!";

	gc.drawString(page, 0, r.height/2);
	gc.drawString(note, r.width - fm.stringWidth(note), r.height/2);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Outliner Print");
	outlinerPrint o = new outlinerPrint();

	o.init();
	frame.add(o);
	frame.pack();
	frame.show();
}

}

