/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: progressMeter.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:08:58 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCProgressMeter;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;
import java.awt.*;

/**
 * This example demonstrates the use of a JCProgressMeter.
 */
public class progressMeter extends java.applet.Applet 
implements Runnable, JCActionListener {

JCProgressMeter meter1, meter2, meter3;
Thread thread;

// JCActionListener method
public void actionPerformed(JCActionEvent ev) {
	if (thread != null) {
		thread.yield();
		thread.stop();
	}
	thread = new Thread(this);
	thread.start();
}

public void init() {
	setBackground(Color.lightGray);
	setLayout(new JCGridLayout(JCGridLayout.VARIABLE, 1));

	add(meter1 = new JCProgressMeter(0, 0, 100));

	add(meter2 = new JCProgressMeter(0, 0, 5000));
	meter2.setAutoLabel(false);
	meter2.setBarColor(Color.blue);
	meter2.setBarCount(0);
	meter2.setLabelPosition(BWTEnum.STRING_TOP);

	add(meter3 = new JCProgressMeter(0, 0, 100));
	meter3.setBarCount(0);
	meter3.setLabelPosition(BWTEnum.STRING_CENTER);

	JCButton btn = new JCButton("Start");
	btn.addActionListener(this);
	add(btn);
}

/** Updates the meter randomly. */
public void run() {
	int count = 0, sleep = 50;
	meter1.setValue(0);
	meter2.setValue(0);
	meter3.setValue(0);
	while (true) {
		try {
			Thread.sleep(sleep);
		} catch (Exception e) {}

		if (meter1.getValue() == meter1.getMaximum()
			&& meter2.getValue() == meter2.getMaximum()
			&& meter3.getValue() == meter2.getMaximum()) 
			stop();
		if (!Thread.currentThread().isAlive() || thread == null) 
			return;
		if ((count % (1000/sleep)) == 0) {
			meter1.setValue(meter1.getValue() + (int)(Math.random()*20.));
			meter2.setValue(meter2.getValue() + 250);
			meter2.setLabel("Time Left: "+meter2.getTimeToCompletionString());
		}
		meter3.setValue(meter3.getValue() + 1);
		count++;
	}
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("ProgressMeter");
	progressMeter s = new progressMeter();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
