/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: slider.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:09:00 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCSlider;
import jclass.contrib.ContribFrame;
import java.awt.*;

/**
 * This example demonstrates the a JCSlider.
 */
public class slider extends java.applet.Applet implements JCAdjustmentListener {

JCLabel label;

public void adjustmentValueChanged(JCAdjustmentEvent ev) {
	label.setLabel(""+ev.getValue());
}

public void init() {
	setBackground(Color.lightGray);
	setLayout(new JCGridLayout(BWTEnum.VARIABLE, 1));

	label = new JCLabel();
	label.setAlignment(JCLabel.BOTTOMCENTER);
	add(label);

	JCSlider sb = new JCSlider(JCSlider.HORIZONTAL, 0, 0, 100);
	sb.addAdjustmentListener(this);
	sb.setValue(50, true);
	sb.setMinimumLabel(new JCLabel("0"));
	sb.setMaximumLabel(new JCLabel("100"));
	add(sb);
}

public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Slider");
	slider s = new slider();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
