/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

//   RCSID -- $RCSfile: JCDialogCB.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 18:22:00 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.Button;

/**
 * The JCDialogCB interface defines a button callback member called
 * by JCDialog when one of the buttons is pressed.  By implementing
 * this interface and calling JCDialog.setButtonCB(), the user can
 * route callback processing to his/her own class. <P>
 */
public interface JCDialogCB {
	/**
	 * The button callback member.
	 *
	 * @param dialog - the dialog on which the callback occurred
	 * @param button - the button that was pressed
	 */
    boolean buttonCB(JCDialog dialog, Button b);
}
