/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntDictEvent;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelEvent;

public class JKModelRowsChangedEvent
extends JKModelEvent {
    int firstRow;
    Object[] oldRows;
    Object[] newRows;
    Object[] newRowAdapters;
    Object[] newCachedRows;
    Object[] newCachedRowAdapters;
    Object[] rowsAdded;
    Object[] rowAdaptersAdded;
    Object[] cachedRowsAdded;
    Object[] cachedRowAdaptersAdded;
    Object[] rowsRemoved;

    public JKModelRowsChangedEvent(JKModel jKModel, int n, Object[] objectArray) {
        super(jKModel);
        if (objectArray == null) {
            throw new IllegalArgumentException("null rows changed");
        }
        this.firstRow = n;
        this.oldRows = objectArray;
    }

    public int getFirst() {
        return this.firstRow;
    }

    public int getSize() {
        return this.oldRows.length;
    }

    public OSIEnumeration getNew() {
        if (this.newRows == null) {
            this.newRows = this.getModel().getRowArray(this.firstRow, this.oldRows.length);
        }
        return OSIEnumeration.newFor((Object[])this.newRows);
    }

    public OSIEnumeration getNewAdapters() {
        if (this.newRowAdapters == null) {
            this.newRowAdapters = this.getModel().getRowAdapterArray(this.firstRow, this.oldRows.length);
        }
        return OSIEnumeration.newFor((Object[])this.newRowAdapters);
    }

    public OSIEnumeration getCachedNew() {
        if (this.newCachedRows == null) {
            this.newCachedRows = this.getModel().getCachedRowArray(this.firstRow, this.oldRows.length);
        }
        return OSIEnumeration.newFor((Object[])this.newCachedRows);
    }

    public OSIEnumeration getCachedNewAdapters() {
        if (this.newCachedRowAdapters == null) {
            this.newCachedRowAdapters = this.getModel().getCachedRowAdapterArray(this.firstRow, this.oldRows.length);
        }
        return OSIEnumeration.newFor((Object[])this.newCachedRowAdapters);
    }

    public OSIEnumeration getOld() {
        return OSIEnumeration.newFor((Object[])this.oldRows);
    }

    public OSIEnumeration getAdded() {
        if (this.rowsAdded == null) {
            this.rowsAdded = OSIIntDictEvent.subtract((OSIEnumeration)this.getNew(), (OSIEnumeration)this.getOld());
        }
        return OSIEnumeration.newFor((Object[])this.rowsAdded);
    }

    public OSIEnumeration getAdaptersAdded() {
        if (this.rowAdaptersAdded == null) {
            this.rowAdaptersAdded = OSIIntDictEvent.subtract((OSIEnumeration)this.getNewAdapters(), (OSIEnumeration)this.getOld());
        }
        return OSIEnumeration.newFor((Object[])this.rowAdaptersAdded);
    }

    public OSIEnumeration getCachedAdded() {
        if (this.cachedRowsAdded == null) {
            this.cachedRowsAdded = OSIIntDictEvent.subtract((OSIEnumeration)this.getCachedNew(), (OSIEnumeration)this.getOld());
        }
        return OSIEnumeration.newFor((Object[])this.cachedRowsAdded);
    }

    public OSIEnumeration getCachedAdaptersAdded() {
        if (this.cachedRowAdaptersAdded == null) {
            this.cachedRowAdaptersAdded = OSIIntDictEvent.subtract((OSIEnumeration)this.getCachedNewAdapters(), (OSIEnumeration)this.getOld());
        }
        return OSIEnumeration.newFor((Object[])this.cachedRowAdaptersAdded);
    }

    public OSIEnumeration getRemoved() {
        if (this.rowsRemoved == null) {
            this.rowsRemoved = OSIIntDictEvent.subtract((OSIEnumeration)this.getOld(), (OSIEnumeration)this.getNew());
        }
        return OSIEnumeration.newFor((Object[])this.rowsRemoved);
    }

    public JKTableArea getArea() {
        return JKTableArea.newForRows(this.firstRow, this.oldRows.length);
    }
}

