/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIArray;
import com.objectshare.base.util.OSIIntArray;
import com.objectshare.base.util.OSIIntDictionary;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKColHdrsJKRA;
import com.objectshare.grid.data.JKColumnAdapter;
import com.objectshare.grid.data.JKElement;
import com.objectshare.grid.data.JKElementListener;
import com.objectshare.grid.data.JKHierarchicalAdapter;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.data.OSIIntDictionaryJKRA;
import com.objectshare.grid.data.ObjectJKRA;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;

public class JKRowAdapter
implements JKHierarchicalAdapter,
JKElementListener,
Observer,
Cloneable,
Serializable {
    JKTableModel model;
    Object rowObject;
    Object rowHeader;
    int cachedRowNum;
    JKRowAdapter parentAdapter;
    OSIArray childAdapters;
    boolean expanded;
    OSIIntDictionary columnAdapters;
    String rowType;
    static Hashtable rowAdapterClassMap = new Hashtable();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getRowAdapterClassNameFor(JKTableModel jKTableModel, Object object) {
        try {
            Class<?> clazz;
            if (object instanceof String) {
                clazz = Class.forName((String)object);
            } else if (object instanceof Class) {
                clazz = (Class<?>)object;
            } else if (object != null) {
                clazz = object.getClass();
            } else {
                return "null";
            }
            Object object2 = JKRowAdapter.getRowAdapterOrNullFor(jKTableModel, clazz);
            if (object2 instanceof Class) {
                return ((Class)object2).getName();
            }
            if (object2 != null) {
                return object2.getClass().getName();
            }
            return "null";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "null";
        }
    }

    public static JKRowAdapter newFor(JKTableModel jKTableModel, int n, Object object) {
        JKRowAdapter jKRowAdapter;
        if (object == null) {
            return null;
        }
        Object object2 = JKRowAdapter.getRowAdapterFor(jKTableModel, object.getClass());
        if (object2 == null) {
            throw new Error("null row adapter");
        }
        if (object2 instanceof Class) {
            try {
                jKRowAdapter = (JKRowAdapter)((Class)object2).newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new Error("cannot instantiate row adapter: " + ((Class)object2).getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("illegal access exception: " + ((Class)object2).getName());
            }
        }
        try {
            jKRowAdapter = (JKRowAdapter)((JKRowAdapter)object2).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("cannot clone row adapter instance: " + object2.getClass().getName());
        }
        jKRowAdapter.initialize(jKTableModel, n, object);
        return jKRowAdapter;
    }

    public static Object getRowAdapterFor(JKTableModel jKTableModel, Class clazz) {
        Object object = JKRowAdapter.getRowAdapterOrNullFor(jKTableModel, clazz);
        if (object != null) {
            return object;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            object = JKRowAdapter.getRowAdapterOrNullFor(jKTableModel, classArray[n]);
            if (object != null) {
                rowAdapterClassMap.put(clazz.getName(), object);
                return object;
            }
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            object = JKRowAdapter.getRowAdapterFor(jKTableModel, clazz2);
            rowAdapterClassMap.put(clazz.getName(), object);
            return object;
        }
        Object v = rowAdapterClassMap.get(clazz.getName());
        String string = "";
        if (v != null) {
            string = String.valueOf(v.toString()) + ".class ";
        }
        throw new Error("Cannot locate JKRA class file " + string + "for " + clazz);
    }

    public static Object getRowAdapterOrNullFor(JKTableModel jKTableModel, Class clazz) {
        Object object = jKTableModel.getRowAdapterOrNullFor(clazz);
        if (object != null) {
            return object;
        }
        object = JKRowAdapter.getRowAdapterOrNullFor(clazz, rowAdapterClassMap);
        if (object != null) {
            return object;
        }
        try {
            String string = String.valueOf(clazz.getName()) + "JKRA";
            if (!string.toLowerCase().startsWith("java.")) {
                Class<?> clazz2 = Class.forName(string);
                JKRowAdapter.validateRowAdapterClass(clazz2);
                rowAdapterClassMap.put(clazz.getName(), clazz2);
                return clazz2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    public static Object getRowAdapterOrNullFor(Class clazz, Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(clazz.getName());
        if (v instanceof String) {
            try {
                Class<?> clazz2 = Class.forName((String)v);
                JKRowAdapter.validateRowAdapterClass(clazz2);
                hashtable.put(clazz.getName(), clazz2);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("class not found exception: " + v);
            }
        }
        return v;
    }

    public static void addRowType(String string, String string2) {
        JKRowAdapter.addRowAdapterAssociation(string, string2);
    }

    public static void addRowAdapterAssociation(Object object, Object object2) {
        JKRowAdapter.addRowAdapterAssociation(object, object2, rowAdapterClassMap);
    }

    protected static void addRowAdapterAssociation(Object object, Object object2, Hashtable hashtable) {
        if (object == null) {
            throw new IllegalArgumentException("must specify row object class or class name or instance");
        }
        String string = object instanceof String ? (String)object : (object instanceof Class ? ((Class)object).getName() : object.getClass().getName());
        if (!(object2 instanceof String || object2 instanceof Class || object2 instanceof JKRowAdapter)) {
            throw new IllegalArgumentException("must specify row adapter class or class name or instance");
        }
        hashtable.put(string, object2);
    }

    public static void removeRowType(String string) {
        JKRowAdapter.removeRowAdapterAssociation(string);
    }

    public static void removeRowAdapterAssociation(String string) {
        rowAdapterClassMap.remove(string);
    }

    protected static Object newInstanceFor(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Error(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(String.valueOf(clazz.getName()) + ".class file not found or class is not visible.");
            throw new Error(illegalAccessException.toString());
        }
    }

    protected static void validateRowAdapterClass(Class clazz) {
        Object object = JKRowAdapter.newInstanceFor(clazz);
        if (object instanceof JKRowAdapter) {
            return;
        }
        throw new Error("Not JKRowAdapter subclass: " + clazz);
    }

    public JKTableModel getModel() {
        return this.model;
    }

    public Object getRowObject() {
        return this.rowObject;
    }

    public int getRowNumber() throws NoSuchElementException {
        this.cachedRowNum = this.model.getRowNumberForAdapter(this, this.cachedRowNum);
        return this.cachedRowNum;
    }

    public int getRowNumberOrZero() throws NoSuchElementException {
        try {
            this.cachedRowNum = this.model.getRowNumberForAdapter(this, this.cachedRowNum);
            return this.cachedRowNum;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.model.parentAdapter == this) {
                return 0;
            }
            throw (NoSuchElementException)noSuchElementException.fillInStackTrace();
        }
    }

    public Object getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(Object object) {
        this.rowHeader = object;
    }

    public JKHierarchicalAdapter getParentAdapter() {
        return this.parentAdapter;
    }

    public void setParentAdapter(JKRowAdapter jKRowAdapter) {
        this.parentAdapter = jKRowAdapter;
    }

    public int getHierarchicalIndent() {
        return this.model.getHierarchicalIndentForRowAdapter(this);
    }

    public boolean isLastChild() {
        if (this.parentAdapter != null) {
            return this.parentAdapter.isLastChildAdapter(this);
        }
        return true;
    }

    public boolean isLastChildAdapter(Object object) {
        Object[] objectArray = this.getChildAdapters();
        return objectArray != null && objectArray.length > 0 && objectArray[objectArray.length - 1] == object;
    }

    public boolean mayHaveChildren() {
        return this.canHaveChildren() && (this.childAdapters == null || this.childAdapters.toArray().length > 0);
    }

    public Object[] getChildAdapters() {
        if (!this.canHaveChildren()) {
            return null;
        }
        if (this.childAdapters == null) {
            Object[] objectArray = this.getChildren();
            if (objectArray == null) {
                return null;
            }
            this.childAdapters = new OSIArray();
            int n = 0;
            while (n < objectArray.length) {
                this.childAdapters.add((Object)this.newChildAdapterFor(objectArray[n]));
                ++n;
            }
        }
        return this.childAdapters.toArray();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public synchronized void expand() {
        if (!this.expanded && this.canHaveChildren()) {
            if (this.getChildAdapters() != null) {
                this.expanded = true;
                this.model.insertRows(this.rowObject == this.model.getParent() ? 1 : this.getRowNumber() + 1, this.visibleChildRowObjects());
            }
            if (this.rowObject != this.model.getParent()) {
                this.model.triggerChanged(this.getRowNumber(), 1);
            }
        }
    }

    public synchronized void collapse() {
        if (this.areChildrenVisible() && this.childAdapters != null) {
            this.model.removeRows(this.visibleChildRowObjects());
            this.expanded = false;
        }
    }

    public boolean areChildrenVisible() {
        return this.expanded && (this.parentAdapter == null || this.parentAdapter.areChildrenVisible());
    }

    public JKRowAdapter[] visibleAdapters() {
        OSIArray oSIArray = new OSIArray(50);
        oSIArray.add((Object)this);
        this.addVisibleChildAdaptersTo(oSIArray);
        return this.adaptersFor(oSIArray.toArray());
    }

    public Object[] visibleRowObjects() {
        OSIArray oSIArray = new OSIArray(50);
        oSIArray.add(this.rowObject);
        this.addVisibleChildRowObjectsTo(oSIArray);
        return oSIArray.toArray();
    }

    public int[] visibleRowNumbers() {
        OSIIntArray oSIIntArray = new OSIIntArray(50);
        oSIIntArray.add(this.getRowNumber());
        this.addVisibleChildRowNumbersTo(oSIIntArray);
        return oSIIntArray.toArray();
    }

    public int countVisibleChildAdapters() {
        if (!this.expanded) {
            return 0;
        }
        Object[] objectArray = this.childAdapters.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += ((JKRowAdapter)objectArray[n2]).countVisibleChildAdapters();
            ++n2;
        }
        return n;
    }

    public JKRowAdapter[] visibleChildAdapters() {
        OSIArray oSIArray = new OSIArray(50);
        this.addVisibleChildAdaptersTo(oSIArray);
        return this.adaptersFor(oSIArray.toArray());
    }

    public Object[] visibleChildRowObjects() {
        OSIArray oSIArray = new OSIArray(50);
        this.addVisibleChildRowObjectsTo(oSIArray);
        return oSIArray.toArray();
    }

    public int[] visibleChildRowNumbers() {
        OSIIntArray oSIIntArray = new OSIIntArray(50);
        this.addVisibleChildRowNumbersTo(oSIIntArray);
        return oSIIntArray.toArray();
    }

    public void addVisibleChildAdaptersTo(OSIArray oSIArray) {
        if (this.expanded) {
            Object[] objectArray = this.childAdapters.toArray();
            int n = 0;
            while (n < objectArray.length) {
                JKRowAdapter jKRowAdapter = (JKRowAdapter)objectArray[n];
                oSIArray.add((Object)jKRowAdapter);
                jKRowAdapter.addVisibleChildAdaptersTo(oSIArray);
                ++n;
            }
        }
    }

    public void addVisibleChildRowObjectsTo(OSIArray oSIArray) {
        if (this.expanded) {
            Object[] objectArray = this.childAdapters.toArray();
            int n = 0;
            while (n < objectArray.length) {
                JKRowAdapter jKRowAdapter = (JKRowAdapter)objectArray[n];
                oSIArray.add(jKRowAdapter.getRowObject());
                jKRowAdapter.addVisibleChildRowObjectsTo(oSIArray);
                ++n;
            }
        }
    }

    public void addVisibleChildRowNumbersTo(OSIIntArray oSIIntArray) {
        if (this.expanded) {
            Object[] objectArray = this.childAdapters.toArray();
            int n = 0;
            while (n < objectArray.length) {
                JKRowAdapter jKRowAdapter = (JKRowAdapter)objectArray[n];
                oSIIntArray.add(jKRowAdapter.getRowNumber());
                jKRowAdapter.addVisibleChildRowNumbersTo(oSIIntArray);
                ++n;
            }
        }
    }

    public JKRowAdapter newChildAdapterFor(Object object) {
        JKRowAdapter jKRowAdapter = this.model.newRowAdapterFor(this, object);
        return jKRowAdapter;
    }

    public JKRowAdapter[] getCachedChildAdaptersFor(Object[] objectArray) {
        JKRowAdapter[] jKRowAdapterArray = this.visibleChildAdapters();
        Object object = objectArray[0];
        int n = 0;
        while (n < jKRowAdapterArray.length) {
            if (jKRowAdapterArray[n].getRowObject() == object) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (n + n2 >= jKRowAdapterArray.length || jKRowAdapterArray[n + n2].getRowObject() != objectArray[n2]) {
                        return null;
                    }
                    ++n2;
                }
                if (n == 0 && n2 == jKRowAdapterArray.length) {
                    return jKRowAdapterArray;
                }
                JKRowAdapter[] jKRowAdapterArray2 = new JKRowAdapter[n2];
                System.arraycopy(jKRowAdapterArray, n, jKRowAdapterArray2, 0, n2);
                return jKRowAdapterArray2;
            }
            ++n;
        }
        return null;
    }

    JKRowAdapter[] adaptersFor(Object[] objectArray) {
        JKRowAdapter[] jKRowAdapterArray = new JKRowAdapter[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            jKRowAdapterArray[n] = (JKRowAdapter)objectArray[n];
            ++n;
        }
        return jKRowAdapterArray;
    }

    public OSIIntDictionary getColumnAdapters() {
        if (this.columnAdapters == null) {
            this.columnAdapters = this.model.existingColumnAdapters(this.getRowType());
        }
        return this.columnAdapters;
    }

    public String getRowType() {
        if (this.rowType == null) {
            this.rowType = this.model.existingOrInheritedRowType(this.rowObject.getClass());
        }
        return this.rowType;
    }

    protected void updateColumnAdapters() {
        this.rowType = null;
        this.columnAdapters = null;
    }

    public void triggerChanged() {
        this.model.triggerChanged(this);
    }

    public void triggerChanged(int n) {
        this.model.triggerChanged(this, n);
    }

    public void triggerChanged(int n, int n2) {
        this.model.triggerChanged(this, n, n2);
    }

    public void triggerChanged(String string) {
        this.model.triggerChanged(this, string);
    }

    public void triggerChanged(JKTableArea jKTableArea) {
        this.model.triggerChanged(jKTableArea);
    }

    public synchronized void childrenAdded() {
        if (this.childAdapters == null) {
            return;
        }
        Object[] objectArray = this.getChildren();
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        Object[] objectArray2 = this.childAdapters.toArray();
        if (objectArray2.length == 0) {
            this.childrenAdded(objectArray);
            return;
        }
        OSIArray oSIArray = new OSIArray();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            int n3 = n;
            while (((JKRowAdapter)objectArray2[n]).getRowObject() != object) {
                if (++n >= objectArray2.length) {
                    n = 0;
                }
                if (n != n3) continue;
                oSIArray.add(object);
                break;
            }
            ++n2;
        }
        if (oSIArray.toArray().length > 0) {
            this.childrenAdded(oSIArray.toArray());
        }
    }

    public synchronized void childrenAdded(Object[] objectArray) {
        if (this.childAdapters == null) {
            return;
        }
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.childAdapters.add((Object)this.newChildAdapterFor(objectArray[n]));
            ++n;
        }
        if (this.areChildrenVisible()) {
            this.model.insertRows(this.getRowNumberOrZero() + this.countVisibleChildAdapters() - objectArray.length + 1, objectArray);
        }
    }

    public synchronized void childAdded(Object object) {
        Object[] objectArray = new Object[]{object};
        this.childrenAdded(objectArray);
    }

    public synchronized void childrenRemoved() {
        Object[] objectArray;
        if (this.childAdapters == null) {
            return;
        }
        Object[] objectArray2 = this.getChildren();
        if (objectArray2 != null) {
            objectArray = new Object[objectArray2.length];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            objectArray2 = objectArray;
        } else {
            objectArray2 = new Object[]{};
        }
        objectArray = this.areChildrenVisible() ? new OSIIntArray() : null;
        int n = 0;
        Object[] objectArray3 = this.childAdapters.copyArray();
        int n2 = 0;
        while (n2 < objectArray3.length) {
            block8: {
                JKRowAdapter jKRowAdapter = (JKRowAdapter)objectArray3[n2];
                Object object = jKRowAdapter.getRowObject();
                int n3 = n;
                do {
                    if (objectArray2.length <= 0) continue;
                    if (objectArray2[n] == object) {
                        objectArray2[n] = null;
                        break block8;
                    }
                    if (++n < objectArray2.length) continue;
                    n = 0;
                } while (n != n3);
                this.childAdapters.remove((Object)jKRowAdapter);
                if (objectArray != null) {
                    objectArray.addAll(jKRowAdapter.visibleRowNumbers());
                }
                jKRowAdapter.disconnect();
                jKRowAdapter.release();
            }
            ++n2;
        }
        if (objectArray != null && objectArray.toArray().length > 0) {
            this.model.removeRows(objectArray.toArray());
        }
    }

    public synchronized void childrenRemoved(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.childAdapters == null) {
            return;
        }
        Object[] objectArray2 = this.childAdapters.copyArray();
        if (objectArray2.length == 0) {
            return;
        }
        OSIIntArray oSIIntArray = this.areChildrenVisible() ? new OSIIntArray() : null;
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            int n3 = n;
            do {
                JKRowAdapter jKRowAdapter;
                if ((jKRowAdapter = (JKRowAdapter)objectArray2[n]).getRowObject() == object) {
                    this.childAdapters.remove((Object)jKRowAdapter);
                    if (oSIIntArray != null) {
                        oSIIntArray.addAll(jKRowAdapter.visibleRowNumbers());
                    }
                    jKRowAdapter.disconnect();
                    jKRowAdapter.release();
                    objectArray2[n] = null;
                    break;
                }
                if (++n < objectArray2.length) continue;
                n = 0;
            } while (n != n3);
            ++n2;
        }
        if (oSIIntArray != null && oSIIntArray.toArray().length > 0) {
            this.model.removeRows(oSIIntArray.toArray());
        }
    }

    public synchronized void childRemoved(Object object) {
        if (this.childAdapters != null) {
            Object[] objectArray = this.childAdapters.toArray();
            int n = 0;
            while (n < objectArray.length) {
                JKRowAdapter jKRowAdapter = (JKRowAdapter)objectArray[n];
                if (jKRowAdapter.getRowObject() == object) {
                    this.childAdapters.remove((Object)jKRowAdapter);
                    if (this.areChildrenVisible()) {
                        this.model.removeRows(jKRowAdapter.visibleRowObjects());
                    }
                    jKRowAdapter.disconnect();
                    jKRowAdapter.release();
                    return;
                }
                ++n;
            }
        }
    }

    public synchronized void childrenReordered() {
        Object object;
        if (this.childAdapters == null) {
            return;
        }
        Object[] objectArray = this.getChildren();
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        OSIArray oSIArray = new OSIArray();
        int n = 0;
        boolean bl = false;
        Object[] objectArray2 = this.childAdapters.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2];
            int n3 = n;
            do {
                if (((JKRowAdapter)objectArray2[n]).getRowObject() == object) {
                    oSIArray.add(objectArray2[n]);
                    if (++n != oSIArray.size()) {
                        bl = true;
                    }
                    if (n < objectArray2.length) break;
                    n = 0;
                    break;
                }
                if (++n < objectArray2.length) continue;
                n = 0;
            } while (n != n3);
            ++n2;
        }
        if (!bl) {
            return;
        }
        if (oSIArray.size() < objectArray2.length) {
            n = 0;
            while (n < objectArray2.length) {
                if (!oSIArray.contains(objectArray2[n])) {
                    oSIArray.add(objectArray2[n]);
                }
                ++n;
            }
        }
        this.childAdapters = oSIArray;
        if (!this.areChildrenVisible()) {
            return;
        }
        objectArray2 = this.childAdapters.toArray();
        object = new OSIArray();
        n = 0;
        while (n < objectArray2.length) {
            object.addAll(((JKRowAdapter)objectArray2[n]).visibleRowObjects());
            ++n;
        }
        this.model.reorderRows(this.getRowNumberOrZero() + 1, object.toArray());
    }

    public void childrenChanged() {
        this.childrenRemoved();
        this.childrenAdded();
        this.childrenReordered();
    }

    public void elementChanged(Object object, int n) {
        this.triggerChanged();
    }

    public void elementChanged(Object object, String string) {
        this.triggerChanged(string);
    }

    public void elementChanged(Object object) {
        this.triggerChanged();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof String) {
            this.triggerChanged((String)object);
            return;
        }
        this.triggerChanged();
    }

    public void initialize(JKTableModel jKTableModel, int n, Object object) {
        this.model = jKTableModel;
        this.rowObject = object;
        this.cachedRowNum = n;
    }

    public void connect() {
        if (this.rowObject instanceof JKElement) {
            ((JKElement)this.rowObject).addElementListener(this);
            return;
        }
        if (this.rowObject instanceof Observable) {
            ((Observable)this.rowObject).addObserver(this);
        }
    }

    public void disconnect() {
        if (this.rowObject instanceof JKElement) {
            ((JKElement)this.rowObject).removeElementListener(this);
            return;
        }
        if (this.rowObject instanceof Observable) {
            ((Observable)this.rowObject).deleteObserver(this);
        }
    }

    public void release() {
        this.disconnect();
        this.parentAdapter = null;
        if (this.childAdapters != null) {
            Object[] objectArray = this.childAdapters.toArray();
            int n = 0;
            while (n < objectArray.length) {
                ((JKRowAdapter)objectArray[n]).release();
                ++n;
            }
            this.childAdapters = null;
            this.expanded = false;
        }
    }

    public Object getField(int n, int n2, JKColumnAdapter jKColumnAdapter) {
        return jKColumnAdapter.getField(n, n2, this.rowObject);
    }

    public void setField(int n, int n2, JKColumnAdapter jKColumnAdapter, Object object) {
        jKColumnAdapter.setField(n, n2, this.rowObject, object);
    }

    public boolean canHaveChildren() {
        return this.getChildren() != null;
    }

    public Object[] getChildren() {
        return null;
    }

    static {
        JKRowAdapter.addRowAdapterAssociation("java.lang.Object", new ObjectJKRA().getClass());
        JKRowAdapter.addRowAdapterAssociation("java.util.Observable", new JKRowAdapter().getClass());
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.base.util.OSIIntDictionary", new OSIIntDictionaryJKRA().getClass());
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.base.util.OSIIntHashtable", new OSIIntDictionaryJKRA().getClass());
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.data.JKColHdrs", new JKColHdrsJKRA().getClass());
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.data.JKHierarchicalTableElem", "com.objectshare.grid.data.JKHierTableElemJKRA");
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.data.JKHierarchicalElem", "com.objectshare.grid.data.JKHierarchicalElemJKRA");
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.data.JKTableElement", "com.objectshare.grid.data.JKTableElementJKRA");
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.data.JKModelElem", "com.objectshare.grid.data.JKModelElemJKRA");
    }
}

