/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.listing;

import com.objectshare.grid.example.JKExampleApplet;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.listing.RealEstateListing;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKBlockCellSelectTool;
import com.objectshare.grid.tool.JKCompositeTool;
import com.objectshare.grid.tool.JKExtendedColSelectTool;
import com.objectshare.grid.tool.JKExtendedRowSelectTool;
import com.objectshare.grid.tool.JKMultiColSelectTool;
import com.objectshare.grid.tool.JKMultiRowSelectTool;
import com.objectshare.grid.tool.JKReorderCellTool;
import com.objectshare.grid.tool.JKReorderColTool;
import com.objectshare.grid.tool.JKReorderRowTool;
import com.objectshare.grid.tool.JKResizeCellTool;
import com.objectshare.grid.tool.JKResizeColTool;
import com.objectshare.grid.tool.JKResizeRowTool;
import com.objectshare.grid.tool.JKSingleCellSelectTool;
import com.objectshare.grid.tool.JKSingleColSelectTool;
import com.objectshare.grid.tool.JKSingleRowSelectTool;
import com.objectshare.grid.tool.JKSortTool;
import com.objectshare.grid.tool.JKTableTool;
import com.objectshare.grid.tool.JKToggleCellSelectTool;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.Vector;

public class RealEstateTable
extends JKExampleApplet {
    public JKTableList table;
    public Label cellLabel = new Label("ACTIONS: Cell");
    public Choice cellChoice = new Choice();
    public Button cellEditButton = new Button("Edit");
    public Label rowLabel = new Label("Row Header");
    public Choice rowChoice = new Choice();
    public Button rowEditButton = new Button("Edit");
    public Label columnLabel = new Label("Column Header");
    public Choice columnChoice = new Choice();
    public Button columnEditButton = new Button("Edit");
    public Hashtable columnToolDictionary;
    public Hashtable rowToolDictionary;
    public Hashtable cellToolDictionary;
    protected Panel controls;

    public static void main(String[] stringArray) {
        RealEstateTable realEstateTable = new RealEstateTable();
        new JKExampleFrame(realEstateTable, "Real Estate Table", 400, 300);
    }

    public void init() {
        super.init();
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.initTable();
        this.initControlPanel();
        this.initControlData();
    }

    public void initTable() {
        this.table = new JKTableList();
        ((Container)((Object)this)).add("Center", (Component)((Object)this.table));
        this.addTableData();
        this.table.setRowHeaderTool(new JKResizeRowTool());
        this.table.setColumnHeaderTool(new JKReorderColTool());
        this.table.setCellAreaTool(new JKBlockCellSelectTool());
    }

    protected void initControlPanel() {
        this.controls = new Panel();
        ((Container)((Object)this)).add("North", this.controls);
        this.initControls();
    }

    protected void initControls() {
        this.controls.setLayout(new GridBagLayout());
        this.initCellChoice();
        this.addControlRow(1, 5, 5, this.cellLabel, this.cellChoice, this.cellEditButton);
        this.initRowChoice();
        this.addControlRow(2, 5, 5, this.rowLabel, this.rowChoice, this.rowEditButton);
        this.initColumnChoice();
        this.addControlRow(3, 5, 10, this.columnLabel, this.columnChoice, this.columnEditButton);
    }

    protected void addControlRow(int n, int n2, int n3, Label label, Choice choice, Button button) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 33.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(n2, 0, n3, 5);
        ((GridBagLayout)this.controls.getLayout()).setConstraints(label, gridBagConstraints);
        this.controls.add(label);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n2, 2, n3, 2);
        ((GridBagLayout)this.controls.getLayout()).setConstraints(choice, gridBagConstraints);
        this.controls.add(choice);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 0;
        ((GridBagLayout)this.controls.getLayout()).setConstraints(button, gridBagConstraints);
        this.controls.add(button);
    }

    public void initColumnChoice() {
        this.columnChoice.addItem("none");
        this.columnChoice.addItem("single column select");
        this.columnChoice.addItem("multi column select");
        this.columnChoice.addItem("extended column select");
        this.columnChoice.addItem("resize column");
        this.columnChoice.addItem("reorder column");
        this.columnChoice.addItem("composite");
        this.columnChoice.addItem("sort column");
    }

    public void initCellChoice() {
        this.cellChoice.addItem("none");
        this.cellChoice.addItem("single cell select");
        this.cellChoice.addItem("single row select");
        this.cellChoice.addItem("single column select");
        this.cellChoice.addItem("block cell select");
        this.cellChoice.addItem("toggle cell select");
        this.cellChoice.addItem("multi row select");
        this.cellChoice.addItem("multi column select");
        this.cellChoice.addItem("extended row select");
        this.cellChoice.addItem("extended column select");
        this.cellChoice.addItem("resize cell");
        this.cellChoice.addItem("resize row");
        this.cellChoice.addItem("resize column");
        this.cellChoice.addItem("reorder cell");
        this.cellChoice.addItem("reorder row");
        this.cellChoice.addItem("reorder column");
        this.cellChoice.addItem("composite");
    }

    public void initRowChoice() {
        this.rowChoice.addItem("none");
        this.rowChoice.addItem("single row select");
        this.rowChoice.addItem("multi row select");
        this.rowChoice.addItem("extended row select");
        this.rowChoice.addItem("resize row");
        this.rowChoice.addItem("reorder row");
        this.rowChoice.addItem("composite");
    }

    public boolean handleEvent(Event event) {
        return this.handleControlEvents(event);
    }

    Hashtable buildToolDictionary(JKTableListAdapter jKTableListAdapter) {
        Hashtable<String, JKTableTool> hashtable = new Hashtable<String, JKTableTool>();
        hashtable.put("single cell select", new JKSingleCellSelectTool(this.table, jKTableListAdapter));
        hashtable.put("single row select", new JKSingleRowSelectTool(this.table, jKTableListAdapter));
        hashtable.put("single column select", new JKSingleColSelectTool(this.table, jKTableListAdapter));
        hashtable.put("block cell select", new JKBlockCellSelectTool(this.table, jKTableListAdapter));
        hashtable.put("toggle cell select", new JKToggleCellSelectTool(this.table, jKTableListAdapter));
        hashtable.put("multi row select", new JKMultiRowSelectTool(this.table, jKTableListAdapter));
        hashtable.put("multi column select", new JKMultiColSelectTool(this.table, jKTableListAdapter));
        hashtable.put("extended row select", new JKExtendedRowSelectTool(this.table, jKTableListAdapter));
        hashtable.put("extended column select", new JKExtendedColSelectTool(this.table, jKTableListAdapter));
        hashtable.put("resize cell", new JKResizeCellTool(this.table, jKTableListAdapter));
        hashtable.put("resize row", new JKResizeRowTool(this.table, jKTableListAdapter));
        hashtable.put("resize column", new JKResizeColTool(this.table, jKTableListAdapter));
        hashtable.put("reorder cell", new JKReorderCellTool(this.table, jKTableListAdapter));
        hashtable.put("reorder row", new JKReorderRowTool(this.table, jKTableListAdapter));
        hashtable.put("reorder column", new JKReorderColTool(this.table, jKTableListAdapter));
        hashtable.put("composite", new JKCompositeTool(this.table, jKTableListAdapter));
        hashtable.put("sort column", new JKSortTool(this.table, jKTableListAdapter));
        return hashtable;
    }

    public void addTableData() {
        Vector<RealEstateListing> vector = new Vector<RealEstateListing>();
        vector.addElement(new RealEstateListing("Dream house", "23 Waters Ave.", 500000, 499999, 5, "Terrific", 1500));
        vector.addElement(new RealEstateListing("Bungalow", "1 Shady Brook Cv.", 400000, 399999, 4, "Great", 1000));
        vector.addElement(new RealEstateListing("Cabin", "44 Cliff Ave.", 350000, 349999, 3, "Good", 500));
        vector.addElement(new RealEstateListing("Mansion", "2389 Oak Dr.", 250000, 249999, 2, "Fair", 200));
        vector.addElement(new RealEstateListing("Timber-frame", "1193 Red Str.", 100000, 99999, 1, "Poor", 100));
        this.table.getModel().addRows(vector);
    }

    public Frame getFrameParent() {
        Container container = ((Component)((Object)this)).getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        Frame frame = (Frame)container;
        return frame;
    }

    public boolean handleControlEvents(Event event) {
        if (event.target == this.cellChoice && event.id == 1001) {
            Object v = this.cellToolDictionary.get(event.arg);
            this.table.setCellAreaTool(v != null ? (JKTableTool)v : null);
            return true;
        }
        if (event.target == this.rowChoice && event.id == 1001) {
            Object v = this.rowToolDictionary.get(event.arg);
            this.table.setRowHeaderTool(v != null ? (JKTableTool)v : null);
            return true;
        }
        if (event.target == this.columnChoice && event.id == 1001) {
            Object v = this.columnToolDictionary.get(event.arg);
            this.table.setColumnHeaderTool(v != null ? (JKTableTool)v : null);
            return true;
        }
        return super.handleEvent(event);
    }

    public void initControlData() {
        this.cellEditButton.disable();
        this.rowEditButton.disable();
        this.columnEditButton.disable();
        this.cellToolDictionary = this.buildToolDictionary(this.table.cellAdapter);
        this.rowToolDictionary = this.buildToolDictionary(this.table.rowAdapter);
        this.columnToolDictionary = this.buildToolDictionary(this.table.columnAdapter);
        this.cellChoice.select("block cell select");
        this.rowChoice.select("resize row");
        this.columnChoice.select("reorder column");
    }
}

