/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Component;
import java.awt.Event;
import java.awt.Point;
import java.awt.Rectangle;

public class JKResizeCellTool
extends JKTableTool {
    protected int cellX;
    protected int cellY;
    protected Rectangle cellRect;
    protected Point offset;

    public JKResizeCellTool() {
    }

    public JKResizeCellTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.getIgnoreClickCount() && event.clickCount > 1) {
            return false;
        }
        this.cellX = n;
        this.cellY = n2;
        this.cellRect = this.adapter.getCellScreenBounds(n2, n);
        this.offset = new Point(this.cellRect.x + this.cellRect.width - event.x, this.cellRect.y + this.cellRect.height - event.y);
        this.owner.mouseDragAction = this;
        this.owner.mouseUpAction = this;
        return true;
    }

    public void mouseDrag(Event event) {
        this.resizeRowHeight(event.y - this.cellRect.y + this.offset.y);
        this.resizeColumnWidth(event.x - this.cellRect.x + this.offset.x);
    }

    public void mouseUp(Event event) {
        this.mouseDrag(event);
        this.owner.getAutoSizePolicy().autoSize();
        ((Component)((Object)this.owner)).repaint();
        super.mouseUp(event);
    }

    protected void resizeRowHeight(int n) {
        if (this.owner.isRowUserSizable(this.cellY)) {
            this.owner.setRowAutoSizable(this.cellY, false);
            this.owner.getDimensions().setHeight(this.cellY, n);
            this.cellRect = new Rectangle(this.cellRect.x, this.cellRect.y, this.cellRect.width, n);
            ((Component)((Object)this.owner)).repaint();
        }
    }

    protected void resizeColumnWidth(int n) {
        if (this.owner.isColumnUserSizable(this.cellX)) {
            this.owner.setColumnAutoSizable(this.cellX, false);
            this.owner.getDimensions().setWidth(this.cellX, n);
            this.cellRect = new Rectangle(this.cellRect.x, this.cellRect.y, n, this.cellRect.height);
            ((Component)((Object)this.owner)).repaint();
        }
    }
}

