/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.base.draw.OSIDisplaySystemParent;
import com.objectshare.base.draw.OSIGraphicsDisplaySystem;
import com.objectshare.base.draw.OSIScrolledDisplaySystem;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.view.JKDimensionPolicy;
import com.objectshare.grid.view.JKDisplayPolicy;
import com.objectshare.grid.view.JKDrawViewEvent;
import com.objectshare.grid.view.JKTableView;
import com.objectshare.grid.view.OSIScrollbar;
import com.objectshare.java.osi.OSIPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class JKTableViewAdapter
implements Serializable,
OSIDisplaySystemParent {
    public static int maxDoubleBufferWidth = 2000;
    public static int maxDoubleBufferHeight = 5000;
    public JKTableView owner;
    public OSIGraphicsDisplaySystem displaySystem;
    public int adapterX;
    public int adapterY;
    protected Rectangle virtualBounds;
    protected Point virtualScroll;

    public JKTableViewAdapter(JKTableView jKTableView, int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        this.owner = jKTableView;
        this.setDisplaySystem((OSIGraphicsDisplaySystem)(OSIScrollbar.jdk102SBStyle ? new OSIGraphicsDisplaySystem() : new OSIScrolledDisplaySystem(0, 0)));
        this.initDisplaySystem();
        this.adapterX = n;
        this.adapterY = n2;
        this.virtualBounds = rectangle;
        this.virtualScroll = new Point(this.virtualBounds.x, this.virtualBounds.y);
        this.setScreenBounds(rectangle2);
    }

    public final OSIGraphicsDisplaySystem getDisplaySystem() {
        return this.displaySystem;
    }

    public void setDisplaySystem(OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem) {
        this.releaseDisplaySystem();
        this.displaySystem = oSIGraphicsDisplaySystem;
        this.displaySystem.setParent((OSIDisplaySystemParent)this);
    }

    public void initDisplaySystem() {
    }

    public void updateDisplaySystem() {
        if (this.displaySystem instanceof OSIScrolledDisplaySystem) {
            OSIScrolledDisplaySystem oSIScrolledDisplaySystem = (OSIScrolledDisplaySystem)this.displaySystem;
            Rectangle rectangle = this.getVirtualBounds();
            Rectangle rectangle2 = this.getScreenContentBounds();
            Dimension dimension = oSIScrolledDisplaySystem.getBufferSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n < rectangle.width) {
                n = rectangle.width * 3 / 2;
            }
            n2 = this.adapterY == 1 ? maxDoubleBufferHeight : (rectangle.height > n2 ? rectangle.height : n2);
            n = n < maxDoubleBufferWidth ? n : maxDoubleBufferWidth;
            n2 = n2 < maxDoubleBufferHeight ? n2 : maxDoubleBufferHeight;
            n = n > rectangle2.width ? n : rectangle2.width;
            n2 = n2 > rectangle2.height ? n2 : rectangle2.height;
            oSIScrolledDisplaySystem.setBufferSize(n, n2);
        }
    }

    public void releaseDisplaySystem() {
        if (this.displaySystem != null) {
            this.displaySystem.release();
        }
    }

    public final Rectangle getVirtualBounds() {
        return this.virtualBounds;
    }

    public void setVirtualBounds(int n, int n2, int n3, int n4) {
        this.setVirtualBounds(new Rectangle(n, n2, n3, n4));
    }

    public void setVirtualBounds(Rectangle rectangle) {
        this.virtualBounds = rectangle;
        this.virtualScroll = this.getVirtualScroll(this.getVirtualScroll().x, this.getVirtualScroll().y);
        this.updateDisplaySystem();
        this.damageAll();
    }

    public void shiftVirtualBounds(int n, int n2) {
        this.virtualBounds = new Rectangle(this.virtualBounds.x + n, this.virtualBounds.y + n2, this.virtualBounds.width, this.virtualBounds.height);
        this.virtualScroll = new Point(this.virtualScroll.x + n, this.virtualScroll.y + n2);
        this.damageAll();
    }

    public void insertVirtualWidth(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.setVirtualBounds(this.virtualBounds.x, this.virtualBounds.y, this.virtualBounds.width + n2, this.virtualBounds.height);
        if (n < this.virtualScroll.x) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x + n2, this.virtualScroll.y);
        }
        this.damageAll();
    }

    public void removeVirtualWidth(int n, int n2) {
        int n3;
        int n4 = n3 = n2 <= this.virtualBounds.width - (n - this.virtualBounds.x) ? n2 : this.virtualBounds.width - (n - this.virtualBounds.x);
        if (n3 <= 0) {
            return;
        }
        this.setVirtualBounds(this.virtualBounds.x, this.virtualBounds.y, this.virtualBounds.width - n3, this.virtualBounds.height);
        if (n + this.getScreenContentBounds().width <= this.virtualScroll.x) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x - n3, this.virtualScroll.y);
        } else if (n <= this.virtualScroll.x) {
            this.virtualScroll = this.getVirtualScroll(n, this.virtualScroll.y);
        } else if (n < this.virtualScroll.x + this.getScreenContentBounds().width) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x, this.virtualScroll.y);
        }
        this.damageAll();
    }

    public void insertVirtualHeight(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.setVirtualBounds(this.virtualBounds.x, this.virtualBounds.y, this.virtualBounds.width, this.virtualBounds.height + n2);
        if (n < this.virtualScroll.y) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x, this.virtualScroll.y + n2);
        }
        this.damageAll();
    }

    public void removeVirtualHeight(int n, int n2) {
        int n3;
        int n4 = n3 = n2 <= this.virtualBounds.height - (n - this.virtualBounds.y) ? n2 : this.virtualBounds.height - (n - this.virtualBounds.y);
        if (n3 <= 0) {
            return;
        }
        this.setVirtualBounds(this.virtualBounds.x, this.virtualBounds.y, this.virtualBounds.width, this.virtualBounds.height - n3);
        if (n + this.getScreenContentBounds().height <= this.virtualScroll.y) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x, this.virtualScroll.y - n3);
        } else if (n <= this.virtualScroll.y) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x, n);
        } else if (n < this.virtualScroll.y + this.getScreenContentBounds().height) {
            this.virtualScroll = this.getVirtualScroll(this.virtualScroll.x, this.virtualScroll.y);
        }
        this.damageAll();
    }

    public final Rectangle getVirtualContentBounds() {
        Rectangle rectangle = this.getVirtualBounds();
        Insets insets = this.getBorder().insets();
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (n > 0 && insets.right > 0) {
            --n;
        }
        if (n2 > 0 && insets.bottom > 0) {
            --n2;
        }
        return new Rectangle(rectangle.x, rectangle.y, n, n2);
    }

    public Dimension preferredSize() {
        Rectangle rectangle = this.getVirtualContentBounds();
        Insets insets = this.getBorder().insets();
        return new Dimension(rectangle.width > 0 ? rectangle.width + insets.left + insets.right : 0, rectangle.height > 0 ? rectangle.height + insets.top + insets.bottom : 0);
    }

    public final Point getVirtualScroll() {
        return this.virtualScroll;
    }

    protected final Point getVirtualScroll(Point point) {
        return this.getVirtualScroll(point.x, point.y);
    }

    protected final Point getVirtualScroll(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Rectangle rectangle = this.getVirtualContentBounds();
        Rectangle rectangle2 = this.getScreenContentBounds();
        if (n3 > rectangle.x + rectangle.width - rectangle2.width) {
            n3 = rectangle.x + rectangle.width - rectangle2.width;
        }
        if (n4 > rectangle.y + rectangle.height - rectangle2.height) {
            n4 = rectangle.y + rectangle.height - rectangle2.height;
        }
        if (n3 < rectangle.x) {
            n3 = rectangle.x;
        }
        if (n4 < rectangle.y) {
            n4 = rectangle.y;
        }
        return new Point(n3, n4);
    }

    public void setVirtualScroll(int n, int n2) {
        Point point = this.getVirtualScroll(n, n2);
        if (!this.virtualScroll.equals(point)) {
            int n3 = this.virtualScroll.x - point.x;
            int n4 = this.virtualScroll.y - point.y;
            this.virtualScroll = point;
            this.getDisplaySystem().scroll(n3, n4);
        }
    }

    public boolean isCellVisible(int n, int n2) {
        Rectangle rectangle = this.getCellScreenBounds(n, n2);
        return this.getScreenContentBounds().intersection(rectangle).equals(rectangle);
    }

    public void keepCellVisible(int n, int n2) {
        Rectangle rectangle = this.getCellScreenBounds(n, n2);
        int n3 = 0;
        int n4 = 0;
        if (rectangle.x + rectangle.width > this.getScreenContentBounds().x + this.getScreenContentBounds().width) {
            n3 = rectangle.x + rectangle.width - (this.getScreenContentBounds().x + this.getScreenContentBounds().width);
        }
        if (rectangle.y + rectangle.height > this.getScreenContentBounds().y + this.getScreenContentBounds().height) {
            n4 = rectangle.y + rectangle.height - (this.getScreenContentBounds().y + this.getScreenContentBounds().height);
        }
        if (rectangle.x < this.getScreenContentBounds().x) {
            n3 = rectangle.x - this.getScreenContentBounds().x;
        }
        if (rectangle.y < this.getScreenContentBounds().y) {
            n4 = rectangle.y - this.getScreenContentBounds().y;
        }
        if (n3 != 0 || n4 != 0) {
            this.owner.getCoordinator().setVirtualScroll(this.adapterX, this.adapterY, this.getVirtualScroll().x + n3, this.getVirtualScroll().y + n4);
        }
    }

    public boolean isRowVisible(int n) {
        return this.getRowScreenTop(n) >= this.getScreenContentBounds().y && this.getRowScreenTop(n + 1) <= this.getScreenContentBounds().y + this.getScreenContentBounds().height;
    }

    public void keepRowVisible(int n) {
        this.keepRowsVisible(n, 1);
    }

    public void keepRowsVisible(int n, int n2) {
        int n3 = 0;
        if (this.getRowScreenTop(n + n2) > this.getScreenContentBounds().y + this.getScreenContentBounds().height) {
            n3 = this.getRowScreenTop(n + n2) - (this.getScreenContentBounds().y + this.getScreenContentBounds().height);
        }
        if (this.getRowScreenTop(n) - n3 < this.getScreenContentBounds().y) {
            n3 = this.getRowScreenTop(n) - n3 - this.getScreenContentBounds().y;
        }
        if (n3 != 0) {
            this.owner.getCoordinator().setVirtualYScroll(this.adapterY, this.getVirtualScroll().y + n3);
        }
    }

    public boolean isColumnVisible(int n) {
        return this.isColumnVisible("java.lang.Object", n);
    }

    public void keepColumnVisible(int n) {
        this.keepColumnVisible("java.lang.Object", n);
    }

    public boolean isColumnVisible(int n, int n2) {
        return this.isColumnVisible(this.owner.getModel().getRowType(n), n2);
    }

    public void keepColumnVisible(int n, int n2) {
        this.keepColumnVisible(this.owner.getModel().getRowType(n), n2);
    }

    public boolean isColumnVisible(String string, int n) {
        return this.getColumnScreenLeft(string, n) >= this.getScreenContentBounds().x && this.getColumnScreenLeft(string, n + 1) <= this.getScreenContentBounds().x + this.getScreenContentBounds().width;
    }

    public void keepColumnVisible(String string, int n) {
        int n2 = 0;
        if (this.getColumnScreenLeft(string, n + 1) > this.getScreenContentBounds().x + this.getScreenContentBounds().width) {
            n2 = this.getColumnScreenLeft(string, n + 1) - (this.getScreenContentBounds().x + this.getScreenContentBounds().width);
        }
        if (this.getColumnScreenLeft(string, n) < this.getScreenContentBounds().x) {
            n2 = this.getColumnScreenLeft(string, n) - this.getScreenContentBounds().x;
        }
        if (n2 != 0) {
            this.owner.getCoordinator().setVirtualXScroll(this.adapterX, this.getVirtualScroll().x + n2);
        }
    }

    public final Rectangle getScreenBounds() {
        return this.getDisplaySystem().getBounds();
    }

    public void setScreenBounds(int n, int n2, int n3, int n4) {
        this.setScreenBounds(new Rectangle(n, n2, n3, n4));
    }

    public void setScreenBounds(Rectangle rectangle) {
        this.getDisplaySystem().setBounds(rectangle);
        this.virtualScroll = this.getVirtualScroll(this.getVirtualScroll().x, this.getVirtualScroll().y);
        this.updateDisplaySystem();
        this.damageAll();
    }

    public final Rectangle getScreenContentBounds() {
        return this.getDisplaySystem().getContentBounds();
    }

    public final OSIBorderPolicy getBorderPolicy() {
        return this.getBorder();
    }

    public final OSIBorderPolicy getBorder() {
        return this.getDisplaySystem().getBorder();
    }

    public void setBorderPolicy(OSIBorderPolicy oSIBorderPolicy) {
        this.setBorder(oSIBorderPolicy);
    }

    public void setBorder(OSIBorderPolicy oSIBorderPolicy) {
        this.getDisplaySystem().setBorder(oSIBorderPolicy);
    }

    public Rectangle getVirtualRect(Rectangle rectangle) {
        int n = this.getVirtualX(rectangle.x);
        int n2 = this.getVirtualY(rectangle.y);
        return new Rectangle(n, n2, this.getVirtualX(rectangle.x + rectangle.width) - n, this.getVirtualY(rectangle.y + rectangle.height) - n2);
    }

    public Rectangle getScreenRect(Rectangle rectangle) {
        return new Rectangle(this.getScreenX(rectangle.x), this.getScreenY(rectangle.y), rectangle.width, rectangle.height);
    }

    public int getVirtualY(int n) {
        int n2 = n - this.getScreenContentBounds().y + this.getVirtualScroll().y;
        if (n2 > this.getVirtualBounds().y + this.getVirtualBounds().height - 1) {
            n2 = this.getVirtualBounds().y + this.getVirtualBounds().height - 1;
        }
        if (n2 < this.getVirtualBounds().y) {
            n2 = this.getVirtualBounds().y;
        }
        return n2;
    }

    public int getScreenY(int n) {
        return n - this.getVirtualScroll().y + this.getScreenContentBounds().y;
    }

    public int getRowNumber(int n) {
        return this.owner.getDimensions().getRowNumber(this.getVirtualY(n));
    }

    public int getFirstRowNumber() {
        return this.owner.getDimensions().getRowNumber(this.getVirtualBounds().y);
    }

    public int getLastRowNumber() {
        return this.owner.getDimensions().getRowNumber(this.getVirtualBounds().y + this.getVirtualBounds().height) - 1;
    }

    public int getNumberOfRows() {
        return this.getLastRowNumber() - this.getFirstRowNumber() + 1;
    }

    public int getVirtualX(int n) {
        int n2 = n - this.getScreenContentBounds().x + this.getVirtualScroll().x;
        if (n2 > this.getVirtualBounds().x + this.getVirtualBounds().width - 1) {
            n2 = this.getVirtualBounds().x + this.getVirtualBounds().width - 1;
        }
        if (n2 < this.getVirtualBounds().x) {
            n2 = this.getVirtualBounds().x;
        }
        return n2;
    }

    public int getScreenX(int n) {
        return n - this.getVirtualScroll().x + this.getScreenContentBounds().x;
    }

    public int getColumnNumber(String string, int n) {
        return this.owner.getDimensions().getColumnNumber(string, this.getVirtualX(n));
    }

    public int getColumnNumber(int n, int n2) {
        return this.owner.getDimensions().getColumnNumber(n, this.getVirtualX(n2));
    }

    public int getFirstColumnNumber() {
        return this.getFirstColumnNumber("java.lang.Object");
    }

    public int getFirstColumnNumber(String string) {
        return this.owner.getDimensions().getColumnNumber(string, this.getVirtualBounds().x);
    }

    public int getFirstColumnNumber(int n) {
        return this.owner.getDimensions().getColumnNumber(n, this.getVirtualBounds().x);
    }

    public int getLastColumnNumber() {
        return this.getLastColumnNumber("java.lang.Object");
    }

    public int getLastColumnNumber(String string) {
        return this.owner.getDimensions().getColumnNumber(string, this.getVirtualBounds().x + this.getVirtualBounds().width) - 1;
    }

    public int getLastColumnNumber(int n) {
        return this.owner.getDimensions().getColumnNumber(n, this.getVirtualBounds().x + this.getVirtualBounds().width) - 1;
    }

    public int getNumberOfColumns() {
        return this.getNumberOfColumns("java.lang.Object");
    }

    public int getNumberOfColumns(String string) {
        return this.getLastColumnNumber(string) - this.getFirstColumnNumber(string) + 1;
    }

    public int getNumberOfColumns(int n) {
        return this.getLastColumnNumber(n) - this.getFirstColumnNumber(n) + 1;
    }

    public Point getCell(int n, int n2) {
        if (this.getVirtualBounds().isEmpty()) {
            return null;
        }
        int n3 = this.getRowNumber(n2);
        int n4 = this.getColumnNumber(n3, n);
        return new Point(n4, n3);
    }

    public Point getCellOrNull(int n, int n2) {
        int n3 = n - this.getScreenContentBounds().x + this.getVirtualScroll().x;
        int n4 = n2 - this.getScreenContentBounds().y + this.getVirtualScroll().y;
        if (!this.getVirtualBounds().inside(n3, n4)) {
            return null;
        }
        int n5 = this.owner.getDimensions().getRowNumber(n4);
        int n6 = this.owner.getDimensions().getColumnNumber(n5, n3);
        return new Point(n6, n5);
    }

    public int getRowScreenTop(int n) {
        return this.owner.getDimensions().getVirtualY(n) - this.getVirtualScroll().y + this.getScreenContentBounds().y;
    }

    public int getColumnScreenLeft(int n) {
        return this.getColumnScreenLeft("java.lang.Object", n);
    }

    public int getColumnScreenLeft(int n, int n2) {
        return this.owner.getDimensions().getVirtualX(n, n2) - this.getVirtualScroll().x + this.getScreenContentBounds().x;
    }

    public int getColumnScreenLeft(String string, int n) {
        return this.owner.getDimensions().getVirtualX(string, n) - this.getVirtualScroll().x + this.getScreenContentBounds().x;
    }

    public Rectangle getCellScreenBounds(int n, int n2) {
        return new Rectangle(this.getColumnScreenLeft(n, n2), this.getRowScreenTop(n), this.owner.getDimensions().getWidth(n, n2), this.owner.getDimensions().getHeight(n));
    }

    public Rectangle getCellScreenContentBounds(int n, int n2) {
        JKDrawViewEvent jKDrawViewEvent = new JKDrawViewEvent(this.owner.getDisplayPolicy().existingCellDrawingContext(n, n2), this, null);
        Rectangle rectangle = this.getCellScreenBounds(n, n2);
        Insets insets = jKDrawViewEvent.borderInsets();
        Insets insets2 = jKDrawViewEvent.contentInsets();
        return new Rectangle(rectangle.x + insets.left + insets2.left, rectangle.y + insets.top + insets2.top, rectangle.width - insets.left - insets2.left - insets.right - insets2.right, rectangle.height - insets.top - insets2.top - insets.bottom - insets2.bottom);
    }

    public void damageAll() {
        this.getDisplaySystem().damageAll();
    }

    public void damageVirtualRegion(Rectangle rectangle) {
        int n = rectangle.x - this.getVirtualScroll().x + this.getScreenContentBounds().x;
        int n2 = rectangle.y - this.getVirtualScroll().y + this.getScreenContentBounds().y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.damageScreenRegion(new Rectangle(n, n2, n3, n4));
    }

    public void damageScreenRegion(Rectangle rectangle) {
        this.getDisplaySystem().damageRegion(rectangle);
    }

    public void disableRepair() {
        this.getDisplaySystem().disableRepair();
    }

    public void enableRepair() {
        this.getDisplaySystem().enableRepair();
    }

    public void repairDamage() {
        this.getDisplaySystem().repairDamage();
    }

    public void repaintRows(int n, int n2) {
        if (n2 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n3 = jKDimensionPolicy.getVirtualY(n);
        int n4 = jKDimensionPolicy.getTotalHeight(n, n2);
        this.repaintVirtual(this.owner.getCoordinator().getVirtualX(), n3, this.owner.getCoordinator().getVirtualWidth(), n4);
    }

    public void repaintColumns(int n, int n2) {
        this.repaintColumns("java.lang.Object", n, n2);
    }

    public void repaintColumns(String string, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n3 = jKDimensionPolicy.getVirtualX(string, n);
        int n4 = jKDimensionPolicy.getTotalWidth(string, n, n2);
        this.repaintVirtual(n3, this.owner.getCoordinator().getVirtualY(), n4, this.owner.getCoordinator().getVirtualHeight());
    }

    public void repaintColumns(int n, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n4 = jKDimensionPolicy.getVirtualX(n, n2);
        int n5 = jKDimensionPolicy.getTotalWidth(n, n2, n3);
        this.repaintVirtual(n4, this.owner.getCoordinator().getVirtualY(), n5, this.owner.getCoordinator().getVirtualHeight());
    }

    public void repaintCells(int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n5 = jKDimensionPolicy.getVirtualX(n, n2);
        int n6 = jKDimensionPolicy.getVirtualY(n);
        int n7 = jKDimensionPolicy.getTotalWidth(n, n2, n4);
        int n8 = jKDimensionPolicy.getTotalHeight(n, n3);
        this.repaintVirtual(n5, n6, n7, n8);
    }

    public void repaintVirtual(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getScreenContentBounds();
        int n5 = n - this.getVirtualScroll().x + rectangle.x;
        int n6 = n2 - this.getVirtualScroll().y + rectangle.y;
        int n7 = n3;
        int n8 = n4;
        if (n5 < rectangle.x) {
            n7 -= rectangle.x - n5;
            n5 = rectangle.x;
        }
        if (n6 < rectangle.y) {
            n8 -= rectangle.y - n6;
            n6 = rectangle.y;
        }
        if (n7 > rectangle.x + rectangle.width - n5) {
            n7 = rectangle.x + rectangle.width - n5;
        }
        if (n8 > rectangle.y + rectangle.height - n6) {
            n8 = rectangle.y + rectangle.height - n6;
        }
        if (n7 > 0 && n8 > 0) {
            ((Component)((Object)this.owner)).repaint(n5, n6, n7, n8);
        }
    }

    public JKDrawViewEvent newDrawEvent(Graphics graphics) {
        return new JKDrawViewEvent(null, this, graphics);
    }

    public void paint(Graphics graphics) {
        this.getDisplaySystem().paint(graphics);
    }

    public void paintCanvas(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle == null || rectangle.isEmpty()) {
            return;
        }
        int n = this.getScreenContentBounds().x - this.getVirtualScroll().x;
        int n2 = this.getScreenContentBounds().y - this.getVirtualScroll().y;
        graphics.translate(n, n2);
        rectangle = new Rectangle(rectangle.x - n, rectangle.y - n2, rectangle.width, rectangle.height);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paintVirtual(graphics, rectangle);
        graphics.translate(-n, -n2);
        this.owner.paintCanvas(graphics);
    }

    public void paintVirtual(Graphics graphics, Rectangle rectangle) {
        JKDimensionPolicy jKDimensionPolicy = this.owner.dimensions;
        JKDisplayPolicy jKDisplayPolicy = this.owner.getDisplayPolicy();
        JKDrawViewEvent jKDrawViewEvent = this.newDrawEvent(graphics);
        Rectangle rectangle2 = this.getVirtualContentBounds();
        int n = rectangle2.x + rectangle2.width;
        int n2 = rectangle.x + rectangle.width;
        int n3 = n < n2 ? n : n2;
        int n4 = rectangle2.y + rectangle2.height;
        int n5 = rectangle.y + rectangle.height;
        int n6 = n4 < n5 ? n4 : n5;
        int n7 = jKDimensionPolicy.getRowNumber(rectangle.y);
        int n8 = jKDimensionPolicy.getVirtualY(n7);
        while (n8 < n6) {
            int n9 = jKDimensionPolicy.getHeight(n7);
            int n10 = jKDimensionPolicy.getColumnNumber(n7, rectangle.x);
            int n11 = jKDimensionPolicy.getVirtualX(n7, n10);
            while (n11 < n3) {
                int n12 = jKDimensionPolicy.getWidth(n7, n10);
                jKDrawViewEvent.cellBox = new Rectangle(n11, n8, n12, n9);
                jKDrawViewEvent.dataY = n7;
                jKDrawViewEvent.dataX = n10;
                jKDrawViewEvent.setParent(jKDisplayPolicy.existingCellDrawingContext(n7, n10));
                this.owner.triggerDrawCell(jKDrawViewEvent);
                ++n10;
                n11 += n12;
            }
            if (n11 < n2) {
                Color color = graphics.getColor();
                graphics.setColor(((Component)((Object)this.owner)).getBackground());
                graphics.fillRect(n11, n8, n2 - n11, n9);
                graphics.setColor(color);
            }
            ++n7;
            n8 += n9;
        }
        if (n8 < n5) {
            Color color = graphics.getColor();
            graphics.setColor(((Component)((Object)this.owner)).getBackground());
            graphics.fillRect(rectangle.x, n8, rectangle.width, n5 - n8);
            graphics.setColor(color);
        }
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
    }

    public OSIPanel getCanvas() {
        return this.owner;
    }

    public Graphics getGraphics() {
        return ((Component)((Object)this.owner)).getGraphics();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        ((Component)((Object)this.owner)).repaint(n, n2, n3, n4);
    }
}

