/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.draw;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.base.draw.OSIDisplaySystemParent;
import com.objectshare.java.osi.OSIPanel;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public abstract class OSIAbstractDisplaySystem
implements Serializable {
    protected OSIDisplaySystemParent parent;
    protected OSIBorderPolicy border = OSIBorderPolicy.NORMAL;
    protected Rectangle bounds;
    protected Rectangle contentBounds;

    public OSIDisplaySystemParent getParent() {
        return this.parent;
    }

    public OSIPanel getCanvas() {
        return this.parent.getCanvas();
    }

    public void setParent(OSIDisplaySystemParent oSIDisplaySystemParent) {
        this.parent = oSIDisplaySystemParent;
    }

    public void setCanvas(OSIPanel oSIPanel) {
        this.setParent(oSIPanel);
    }

    public void release() {
    }

    public Graphics getGraphics() {
        return this.getParent().getGraphics();
    }

    public void paintCanvas(Graphics graphics) {
        this.getParent().paintCanvas(graphics);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.getParent().repaint(n, n2, n3, n4);
    }

    public abstract void setSynchronousRepair(boolean var1);

    public OSIBorderPolicy getBorder() {
        return this.border;
    }

    public void setBorder(OSIBorderPolicy oSIBorderPolicy) {
        Insets insets = this.border.insets();
        this.border = oSIBorderPolicy != null ? oSIBorderPolicy : OSIBorderPolicy.NONE;
        Insets insets2 = this.border.insets();
        if (!insets2.equals(insets)) {
            this.updateContentBounds();
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        if (!(this.bounds == rectangle || this.bounds != null && this.bounds.equals(rectangle))) {
            this.bounds = rectangle;
            this.updateContentBounds();
        }
    }

    public Rectangle getContentBounds() {
        return this.contentBounds;
    }

    protected void updateContentBounds() {
        if (this.bounds == null) {
            this.contentBounds = null;
            return;
        }
        Insets insets = this.border.insets();
        this.contentBounds = new Rectangle(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
    }

    public void scroll(int n, int n2) {
        this.damageRegion(this.getContentBounds());
    }

    public abstract void damageRegion(Rectangle var1);

    public abstract void disableRepair();

    public abstract void enableRepair();

    public abstract void repairDamage();

    public abstract void paint(Graphics var1);

    public abstract void display(Graphics var1);

    public void displayBorder(Graphics graphics) {
        graphics.setColor(this.getCanvas().getBackground());
        Rectangle rectangle = this.getBounds();
        this.getBorder().display(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

