/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.draw;

import com.objectshare.base.draw.OSIGraphicsDisplaySystem;
import com.objectshare.java.osi.OSIPanel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class OSIBufferedDisplaySystem
extends OSIGraphicsDisplaySystem {
    protected transient Image buffer;
    protected int bufferWidth;
    protected int bufferHeight;

    protected void reshapeScratch(int n, int n2) {
        this.reshapeBuffer(n, n2);
    }

    protected void reshapeBuffer(int n, int n2) {
        OSIPanel oSIPanel = this.getCanvas();
        if (oSIPanel != null) {
            int n3;
            int n4 = n >= 1 ? n : 1;
            int n5 = n3 = n2 >= 1 ? n2 : 1;
            if (this.buffer != null) {
                if (this.bufferWidth == n4 && this.bufferHeight == n3) {
                    return;
                }
                this.buffer.flush();
            }
            this.buffer = oSIPanel.createImage(n4, n3);
            this.bufferWidth = n4;
            this.bufferHeight = n3;
        }
    }

    protected void reshapeScratch() {
        this.reshapeBuffer();
    }

    protected void reshapeBuffer() {
        Rectangle rectangle = this.getContentBounds();
        this.reshapeBuffer(rectangle.width, rectangle.height);
    }

    protected void disposeScratch() {
        this.disposeBuffer();
    }

    protected void disposeBuffer() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
    }

    public synchronized void display(Graphics graphics) {
        Rectangle rectangle = this.getContentBounds();
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        this.reshapeBuffer();
        Rectangle rectangle2 = graphics.getClipRect();
        Graphics graphics2 = this.buffer.getGraphics();
        graphics2.translate(-rectangle.x, -rectangle.y);
        graphics2.clipRect(rectangle2.x, rectangle2.y, rectangle2.width + rectangle.x, rectangle2.height + rectangle.y);
        this.basicDisplay(graphics2);
        graphics2.dispose();
        graphics.drawImage(this.buffer, rectangle.x, rectangle.y, this.getCanvas());
    }
}

