/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.util;

import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntVector;
import java.io.Serializable;

public class OSIIntToIntHashtable
implements Cloneable,
Serializable {
    public int elementStart = 0;
    public int[] elementArray;
    public int defaultValue;

    public OSIIntToIntHashtable() {
        this(new int[2]);
        this.elementArray[0] = Integer.MIN_VALUE;
        this.elementArray[1] = Integer.MIN_VALUE;
    }

    public OSIIntToIntHashtable(int[] nArray) {
        this.elementArray = nArray;
    }

    public Object clone() {
        OSIIntToIntHashtable oSIIntToIntHashtable = new OSIIntToIntHashtable();
        oSIIntToIntHashtable.elementStart = this.elementStart;
        oSIIntToIntHashtable.defaultValue = this.defaultValue;
        oSIIntToIntHashtable.elementArray = new int[this.elementArray.length];
        System.arraycopy(this.elementArray, 0, oSIIntToIntHashtable.elementArray, 0, this.elementArray.length);
        return oSIIntToIntHashtable;
    }

    public OSIIntEnumeration keys() {
        return OSIIntEnumeration.newFor(this.elementStart, this.elementArray.length);
    }

    public int get(int n) {
        int n2;
        if (n >= this.elementStart && n < this.elementStart + this.elementArray.length && (n2 = this.elementArray[n - this.elementStart]) != Integer.MIN_VALUE) {
            return n2;
        }
        return this.getDefault(n);
    }

    public int sum(int n, int n2) {
        int n3 = n - this.elementStart;
        int n4 = n3 + n2;
        int n5 = 0;
        if (n3 < 0) {
            if (n4 <= 0) {
                return n2 * this.defaultValue;
            }
            n5 += -n3 * this.defaultValue;
            n3 = 0;
        }
        if (n4 > this.elementArray.length) {
            if (n3 >= this.elementArray.length) {
                return n2 * this.defaultValue;
            }
            n5 += (n4 - this.elementArray.length) * this.defaultValue;
            n4 = this.elementArray.length;
        }
        int n6 = n3;
        while (n6 < n4) {
            int n7 = this.elementArray[n6];
            n5 += n7 != Integer.MIN_VALUE ? n7 : this.defaultValue;
            ++n6;
        }
        return n5;
    }

    public int count(int n, int n2) {
        int n3 = n - this.elementStart;
        int n4 = 0;
        if (n2 >= 0) {
            if (n3 < 0) {
                n4 = -n3 * this.defaultValue;
                if (n2 < n4) {
                    return n2 / this.defaultValue;
                }
                n3 = 0;
            }
            if (n3 < this.elementArray.length) {
                int n5 = n3;
                while (n5 < this.elementArray.length) {
                    int n6 = this.elementArray[n5];
                    if (n2 < (n4 += n6 != Integer.MIN_VALUE ? n6 : this.defaultValue)) {
                        return this.elementStart + n5 - n;
                    }
                    ++n5;
                }
                n3 = this.elementArray.length;
            }
            return this.elementStart + n3 + (n2 - n4) / this.defaultValue - n;
        }
        if (n3 > this.elementArray.length) {
            n4 = (this.elementArray.length - n3) * this.defaultValue;
            if (n2 >= n4) {
                return -((-n2 + this.defaultValue - 1) / this.defaultValue);
            }
            n3 = this.elementArray.length;
        }
        if (n3 > 0) {
            int n7 = n3 - 1;
            while (n7 >= 0) {
                int n8 = this.elementArray[n7];
                if (n2 >= (n4 -= n8 != Integer.MIN_VALUE ? n8 : this.defaultValue)) {
                    return this.elementStart + n7 - n;
                }
                --n7;
            }
            n3 = 0;
        }
        return this.elementStart + n3 - (n4 - n2 + this.defaultValue - 1) / this.defaultValue - n;
    }

    public int put(int n, int n2) {
        this.grow(n);
        int n3 = n - this.elementStart;
        int n4 = this.elementArray[n3];
        this.elementArray[n3] = n2;
        if (n4 == Integer.MIN_VALUE) {
            return this.getDefault(n);
        }
        return n4;
    }

    public int setToDefault(int n) {
        return this.put(n, Integer.MIN_VALUE);
    }

    public void setToDefault() {
        int n = 0;
        while (n < this.elementArray.length) {
            if (this.elementArray[n] == this.defaultValue) {
                this.elementArray[n] = Integer.MIN_VALUE;
            }
            ++n;
        }
    }

    public int getDefault(int n) {
        return this.defaultValue;
    }

    public OSIIntEnumeration getAll(int n, int n2) {
        return OSIIntEnumeration.newFor(this.getArray(n, n2));
    }

    public int[] getArray(int n, int n2) {
        if (n2 < 1) {
            return new int[0];
        }
        int[] nArray = new int[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            nArray[n3] = this.get(n3 + n);
        }
        return nArray;
    }

    public OSIIntEnumeration putAll(int n, int[] nArray) {
        OSIIntEnumeration oSIIntEnumeration = this.getAll(n, nArray.length);
        this.internalPutAll(n, nArray);
        return oSIIntEnumeration;
    }

    public void reorderAll(int n, int[] nArray) {
        this.reorderAll(n, new OSIIntVector(nArray));
    }

    public void reorderAll(int n, OSIIntVector oSIIntVector) {
        int n2 = oSIIntVector.remap(n);
        int[] nArray = oSIIntVector.toArray();
        int n3 = nArray.length;
        if (n3 > 0) {
            int[] nArray2 = new int[n3];
            while (--n3 >= 0) {
                nArray2[n3] = this.get(nArray[n3]);
            }
            this.internalPutAll(n2, nArray2);
        }
    }

    public int insert(int n, int n2) {
        this.internalCopy(n, n + 1, this.elementStart + this.elementArray.length - n);
        this.put(n, n2);
        return n;
    }

    public int insertAll(int n, int[] nArray) {
        if (nArray.length > 0) {
            this.internalCopy(n, n + nArray.length, this.elementStart + this.elementArray.length - n);
            this.internalPutAll(n, nArray);
        }
        return n;
    }

    public int insertAll(int n, int n2) {
        if (n2 > 0) {
            this.internalCopy(n, n + n2, this.elementStart + this.elementArray.length - n);
            int n3 = n + n2;
            while (--n3 >= n) {
                this.put(n3, Integer.MIN_VALUE);
            }
        }
        return n;
    }

    public int[] removeAll(int n, int n2) {
        int[] nArray = this.getAll(n, n2).toArray();
        if (n2 > 0) {
            if (n + n2 <= this.elementStart) {
                this.elementStart -= n2;
            } else if (n < this.elementStart + this.elementArray.length) {
                this.grow(n);
                int n3 = n - this.elementStart;
                int n4 = this.elementStart + this.elementArray.length - (n + n2);
                if (n4 > 0) {
                    System.arraycopy(this.elementArray, n3 + n2, this.elementArray, n3, n4);
                    n3 += n4;
                }
                while (n3 < this.elementArray.length) {
                    this.elementArray[n3++] = Integer.MIN_VALUE;
                }
            }
        }
        return nArray;
    }

    public void grow(int n) {
        if (n < this.elementStart) {
            int n2 = this.elementStart - n + 10;
            int[] nArray = new int[this.elementArray.length + n2];
            int n3 = n2;
            while (--n3 >= 0) {
                nArray[n3] = Integer.MIN_VALUE;
            }
            System.arraycopy(this.elementArray, 0, nArray, n2, this.elementArray.length);
            this.elementArray = nArray;
            this.elementStart -= n2;
        }
        if (n >= this.elementStart + this.elementArray.length) {
            int[] nArray = new int[n - this.elementStart + 10];
            int n4 = this.elementArray.length;
            while (n4 < nArray.length) {
                nArray[n4] = Integer.MIN_VALUE;
                ++n4;
            }
            System.arraycopy(this.elementArray, 0, nArray, 0, this.elementArray.length);
            this.elementArray = nArray;
        }
    }

    public void trim() {
        int n = 0;
        while (n < this.elementArray.length && this.elementArray[n] == this.getDefault(n)) {
            ++n;
        }
        int n2 = this.elementArray.length - 1;
        while (n2 >= n && this.elementArray[n2] == this.getDefault(n2)) {
            --n2;
        }
        if (n > 0 || n2 < this.elementArray.length - 1) {
            if (n <= n2) {
                int[] nArray = new int[n2 - n + 1];
                System.arraycopy(this.elementArray, n, nArray, 0, nArray.length);
                this.elementStart += n;
                this.elementArray = nArray;
                return;
            }
            this.elementStart = 0;
            this.elementArray = new int[2];
            this.elementArray[0] = Integer.MIN_VALUE;
            this.elementArray[1] = Integer.MIN_VALUE;
        }
    }

    void internalPutAll(int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        while (n2 < nArray.length) {
            if (nArray[n2] != this.get(n3)) break;
            ++n2;
            ++n3;
        }
        int n4 = nArray.length - 1;
        int n5 = n + n4;
        while (n4 >= n2) {
            if (nArray[n4] != this.get(n5)) break;
            --n4;
            --n5;
        }
        if (n2 <= n4) {
            this.grow(n3);
            this.grow(n5);
            System.arraycopy(nArray, n2, this.elementArray, n3 - this.elementStart, n4 - n2 + 1);
        }
    }

    void internalCopy(int n, int n2, int n3) {
        if (n == n2 || n3 < 1) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n + n3 - 1;
        int n7 = n2 + n3 - 1;
        while (n4 <= n6) {
            if (this.get(n4) != this.get(n5)) break;
            ++n4;
            ++n5;
        }
        while (n4 <= n6) {
            if (this.get(n6) != this.get(n7)) break;
            --n6;
            --n7;
        }
        if (n4 <= n6) {
            this.grow(n4);
            this.grow(n5);
            this.grow(n6);
            this.grow(n7);
            System.arraycopy(this.elementArray, n4 - this.elementStart, this.elementArray, n5 - this.elementStart, n6 - n4 + 1);
        }
    }
}

