/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.connect;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.go.event.GFGODamageListener;
import com.objectshare.gf.go.event.GFGOEvent;

public class GFDisplayBoxLocator
extends GFLocator
implements GFGODamageListener {
    public static float defaultXRatio = 0.5f;
    public static float defaultYRatio = 0.5f;
    public static float defaultXOffset;
    public static float defaultYOffset;
    protected GFGO target;
    protected float xRatio;
    protected float yRatio;
    protected float xOffset;
    protected float yOffset;

    public GFDisplayBoxLocator(GFGO gFGO) {
        this(gFGO, defaultXRatio, defaultYRatio, defaultXOffset, defaultYOffset);
    }

    public GFDisplayBoxLocator(GFGO gFGO, float f, float f2, float f3, float f4) {
        this.target = gFGO;
        this.xRatio = f;
        this.yRatio = f2;
        this.xOffset = f3;
        this.yOffset = f4;
    }

    public GFLocator copyForTarget(GFGO gFGO) {
        return this.copyForTargetInto(new GFDisplayBoxLocator(gFGO));
    }

    protected GFLocator copyForTargetInto(GFLocator gFLocator) {
        GFDisplayBoxLocator gFDisplayBoxLocator = (GFDisplayBoxLocator)gFLocator;
        super.copyForTargetInto(gFLocator);
        gFDisplayBoxLocator.xRatio = this.xRatio;
        gFDisplayBoxLocator.yRatio = this.yRatio;
        gFDisplayBoxLocator.xOffset = this.xOffset;
        gFDisplayBoxLocator.yOffset = this.yOffset;
        return gFLocator;
    }

    public GF2DPoint toPoint() {
        GF2DRectangle gF2DRectangle = this.target.displayBox();
        float f = gF2DRectangle.x + this.xRatio * gF2DRectangle.width + this.xOffset;
        float f2 = gF2DRectangle.y + this.yRatio * gF2DRectangle.height + this.yOffset;
        return new GF2DPoint(f, f2);
    }

    public GFGO getTarget() {
        return this.target;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + new Float(this.xRatio).hashCode();
        n = 37 * n + new Float(this.yRatio).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        GFDisplayBoxLocator gFDisplayBoxLocator = (GFDisplayBoxLocator)object;
        return this.xRatio == gFDisplayBoxLocator.xRatio && this.yRatio == gFDisplayBoxLocator.yRatio && this.xOffset == gFDisplayBoxLocator.xOffset && this.yOffset == gFDisplayBoxLocator.yOffset;
    }

    protected void listenToTarget() {
        this.target.addDamageListener(this);
    }

    protected void unlistenToTarget() {
        this.target.removeDamageListener(this);
    }

    public void goDamaged(GFGOEvent gFGOEvent) {
        this.triggerChangedEvent();
    }

    public static GFDisplayBoxLocator centerOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.5f, 0.5f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator atCenterRelative(GFGO gFGO, GF2DPoint gF2DPoint) {
        return GFDisplayBoxLocator.centerOffset(gFGO, gF2DPoint.subtract(gFGO.displayCenter()));
    }

    public static GFDisplayBoxLocator centerOffset(GFGO gFGO, GF2DPoint gF2DPoint) {
        return new GFDisplayBoxLocator(gFGO, 0.5f, 0.5f, gF2DPoint.x, gF2DPoint.y);
    }

    public static GFDisplayBoxLocator leftCenterOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.0f, 0.5f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator rightCenterOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 1.0f, 0.5f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator topCenterOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.5f, 0.0f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator bottomCenterOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.5f, 1.0f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator leftTopOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator rightTopOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator leftBottomOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public static GFDisplayBoxLocator rightBottomOf(GFGO gFGO) {
        return new GFDisplayBoxLocator(gFGO, 1.0f, 1.0f, 0.0f, 0.0f);
    }
}

