/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.networkeditor;

import com.objectshare.base.example.OSIExampleApplet;
import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFCompositeGO;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GF2DCenteringPlug;
import com.objectshare.gf.connect.GF2DConnector;
import com.objectshare.gf.connect.GF2DIndexedPointPlug;
import com.objectshare.gf.connect.GFDisplayBoxLocator;
import com.objectshare.gf.example.howto.HowTo;
import com.objectshare.gf.example.networkeditor.GFConnectionAdapter;
import com.objectshare.gf.example.networkeditor.GFConnectionGOAdapter;
import com.objectshare.gf.example.networkeditor.GFNetworkBalancer;
import com.objectshare.gf.example.networkeditor.GFNetworkNode;
import com.objectshare.gf.example.networkeditor.GFNodeGOSelectionAdapter;
import com.objectshare.gf.go.GFLineGO;
import com.objectshare.gf.go.GFRoundedRectangleGO;
import com.objectshare.gf.go.GFTextGO;
import com.objectshare.gf.tool.GFConnectionTool;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.GFToolPalette;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class NetworkEditor
extends HowTo {
    protected static String defaultNodeName = "Node-";
    protected static int defaultWeight = 20;
    protected TextField nameField;
    protected Button addButton;
    protected Button deleteButton;
    protected Button connectButton;
    protected Button balanceButton;
    protected Button stepButton;
    protected Button haltButton;
    protected Scrollbar weightScrollbar;
    protected GFNodeGOSelectionAdapter nodeSelectionListener;
    protected GFConnectionGOAdapter connectionGOListener;
    protected GFConnectionAdapter connectionToolListener;
    protected Vector nodes;
    protected GFNetworkBalancer balancer;
    protected Thread balancingThread;
    protected Random random;
    protected Font weightFont = new Font("Helvetica", 1, 14);
    protected Font nodeFont = new Font("Helvetica", 1, 12);
    protected Hashtable weightGODict = new Hashtable();

    protected void preInit() {
        this.balancer = new GFNetworkBalancer(this);
        this.random = new Random();
        this.nodes = new Vector();
        this.nodeSelectionListener = new GFNodeGOSelectionAdapter(this);
        this.connectionGOListener = new GFConnectionGOAdapter(this);
        this.connectionToolListener = new GFConnectionAdapter(this);
    }

    protected void initDrawing(GFDrawingManager gFDrawingManager) {
        ((Component)((Object)this.canvas)).setBackground(new Color(224, 255, 255));
    }

    protected void postInit(GFDrawingManager gFDrawingManager) {
        this.initDefaultNetwork();
        ((TextComponent)this.nameField).setText(this.getDefaultNodeName());
        this.updateButtonsFromName();
        this.updateButtonsFromSelection();
        this.updateScrollbarFromSelection();
        this.updateBalanceButtons();
    }

    protected void initTopControls(Panel panel) {
        this.balanceButton = new Button("Balance");
        panel.add(this.balanceButton);
        this.stepButton = new Button("Step");
        panel.add(this.stepButton);
        this.haltButton = new Button("Halt");
        panel.add(this.haltButton);
    }

    protected void initBottomControls(Panel panel) {
        this.addButton = new Button("Add Node:");
        panel.add(this.addButton);
        this.nameField = new TextField(15);
        panel.add(this.nameField);
        panel.add(new Label("   "));
        this.connectButton = new Button("Connect Nodes");
        panel.add(this.connectButton);
    }

    protected void initRightControls(Panel panel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        Label label = new Label("Traffic");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.weightScrollbar = new Scrollbar(1, 100, 5, 0, 100);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(this.weightScrollbar, gridBagConstraints);
        panel.add(this.weightScrollbar);
    }

    protected void initDefaultNetwork() {
        GF2DRectangle gF2DRectangle = this.manager.getWorldPort();
        GFGO gFGO = this.addNode("San Francisco", new GF2DPoint(gF2DRectangle.x + gF2DRectangle.width * 0.2f, gF2DRectangle.y + gF2DRectangle.height * 0.2f));
        GFGO gFGO2 = this.addNode("Chicago", new GF2DPoint(gF2DRectangle.x + gF2DRectangle.width * 0.5f, gF2DRectangle.y + gF2DRectangle.height * 0.3f));
        GFGO gFGO3 = this.addNode("New York", new GF2DPoint(gF2DRectangle.x + gF2DRectangle.width * 0.8f, gF2DRectangle.y + gF2DRectangle.height * 0.25f));
        GFGO gFGO4 = this.addNode("Dallas", new GF2DPoint(gF2DRectangle.x + gF2DRectangle.width * 0.45f, gF2DRectangle.y + gF2DRectangle.height * 0.75f));
        GFGO gFGO5 = this.addNode("Atlanta", new GF2DPoint(gF2DRectangle.x + gF2DRectangle.width * 0.75f, gF2DRectangle.y + gF2DRectangle.height * 0.65f));
        this.connectNodes(gFGO, gFGO2, 34);
        this.connectNodes(gFGO2, gFGO3, 35);
        this.connectNodes(gFGO2, gFGO4, 23);
        this.connectNodes(gFGO, gFGO4, 52);
        this.connectNodes(gFGO4, gFGO3, 26);
        this.connectNodes(gFGO3, gFGO5, 31);
        this.connectNodes(gFGO4, gFGO5, 18);
        this.connectNodes(gFGO, gFGO5, 15);
    }

    public void initPalette(GFToolPalette gFToolPalette) {
        GFToolCategory gFToolCategory = new GFToolCategory("com.objectshare.gf.tool.GFSelectionTool.gif");
        gFToolCategory.addTool(this.createSelectionTool());
        gFToolCategory.addTool(this.createZoomTool());
        gFToolCategory.addTool(this.createPanTool());
        GFLineGO gFLineGO = new GFLineGO(0.0f, 0.0f, 0.0f, 0.0f);
        gFLineGO.setColor(this.getConnectionLineColor());
        GFConnectionTool gFConnectionTool = new GFConnectionTool(gFLineGO);
        gFConnectionTool.addConnectionToolListener(this.connectionToolListener);
        gFToolCategory.addTool(gFConnectionTool);
        gFToolPalette.addCategory(gFToolCategory);
    }

    public void stop() {
        this.stopBalancing();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.weightScrollbar) {
            this.weightScrolled();
            ((Component)((Object)this.canvas)).repaint();
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.addButton) {
            this.addButtonClicked();
            return true;
        }
        if (event.target == this.connectButton) {
            this.connectButtonClicked();
            return true;
        }
        if (event.target == this.balanceButton) {
            this.startBalancing();
            return true;
        }
        if (event.target == this.haltButton) {
            this.stopBalancing();
            return true;
        }
        if (event.target == this.stepButton) {
            this.stepBalancing();
            return true;
        }
        return super.action(event, object);
    }

    public boolean keyUp(Event event, int n) {
        if (event.target == this.nameField) {
            this.updateButtonsFromName();
        }
        return super.keyUp(event, n);
    }

    protected void addButtonClicked() {
        this.addNode();
        this.manager.redraw();
    }

    protected void deleteButtonClicked() {
    }

    protected void connectButtonClicked() {
        this.connectSelectedNodes();
        this.manager.unselectAll();
        this.manager.redraw();
    }

    protected void weightScrolled() {
        this.setSelectionWeight(this.weightScrollbar.getMaximum() - this.weightScrollbar.getValue());
    }

    protected void updateButtonsFromName() {
        this.addButton.enable(this.nameField.getText().trim().length() > 0);
    }

    protected void updateButtonsFromSelection() {
        GFGOArray gFGOArray = this.getSelectedNodeGOs();
        this.connectButton.enable(gFGOArray.size() >= 2);
    }

    protected void updateScrollbarFromSelection() {
        GFGOArray gFGOArray = this.getSelectedConnectionGOs();
        if (gFGOArray.size() >= 1) {
            GFNetworkNode[] gFNetworkNodeArray = (GFNetworkNode[])gFGOArray.elementAt(0).getMetaObject();
            int n = gFNetworkNodeArray[0].getWeight(gFNetworkNodeArray[1]);
            this.weightScrollbar.setValue(this.weightScrollbar.getMaximum() - n);
            this.weightScrollbar.enable();
            return;
        }
        this.weightScrollbar.disable();
    }

    protected void updateBalanceButtons() {
        boolean bl = this.balancingThread != null;
        this.balanceButton.enable(!bl);
        this.stepButton.enable(!bl);
        this.haltButton.enable(bl);
    }

    public int getDefaultWeight() {
        return defaultWeight;
    }

    public GFNetworkNode addNode(String string) {
        GFNetworkNode gFNetworkNode = new GFNetworkNode(string);
        this.nodes.addElement(gFNetworkNode);
        return gFNetworkNode;
    }

    public void setWeight(GFNetworkNode gFNetworkNode, GFNetworkNode gFNetworkNode2, int n) {
        if (gFNetworkNode.isConnected(gFNetworkNode2)) {
            gFNetworkNode.setWeight(gFNetworkNode2, n);
        }
    }

    public GFNetworkNode[] connectNodes(GFNetworkNode gFNetworkNode, GFNetworkNode gFNetworkNode2, int n) {
        if (gFNetworkNode.isConnected(gFNetworkNode2)) {
            return null;
        }
        gFNetworkNode.connect(gFNetworkNode2);
        GFNetworkNode[] gFNetworkNodeArray = new GFNetworkNode[]{gFNetworkNode, gFNetworkNode2};
        this.setWeight(gFNetworkNode, gFNetworkNode2, n);
        return gFNetworkNodeArray;
    }

    public Color getConnectionLineColor() {
        return new Color(128, 32, 128);
    }

    public boolean isConnected(GFGO gFGO, GFGO gFGO2) {
        GFNetworkNode gFNetworkNode = (GFNetworkNode)gFGO.getMetaObject();
        GFNetworkNode gFNetworkNode2 = (GFNetworkNode)gFGO2.getMetaObject();
        return gFNetworkNode.isConnected(gFNetworkNode2);
    }

    public void addNode() {
        String string = this.nameField.getText().trim();
        if (string.length() == 0) {
            return;
        }
        this.addNode(string, this.defaultNodePosition());
        ((TextComponent)this.nameField).setText(this.getDefaultNodeName());
    }

    public GFGO addNode(String string, GF2DPoint gF2DPoint) {
        GFNetworkNode gFNetworkNode = this.addNode(string);
        GF2DGO gF2DGO = this.nodeGOFor(gFNetworkNode);
        gF2DGO.translateCenter(gF2DPoint);
        this.manager.add(gF2DGO);
        gF2DGO.addSelectionListener(this.nodeSelectionListener);
        return gF2DGO;
    }

    protected GF2DPoint defaultNodePosition() {
        GF2DRectangle gF2DRectangle = this.manager.getWorldPort();
        float f = (float)(this.random.nextGaussian() * (double)gF2DRectangle.width / 8.0);
        float f2 = (float)(this.random.nextGaussian() * (double)gF2DRectangle.height / 8.0);
        return gF2DRectangle.center().add(f, f2);
    }

    protected String getDefaultNodeName() {
        return String.valueOf(defaultNodeName) + (this.nodes.size() + 1);
    }

    protected GF2DGO nodeGOFor(GFNetworkNode gFNetworkNode) {
        GFTextGO gFTextGO = new GFTextGO(gFNetworkNode.getName());
        gFTextGO.setFont(this.nodeFont);
        GF2DDimension gF2DDimension = gFTextGO.displayExtent();
        GFRoundedRectangleGO gFRoundedRectangleGO = new GFRoundedRectangleGO(new GF2DPoint(0.0f, 0.0f), gF2DDimension.add(30.0f, 30.0f));
        gFRoundedRectangleGO.setFillColor(Color.yellow);
        gFTextGO.translateCenter(gFRoundedRectangleGO.displayCenter());
        GFCompositeGO gFCompositeGO = new GFCompositeGO();
        gFCompositeGO.add(gFRoundedRectangleGO);
        gFCompositeGO.add(gFTextGO);
        gFCompositeGO.setGroupMode(true);
        gFCompositeGO.setMetaObject(gFNetworkNode);
        return gFCompositeGO;
    }

    public void connectNodes(GFGO gFGO, GFGO gFGO2, GFLineGO gFLineGO, int n) {
        GFNetworkNode gFNetworkNode;
        GFNetworkNode gFNetworkNode2 = (GFNetworkNode)gFGO.getMetaObject();
        GFNetworkNode[] gFNetworkNodeArray = this.connectNodes(gFNetworkNode2, gFNetworkNode = (GFNetworkNode)gFGO2.getMetaObject(), n);
        if (gFNetworkNodeArray == null) {
            return;
        }
        gFLineGO.setMetaObject(gFNetworkNodeArray);
        gFLineGO.addSelectionListener(this.connectionGOListener);
        gFLineGO.addHandleListener(this.connectionGOListener);
        GFTextGO gFTextGO = new GFTextGO(0.0f, 0.0f, Integer.toString(n), this.weightFont, Color.red);
        gFTextGO.setMetaObject(gFNetworkNodeArray);
        gFTextGO.addSelectionListener(this.connectionGOListener);
        gFTextGO.addHandleListener(this.connectionGOListener);
        new GF2DConnector(new GFDisplayBoxLocator(gFLineGO), new GF2DCenteringPlug(gFTextGO));
        this.manager.addLast(gFTextGO);
        this.weightGODict.put(gFNetworkNodeArray, gFTextGO);
    }

    public void connectNodes(GFGO gFGO, GFGO gFGO2, int n) {
        if (this.isConnected(gFGO, gFGO2)) {
            return;
        }
        GFLineGO gFLineGO = new GFLineGO(0.0f, 0.0f, 0.0f, 0.0f);
        gFLineGO.setColor(this.getConnectionLineColor());
        this.manager.addFirst(gFLineGO);
        new GF2DConnector(new GFDisplayBoxLocator(gFGO), new GF2DIndexedPointPlug(gFLineGO, 0));
        new GF2DConnector(new GFDisplayBoxLocator(gFGO2), new GF2DIndexedPointPlug(gFLineGO, 1));
        this.connectNodes(gFGO, gFGO2, gFLineGO, n);
    }

    public void connectSelectedNodes() {
        GFGOArray gFGOArray = this.getSelectedNodeGOs();
        int n = 0;
        while (n < gFGOArray.size()) {
            int n2 = n + 1;
            while (n2 < gFGOArray.size()) {
                this.connectNodes(gFGOArray.elementAt(n), gFGOArray.elementAt(n2), this.getDefaultWeight());
                ++n2;
            }
            ++n;
        }
    }

    protected void setSelectionWeight(int n) {
        GFGOArray gFGOArray = this.getSelectedConnectionGOs();
        int n2 = 0;
        while (n2 < gFGOArray.size()) {
            GFNetworkNode[] gFNetworkNodeArray = (GFNetworkNode[])gFGOArray.elementAt(n2).getMetaObject();
            this.setWeight(gFNetworkNodeArray[0], gFNetworkNodeArray[1], n);
            GFTextGO gFTextGO = this.getWeightGO(gFNetworkNodeArray[0], gFNetworkNodeArray[1]);
            gFTextGO.setText(Integer.toString(n));
            ++n2;
        }
    }

    protected GF2DGO getNodeGO(GFNetworkNode gFNetworkNode) {
        Enumeration enumeration = this.manager.contentElements();
        while (enumeration.hasMoreElements()) {
            GF2DGraphicObject gF2DGraphicObject = (GF2DGraphicObject)enumeration.nextElement();
            if (gF2DGraphicObject.getMetaObject() != gFNetworkNode) continue;
            return gF2DGraphicObject;
        }
        return null;
    }

    protected GFTextGO getWeightGO(GFNetworkNode gFNetworkNode, GFNetworkNode gFNetworkNode2) {
        Enumeration enumeration = this.weightGODict.keys();
        while (enumeration.hasMoreElements()) {
            GFNetworkNode[] gFNetworkNodeArray = (GFNetworkNode[])enumeration.nextElement();
            if ((gFNetworkNodeArray[0] != gFNetworkNode || gFNetworkNodeArray[1] != gFNetworkNode2) && (gFNetworkNodeArray[0] != gFNetworkNode2 || gFNetworkNodeArray[1] != gFNetworkNode)) continue;
            return (GFTextGO)this.weightGODict.get(gFNetworkNodeArray);
        }
        return null;
    }

    protected boolean isNodeGO(GFGO gFGO) {
        return gFGO.getMetaObject() instanceof GFNetworkNode;
    }

    protected boolean isConnectionGO(GFGO gFGO) {
        return gFGO.getMetaObject() instanceof GFNetworkNode[];
    }

    protected GFGOArray getSelectedNodeGOs() {
        GFGOArray gFGOArray = this.manager.getSelection();
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(gFGOArray.size());
        int n = 0;
        while (n < gFGOArray.size()) {
            if (this.isNodeGO(gFGOArray.elementAt(n))) {
                gFUnsortedGOArray.add(gFGOArray.elementAt(n));
            }
            ++n;
        }
        return gFUnsortedGOArray;
    }

    protected GFGOArray getSelectedConnectionGOs() {
        GFGOArray gFGOArray = this.manager.getSelection();
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(gFGOArray.size());
        int n = 0;
        while (n < gFGOArray.size()) {
            if (this.isConnectionGO(gFGOArray.elementAt(n))) {
                gFUnsortedGOArray.add(gFGOArray.elementAt(n));
            }
            ++n;
        }
        return gFUnsortedGOArray;
    }

    protected void startBalancing() {
        if (this.balancingThread == null) {
            this.balancingThread = new Thread(this.balancer);
            this.updateBalanceButtons();
            this.balancingThread.start();
        }
    }

    protected void stopBalancing() {
        if (this.balancingThread != null) {
            Thread thread = this.balancingThread;
            this.balancingThread = null;
            this.updateBalanceButtons();
            thread.stop();
        }
    }

    protected void stepBalancing() {
        this.stopBalancing();
        this.balancer.stepNetwork();
    }

    public static void main(String[] stringArray) {
        NetworkEditor networkEditor = new NetworkEditor();
        new OSIExampleFrame((OSIExampleApplet)networkEditor, ((Object)((Object)networkEditor)).getClass().getName(), 580, 400);
    }
}

