/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Color;

public class GFGridGO
extends GF2DGraphicObject {
    protected GF2DDimension gridSpacing;
    protected GF2DPoint gridOrigin;
    protected Color verticalColor = Color.black;
    protected Color horizontalColor = Color.black;

    public GFGridGO(GF2DDimension gF2DDimension, GF2DPoint gF2DPoint) {
        this.basicSetGridSpacing(gF2DDimension);
        this.basicSetGridOrigin(gF2DPoint);
    }

    public GFGridGO(float f, float f2, float f3, float f4) {
        this(new GF2DDimension(f, f2), new GF2DPoint(f3, f4));
    }

    public GFGridGO(GF2DDimension gF2DDimension) {
        this(gF2DDimension, new GF2DPoint(0.0f, 0.0f));
    }

    public GFGridGO(float f, float f2) {
        this(new GF2DDimension(f, f2));
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFGridGO(this.gridSpacing, this.gridOrigin));
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFGridGO gFGridGO = (GFGridGO)gFGO;
        gFGridGO.setVerticalColor(this.getVerticalColor());
        gFGridGO.setHorizontalColor(this.getHorizontalColor());
        return gFGO;
    }

    public GF2DDimension getGridSpacing() {
        return this.gridSpacing;
    }

    protected void basicSetGridSpacing(GF2DDimension gF2DDimension) {
        this.gridSpacing = gF2DDimension;
    }

    public void setGridSpacing(GF2DDimension gF2DDimension) {
        this.basicSetGridSpacing(gF2DDimension);
        this.damaged();
    }

    public void setGridSpacing(float f, float f2) {
        this.setGridSpacing(new GF2DDimension(f, f2));
    }

    public GF2DPoint getGridOrigin() {
        return this.gridOrigin;
    }

    protected void basicSetGridOrigin(GF2DPoint gF2DPoint) {
        this.gridOrigin = gF2DPoint;
    }

    public void setGridOrigin(GF2DPoint gF2DPoint) {
        this.basicSetGridOrigin(gF2DPoint);
        this.damaged();
    }

    public void setGridOrigin(float f, float f2) {
        this.setGridOrigin(new GF2DPoint(f, f2));
    }

    public Color getVerticalColor() {
        return this.verticalColor;
    }

    public void setVerticalColor(Color color) {
        this.verticalColor = color;
        this.damaged();
    }

    public Color getHorizontalColor() {
        return this.horizontalColor;
    }

    public void setHorizontalColor(Color color) {
        this.horizontalColor = color;
        this.damaged();
    }

    public GF2DRectangle displayBox() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager == null) {
            return new GF2DRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return gFDrawingManager.getWorldPort();
    }

    protected void basicDisplay(GFGraphics gFGraphics, Color color, Color color2) {
        float f;
        int n;
        GF2DRectangle gF2DRectangle = gFGraphics.getClipRect();
        if (this.verticalColor != null) {
            gFGraphics.setColor(this.verticalColor);
            n = (int)(gF2DRectangle.left() / this.gridSpacing.width);
            f = (float)n * this.gridSpacing.width;
            while (f <= gF2DRectangle.right()) {
                gFGraphics.drawLine(f, gF2DRectangle.top(), f, gF2DRectangle.bottom());
                f = (float)(++n) * this.gridSpacing.width;
            }
        }
        if (this.horizontalColor != null) {
            gFGraphics.setColor(this.horizontalColor);
            n = (int)(gF2DRectangle.top() / this.gridSpacing.height);
            f = (float)n * this.gridSpacing.height;
            while (f <= gF2DRectangle.bottom()) {
                gFGraphics.drawLine(gF2DRectangle.left(), f, gF2DRectangle.right(), f);
                f = (float)(++n) * this.gridSpacing.height;
            }
        }
    }

    public void display(GFGraphics gFGraphics) {
        this.basicDisplay(gFGraphics, this.verticalColor, this.horizontalColor);
    }

    public void displayShape(GFGraphics gFGraphics) {
        this.basicDisplay(gFGraphics, this.verticalColor == null ? null : Color.black, this.horizontalColor == null ? null : Color.black);
    }
}

