/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFDrawingCanvas;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.event.GFDrawingEvent;
import com.objectshare.gf.base.event.GFDrawingXFormListener;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.java.osi.OSIEventTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GFHostGO
extends GF2DGraphicObject
implements GFDrawingXFormListener,
MouseListener,
MouseMotionListener,
KeyListener {
    protected Component hostComponent;
    protected GF2DRectangle displayBox;
    protected Font font;
    protected boolean toolEventsEnabled = false;
    protected boolean hostEventsEnabled = true;

    public GFHostGO(Component component) {
        this(component, new GF2DRectangle(component.size().width, component.size().height));
    }

    public GFHostGO(Component component, GF2DRectangle gF2DRectangle) {
        this(component, gF2DRectangle, component.getFont());
    }

    public GFHostGO(Component component, GF2DRectangle gF2DRectangle, Font font) {
        if (component == null || gF2DRectangle == null) {
            throw new IllegalArgumentException("invalid null argument");
        }
        this.hostComponent = component;
        this.displayBox = gF2DRectangle;
        this.font = font;
        this.updateHost();
    }

    public GFGO copyForCreation() {
        Component component = null;
        if (component == null) {
            try {
                component = (Component)this.hostComponent.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                component = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                component = null;
            }
        }
        if (component == null) {
            System.out.println("cannot clone or instantiate host component");
            return null;
        }
        return new GFHostGO(component, this.displayBox(), this.getFont());
    }

    public Component getHostComponent() {
        return this.hostComponent;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.hostComponent.getFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.basicSetFont(font);
    }

    public void basicSetFont(Font font) {
        this.font = font;
        this.updateHostFont();
    }

    public boolean getToolEventsEnabled() {
        return this.toolEventsEnabled;
    }

    public void setToolEventsEnabled(boolean bl) {
        if (this.toolEventsEnabled != bl) {
            if (this.getHostEventsEnabled()) {
                this.updateHostListeners(bl);
            }
            this.toolEventsEnabled = bl;
        }
    }

    public boolean getHostEventsEnabled() {
        return this.hostEventsEnabled;
    }

    public void setHostEventsEnabled(boolean bl) {
        if (this.hostEventsEnabled != bl) {
            if (!this.getToolEventsEnabled()) {
                this.updateHostListeners(!bl);
            }
            this.hostEventsEnabled = bl;
        }
    }

    protected void updateHostListeners(boolean bl) {
        if (bl) {
            OSIEventTable.addMouseListener((Component)this.hostComponent, (MouseListener)this);
            OSIEventTable.addMouseMotionListener((Component)this.hostComponent, (MouseMotionListener)this);
            OSIEventTable.addKeyListener((Component)this.hostComponent, (KeyListener)this);
            return;
        }
        OSIEventTable.removeMouseListener((Component)this.hostComponent, (MouseListener)this);
        OSIEventTable.removeMouseMotionListener((Component)this.hostComponent, (MouseMotionListener)this);
        OSIEventTable.removeKeyListener((Component)this.hostComponent, (KeyListener)this);
    }

    protected MouseEvent translateMouseEvent(MouseEvent mouseEvent) {
        Point point = this.hostComponent.location();
        return new MouseEvent((Component)((Object)this.getManager().getCanvas()), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected KeyEvent translateKeyEvent(KeyEvent keyEvent) {
        return new KeyEvent((Component)((Object)this.getManager().getCanvas()), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processMouseEvent(this.translateMouseEvent(mouseEvent));
        }
        if (!this.getHostEventsEnabled()) {
            mouseEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processKeyEvent(this.translateKeyEvent(keyEvent));
        }
        if (!this.getHostEventsEnabled()) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processKeyEvent(this.translateKeyEvent(keyEvent));
        }
        if (!this.getHostEventsEnabled()) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.getToolEventsEnabled()) {
            this.getManager().processKeyEvent(this.translateKeyEvent(keyEvent));
        }
        if (!this.getHostEventsEnabled()) {
            keyEvent.consume();
        }
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        this.displayBox = new GF2DRectangle(f, f2, f3, f4);
        this.updateHostBounds();
        return true;
    }

    public boolean basicTranslate(float f, float f2) {
        return this.basicReshape(this.displayBox.x + f, this.displayBox.y + f2, this.displayBox.width, this.displayBox.height);
    }

    public void drawingTransformChanged(GFDrawingEvent gFDrawingEvent) {
        this.updateHost();
    }

    public GF2DDimension displayExtent() {
        return this.displayBox.extent();
    }

    public GF2DRectangle displayBox() {
        return this.displayBox;
    }

    public void display(GFGraphics gFGraphics) {
    }

    public void displayShape(GFGraphics gFGraphics) {
        gFGraphics.setColor(Color.black);
        gFGraphics.fillRect(this.displayBox());
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        GFDrawingManager gFDrawingManager2;
        GFDrawingManager gFDrawingManager3;
        GFDrawingCanvas gFDrawingCanvas;
        Container container = this.hostComponent.getParent();
        GFDrawingCanvas gFDrawingCanvas2 = gFDrawingCanvas = gFDrawingManager != null ? gFDrawingManager.getCanvas() : null;
        if (container != gFDrawingCanvas) {
            if (container != null) {
                container.remove(this.hostComponent);
            }
            if (gFDrawingCanvas != null) {
                this.updateHost();
                ((Container)((Object)gFDrawingCanvas)).add(this.hostComponent);
            }
        }
        if ((gFDrawingManager3 = this.getManager()) != (gFDrawingManager2 = gFDrawingManager)) {
            if (gFDrawingManager3 != null) {
                gFDrawingManager3.removeTransformListener(this);
            }
            if (gFDrawingManager2 != null) {
                gFDrawingManager2.addTransformListener(this);
            }
            super.basicSetManager(gFDrawingManager);
        }
    }

    public void updateHost() {
        this.updateHostBounds();
        this.updateHostFont();
    }

    public void updateHostBounds() {
        Rectangle rectangle = this.getWorldViewTransform().world2View(this.displayBox);
        this.hostComponent.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void updateHostFont() {
        if (this.getFont() != null) {
            this.hostComponent.setFont(GFGraphics.transformFont(this.getFont(), this.getWorldViewTransform()));
        }
    }
}

