/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFCompositeGO;
import com.objectshare.gf.base.GFDrawingCanvas;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.GFButtonGO;
import com.objectshare.gf.tool.GFGOAction;
import com.objectshare.gf.tool.GFGOActionTool;
import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.GFToolPalette;
import com.objectshare.gf.tool.GFToolPaletteElement;
import com.objectshare.gf.tool.event.GFPaletteCategoryEvent;
import com.objectshare.gf.tool.event.GFPaletteListener;
import com.objectshare.gf.tool.event.GFPaletteToolEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GFToolPaletteGO
extends GFCompositeGO
implements GFPaletteListener,
GFGOAction {
    public static int defaultButtonWidth = 19;
    public static int defaultButtonHeight = 19;
    public int buttonWidth = defaultButtonWidth;
    public int buttonHeight = defaultButtonHeight;
    protected GFToolPalette palette;
    protected Hashtable paletteMap = new Hashtable();

    public GFToolPaletteGO(GFToolPalette gFToolPalette) {
        this.setPalette(gFToolPalette);
    }

    public GFDrawingCanvas newDrawingCanvas() {
        GFDrawingCanvas gFDrawingCanvas = new GFDrawingCanvas(defaultButtonWidth * 2 + 1, defaultButtonHeight * 2 + 1);
        GFDrawingManager gFDrawingManager = gFDrawingCanvas.getManager();
        gFDrawingManager.add(this);
        gFDrawingManager.setTool(new GFGOActionTool(this));
        return gFDrawingCanvas;
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFToolPaletteGO(this.palette));
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFToolPaletteGO gFToolPaletteGO = (GFToolPaletteGO)gFGO;
        gFToolPaletteGO.buttonWidth = this.buttonWidth;
        gFToolPaletteGO.buttonHeight = this.buttonHeight;
        return gFGO;
    }

    public void performAction(GFDrawingManager gFDrawingManager, GFGO gFGO, GFDrawingMouseEvent gFDrawingMouseEvent) {
        Object v;
        if (gFGO != null && this.palette != null && (v = this.paletteMap.get(gFGO)) != null) {
            if (v instanceof GFTool) {
                this.palette.setTool((GFTool)v);
                return;
            }
            if (v instanceof GFToolCategory) {
                this.palette.setCategory((GFToolCategory)v);
            }
        }
    }

    public void setToolSize(int n, int n2) {
        if (n != this.buttonWidth || n2 != this.buttonHeight) {
            this.releaseGOs();
            this.buttonWidth = n;
            this.buttonHeight = n2;
            this.buildGOs();
        }
    }

    public GFToolPalette getPalette() {
        return this.palette;
    }

    public void setPalette(GFToolPalette gFToolPalette) {
        if (this.palette != gFToolPalette) {
            if (this.palette != null) {
                this.palette.removeToolPaletteListener(this);
                this.releaseGOs();
            }
            this.palette = gFToolPalette;
            if (this.palette != null) {
                this.buildGOs();
                this.palette.addToolPaletteListener(this);
            }
        }
    }

    public void toolCategoryAdded(GFPaletteCategoryEvent gFPaletteCategoryEvent) {
        GFToolCategory gFToolCategory = gFPaletteCategoryEvent.getCategory();
        this.buildGO(gFToolCategory);
        this.repositionCategories();
        if (gFToolCategory == gFPaletteCategoryEvent.getPalette().getCategory()) {
            this.selectCategory(gFToolCategory);
        }
        this.redraw();
    }

    public void toolCategorySelected(GFPaletteCategoryEvent gFPaletteCategoryEvent) {
        this.selectCategory(gFPaletteCategoryEvent.getCategory());
        this.redraw();
    }

    public void toolCategoryRemoved(GFPaletteCategoryEvent gFPaletteCategoryEvent) {
        this.releasePair(gFPaletteCategoryEvent.getCategory());
        this.repositionCategories();
        this.redraw();
    }

    public void toolAdded(GFPaletteToolEvent gFPaletteToolEvent) {
        GFToolCategory gFToolCategory = gFPaletteToolEvent.getCategory();
        if (gFToolCategory == gFPaletteToolEvent.getPalette().getCategory()) {
            this.buildGO(gFPaletteToolEvent.getTool());
            this.repositionTools();
            this.redraw();
        }
    }

    public void toolSelected(GFPaletteToolEvent gFPaletteToolEvent) {
        this.selectTool(gFPaletteToolEvent.getTool());
        this.redraw();
    }

    public void toolRemoved(GFPaletteToolEvent gFPaletteToolEvent) {
        if (gFPaletteToolEvent.getCategory() == gFPaletteToolEvent.getPalette().getCategory()) {
            this.releasePair(gFPaletteToolEvent.getTool());
            this.repositionTools();
            this.redraw();
        }
    }

    protected void buildGO(GFToolPaletteElement gFToolPaletteElement) {
        GFButtonGO gFButtonGO = new GFButtonGO(gFToolPaletteElement.getImage(), 0.0f, 0.0f, this.buttonWidth, this.buttonHeight);
        this.paletteMap.put(gFToolPaletteElement, gFButtonGO);
        this.paletteMap.put(gFButtonGO, gFToolPaletteElement);
    }

    protected void buildGOs(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.buildGO((GFToolPaletteElement)enumeration.nextElement());
        }
    }

    protected void buildGOs() {
        this.buildGOs(this.palette.getCategories());
        this.repositionCategories();
        this.selectCategory(this.palette.getCategory());
    }

    protected Vector getCategories() {
        Object object;
        Enumeration<Object> enumeration;
        Vector<Object> vector = new Vector<Object>();
        if (this.palette != null) {
            enumeration = this.palette.getCategories().elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!this.paletteMap.containsKey(object)) continue;
                vector.addElement(object);
            }
        }
        enumeration = this.paletteMap.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof GFToolCategory) || vector.contains(object)) continue;
            vector.addElement(object);
        }
        return vector;
    }

    protected void repositionCategories() {
        this.repositionGOs(this.getCategories(), 0, 0);
    }

    protected Vector getTools() {
        Enumeration enumeration;
        Object object;
        Vector vector = new Vector();
        if (this.palette != null && (object = this.palette.getCategory()) != null) {
            enumeration = ((GFToolCategory)object).getTools().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!this.paletteMap.containsKey(e)) continue;
                vector.addElement(e);
            }
        }
        object = this.paletteMap.elements();
        while (object.hasMoreElements()) {
            enumeration = object.nextElement();
            if (!(enumeration instanceof GFTool) || vector.contains(enumeration)) continue;
            vector.addElement(enumeration);
        }
        return vector;
    }

    protected void repositionTools() {
        this.repositionGOs(this.getTools(), this.buttonWidth, 0);
    }

    protected void repositionGOs(Vector vector, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GF2DGO gF2DGO = (GF2DGO)this.paletteMap.get(enumeration.nextElement());
            GF2DRectangle gF2DRectangle = gF2DGO.displayBox();
            gF2DGO.translate((float)n3 - gF2DRectangle.x, (float)n4 - gF2DRectangle.y);
            this.add(gF2DGO);
            n4 += this.buttonHeight;
        }
    }

    protected void selectCategory(GFToolCategory gFToolCategory) {
        this.releaseTools();
        this.selectGO(gFToolCategory, this.getCategories());
        if (gFToolCategory != null) {
            this.buildGOs(gFToolCategory.getTools());
            this.repositionTools();
            this.selectTool(this.palette.getTool());
        }
    }

    protected void selectTool(GFTool gFTool) {
        this.selectGO(gFTool, this.getTools());
    }

    protected void selectGO(Object object, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object v = this.paletteMap.get(e);
            if (!(v instanceof GFButtonGO)) continue;
            ((GFButtonGO)v).setState(e == object);
        }
    }

    protected void releasePair(Object object) {
        if (object != null) {
            Object v = this.paletteMap.get(object);
            if (v != null) {
                this.paletteMap.remove(object);
                this.releasePair(v);
            }
            if (object instanceof GF2DGO) {
                this.remove((GF2DGO)object);
            }
        }
    }

    protected void releaseTools() {
        Enumeration enumeration = this.getTools().elements();
        while (enumeration.hasMoreElements()) {
            this.releasePair(enumeration.nextElement());
        }
    }

    protected void releaseGOs() {
        Enumeration enumeration = this.paletteMap.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof GF2DGO)) continue;
            this.remove((GF2DGO)v);
        }
        this.paletteMap = new Hashtable();
    }
}

