/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.go.GF2DIndexedPointGO;
import java.awt.Dimension;

public class GF2DPointHandle
extends GFHandle {
    public static float defaultXRatio = 1.0f;
    public static float defaultYRatio = 1.0f;
    protected float xRatio;
    protected float yRatio;
    protected int pointIndex;
    protected GF2DPoint initialPoint;
    protected GF2DIndexedPointGO theOwner;

    protected GF2DPointHandle() {
        this(null, 0);
    }

    public GF2DPointHandle(GFLocator gFLocator, int n) {
        this(gFLocator, n, defaultXRatio, defaultYRatio);
    }

    public GF2DPointHandle(GFLocator gFLocator, int n, float f, float f2) {
        this(gFLocator, n, f, f2, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
    }

    public GF2DPointHandle(GFLocator gFLocator, int n, float f, float f2, String string, Dimension dimension, boolean bl, boolean bl2) {
        super(gFLocator, string, dimension, bl, bl2);
        this.pointIndex = n;
        this.xRatio = f;
        this.yRatio = f2;
    }

    public GFHandle copyForOwner(GFGO gFGO) {
        return this.copyForOwnerInto(new GF2DPointHandle(), gFGO);
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        GF2DPointHandle gF2DPointHandle = (GF2DPointHandle)gFHandle;
        super.copyForOwnerInto(gFHandle);
        gF2DPointHandle.xRatio = this.xRatio;
        gF2DPointHandle.yRatio = this.yRatio;
        gF2DPointHandle.pointIndex = this.pointIndex;
        return gFHandle;
    }

    public GF2DIndexedPointGO get2DIndexedPointOwner() {
        GFGO gFGO;
        if (this.theOwner == null && (gFGO = this.getOwner()) instanceof GF2DIndexedPointGO) {
            this.theOwner = (GF2DIndexedPointGO)gFGO;
        }
        return this.theOwner;
    }

    public GF2DPoint newPointFrom(GF2DPoint gF2DPoint, float f, float f2) {
        float f3 = gF2DPoint.x + this.xRatio * f;
        float f4 = gF2DPoint.y + this.yRatio * f2;
        return new GF2DPoint(f3, f4);
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDown(gFDrawingMouseEvent);
        GF2DIndexedPointGO gF2DIndexedPointGO = this.get2DIndexedPointOwner();
        if (gF2DIndexedPointGO != null) {
            this.initialPoint = gF2DIndexedPointGO.getPoint(this.pointIndex);
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDrag(gFDrawingMouseEvent);
        GF2DPoint gF2DPoint = this.newPointFrom(this.initialPoint, gFDrawingMouseEvent.getWorldX() - this.mouseDownEvent.getWorldX(), gFDrawingMouseEvent.getWorldY() - this.mouseDownEvent.getWorldY());
        GF2DIndexedPointGO gF2DIndexedPointGO = this.get2DIndexedPointOwner();
        if (gF2DIndexedPointGO != null) {
            gF2DIndexedPointGO.setPoint(this.pointIndex, gF2DPoint);
            gFDrawingMouseEvent.setHandled(true);
        }
    }
}

