// Please refer to the readme on how to run this sample.

package COM.ibm.ivj.examples.database.minisamp.ODBC;
import  ODBCgen.*;

import java.lang.*;
import java.util.*;
import COM.ibm.ivj.javabeans.*;

public class fill
{
   public static void main(String argv[])
   {
      try
      {
         // Create the Datastore and Manager objects
         DepartmentDatastore theDepartmentDatastore = new DepartmentDatastore();
         DepartmentManager   theDeptMgr             = new DepartmentManager();

         // Connect to database
         System.out.println("Connecting to DEPARTMENT database...");
         theDepartmentDatastore.connect();
         System.out.println("...Connected");

         System.out.println("Listing of all departments, sorted by name:");

         // Open the cursor on the entire database,
         // ordering the records by department name
         theDeptMgr.open( "ORDER BY DEPTNAME" );

         // Fetch all the rows into a vector
         IVector vec = new IVector();
         int numRows = theDeptMgr.fill( vec, 0 );
         int i;

         // loop through the vector
         for( i = 0; i < numRows; i++ )
         {
            // Get the row out of the vector
            Department theDept = (Department)vec.elementAt( i );

            // Print out the row
            System.out.println( theDept.toString() );
         }

         // close the cursor
         theDeptMgr.close();

         // Disconnect from the database
         theDepartmentDatastore.rollback();
         theDepartmentDatastore.disconnect();

         // All done
         System.out.println();
         System.out.println("Done");
       }

       // Catch all Throwables here and print out what information we can.
       catch (Throwable s)
       {
          System.out.println( "Throwable caught:" );
          System.out.println( "message: " + s.getMessage() );
          System.out.println( "Stack Trace:" );
          s.printStackTrace();
       }
   }
}
