// *****************************************************************
//
// Name:        IList.java
//
// Description: The IList JavaBean is used to view an IVector bean.
//              When the IList is created with an IVector or the IVector
//              property in IList is set, it creates a listener to observe
//              any change in the IVector.
//              The IList listener will redisplay the IVector when
//              the IVector is changed.
//
//
// Author:      Victor Chan
// *****************************************************************
//
// copyright:    Licensed Materials - Property of IBM
//
//               xxx-yyy (C) Copyright IBM Corporation 1995.
//               All rights reserved.
//               US Government Users Restricted Rights - Use,
//               duplication or disclosure restricted by GSA ADP
//               Schedule Contract with IBM Corp.
//
//               See Copyright Instructions, G120-2083.
// ****************************************************************
//
// notice:       OCO Source Materials
//
//               This module contains IBM Confidential code.
// ****************************************************************

/*******************************************************************************

*******************************************************************************/

package COM.ibm.ivj.javabeans;
import java.awt.*;
import java.beans.*;
import java.util.*;

public class IList extends List implements java.io.Serializable, IVectorListener {

  private static String copywrite = "IBM(R) VisualAge(TM) for Java(TM), Version 1 and others\n - Licensed Material - Program-Property of IBM\n(C) Copyright IBM Corp. 1997 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

  public IList () {}

  public IList (int i) {
    super (i);
  }

  public IList (int i, boolean l) {
    super (i, l);
  }

  public IList (IVector v) {
    setElements (v);
  }


  // when setting the IVector attribute, we will create
  // a listener that observes any changes to the IVecotr
  public synchronized void setElements (IVector v) {

    if (myVector != v) {
      if (myVector != null) {
        // remove previous listener
        myVector.removeIVectorListener (this);
      }
      // create a new listener
      myVector = v;
      myVector.addIVectorListener (this);
    }

    removeAll();
    for (Enumeration e=v.elements(); e.hasMoreElements();) {
      addItem (e.nextElement().toString());
    }
  }

  public IVector getElements () {
    return myVector;
  }

  public Object getSelectedElement () {
    int index= getSelectedIndex ();
    return myVector.elementAt (index);
  }

  public IVector getSelectedElements () {
    int index [] = getSelectedIndexes ();
    Object objs [] = new Object [index.length];
    int i, j;

    for (i=0,j=index[0]; i<index.length; i++,j++) {
      objs[i] = myVector.elementAt (j);
    }

    return ( new IVector (objs) );
  }

  // Listeners

  // a specific vector element is changed
  public void vectorElementChanged (IVectorEvent ev) {
    IVector v =  (IVector) ev.getSource ();
    int i = ev.getIndex ();

    replaceItem (v.elementAt(i).toString(), i);
  }

  // one or more vector elements are removed
  public void vectorElementRemoved (IVectorEvent ev) {

    IVector v =  (IVector) ev.getSource ();
    int i = ev.getIndex ();

    if (i >= 0) {
      // only one vector element is deleted
      delItem (i);
    } else { // refresh the whole list
      removeAll ();
      for (Enumeration e=v.elements(); e.hasMoreElements();)
        addItem (e.nextElement().toString());
    }
  }

  // one or more vector elements are added
  public void vectorElementAdded (IVectorEvent ev) {

    IVector v =  (IVector) ev.getSource ();
    int i = ev.getIndex ();

    if (i >= 0) {
      // only one vector element is added
      addItem (v.elementAt(i).toString(), i);
    } else { // refresh the whole list
      removeAll ();
      for (Enumeration e=v.elements(); e.hasMoreElements();)
        addItem (e.nextElement().toString());
    }
  }

  // one or more vector elements are added
  public void vectorModified(IVectorEvent ev) {

    IVector v =  (IVector) ev.getSource ();

    removeAll();
    for (Enumeration e=v.elements(); e.hasMoreElements();)
      addItem (e.nextElement().toString());
  }

  private IVector myVector = null;
}



