/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.terminal;

import com.ibm.ivj.eab.record.terminal.IDelimitedTerminalType;
import com.ibm.ivj.eab.record.terminal.ITerminalFieldType;
import com.ibm.ivj.eab.record.terminal.TerminalRecordConverterManager;
import com.ibm.record.AnyType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.TypeData;
import com.ibm.record.VariableLengthType;

public class VariableLengthTerminalFieldType
extends VariableLengthType
implements ITerminalFieldType,
IDelimitedTerminalType {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Class preferredType;
    private boolean doubleByteEncoded;
    private String trueString;
    private String falseString;
    private int mantissaLength;
    private byte delimiterByte;
    static Class class$java$lang$Long;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Character;
    static Class class$java$lang$String;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Double;
    static Class class$java$lang$Float;

    public VariableLengthTerminalFieldType() {
        this(false, 44);
    }

    public VariableLengthTerminalFieldType(Class preferredType, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, byte delimiterByte) {
        this.preferredType = preferredType;
        this.doubleByteEncoded = doubleByteEncoded;
        this.trueString = trueString;
        this.falseString = falseString;
        this.mantissaLength = mantissaLength;
        this.delimiterByte = delimiterByte;
    }

    public VariableLengthTerminalFieldType(boolean doubleByteEncoded, byte delimiterByte) {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, doubleByteEncoded, "", "", 2, delimiterByte);
    }

    public boolean canConvertFromBoolean() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromDouble() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBoolean() {
        return true;
    }

    public boolean canConvertToByte() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] byteArray, Object constantValue) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return VariableLengthTerminalFieldType.testConstantValue(record, byteArray, constantValue, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength());
    }

    public static byte[] fromBoolean(IRecord record, boolean value, boolean doubleByteEncoded, String trueString, String falseString) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertBooleanToString(value, trueString, falseString);
        return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
    }

    public static byte[] fromByte(IRecord record, byte value, boolean doubleByteEncoded) {
        String stringValue = TerminalRecordConverterManager.convertByteToString(value);
        try {
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        catch (RecordConversionFailureException recordConversionFailureException) {
            throw new InternalError();
        }
    }

    public static byte[] fromChar(IRecord record, char value, boolean doubleByteEncoded) {
        String stringValue = TerminalRecordConverterManager.convertCharToString(value);
        try {
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        catch (RecordConversionFailureException recordConversionFailureException) {
            throw new InternalError();
        }
    }

    public static byte[] fromDouble(IRecord record, double value, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertDoubleToString(value, mantissaLength);
        return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
    }

    public static byte[] fromFloat(IRecord record, float value, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = TerminalRecordConverterManager.convertFloatToString(value, mantissaLength);
        return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            return VariableLengthTerminalFieldType.fromObject(record, initialValue, doubleByteEncoded, trueString, falseString, mantissaLength, initialValue.getClass());
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionUnsupportedException();
        }
    }

    public static byte[] fromInt(IRecord record, int value, boolean doubleByteEncoded) {
        String stringValue = TerminalRecordConverterManager.convertIntToString(value);
        try {
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        catch (RecordConversionFailureException recordConversionFailureException) {
            throw new InternalError();
        }
    }

    public static byte[] fromLong(IRecord record, long value, boolean doubleByteEncoded) {
        String stringValue = TerminalRecordConverterManager.convertLongToString(value);
        try {
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        catch (RecordConversionFailureException recordConversionFailureException) {
            throw new InternalError();
        }
    }

    public static byte[] fromObject(IRecord record, Object value, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, Class valueClass) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (value == null || value.getClass() != valueClass) {
            throw new RecordConversionUnsupportedException();
        }
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz) {
            String stringValue = (String)value;
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        Class<?> clazz2 = class$java$lang$Long;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$Long = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz2) {
            long longValue = (Long)value;
            return VariableLengthTerminalFieldType.fromLong(record, longValue, doubleByteEncoded);
        }
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz3) {
            int intValue = (Integer)value;
            return VariableLengthTerminalFieldType.fromInt(record, intValue, doubleByteEncoded);
        }
        Class<?> clazz4 = class$java$lang$Short;
        if (clazz4 == null) {
            try {
                clazz4 = class$java$lang$Short = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz4) {
            short shortValue = (Short)value;
            return VariableLengthTerminalFieldType.fromShort(record, shortValue, doubleByteEncoded);
        }
        Class<?> clazz5 = class$java$lang$Byte;
        if (clazz5 == null) {
            try {
                clazz5 = class$java$lang$Byte = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz5) {
            byte byteValue = (Byte)value;
            return VariableLengthTerminalFieldType.fromByte(record, byteValue, doubleByteEncoded);
        }
        Class<?> clazz6 = class$java$lang$Character;
        if (clazz6 == null) {
            try {
                clazz6 = class$java$lang$Character = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz6) {
            char charValue = ((Character)value).charValue();
            return VariableLengthTerminalFieldType.fromChar(record, charValue, doubleByteEncoded);
        }
        Class<?> clazz7 = class$java$lang$Boolean;
        if (clazz7 == null) {
            try {
                clazz7 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz7) {
            boolean booleanValue = (Boolean)value;
            return VariableLengthTerminalFieldType.fromBoolean(record, booleanValue, doubleByteEncoded, trueString, falseString);
        }
        Class<?> clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            try {
                clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz8) {
            double doubleValue = (Double)value;
            return VariableLengthTerminalFieldType.fromDouble(record, doubleValue, doubleByteEncoded, mantissaLength);
        }
        Class<?> clazz9 = class$java$lang$Float;
        if (clazz9 == null) {
            try {
                clazz9 = class$java$lang$Float = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz9) {
            float floatValue = ((Float)value).floatValue();
            return VariableLengthTerminalFieldType.fromFloat(record, floatValue, doubleByteEncoded, mantissaLength);
        }
        throw new RecordConversionUnsupportedException();
    }

    public static byte[] fromShort(IRecord record, short value, boolean doubleByteEncoded) {
        String stringValue = TerminalRecordConverterManager.convertShortToString(value);
        try {
            return VariableLengthTerminalFieldType.fromString(record, stringValue, doubleByteEncoded);
        }
        catch (RecordConversionFailureException recordConversionFailureException) {
            throw new InternalError();
        }
    }

    public static byte[] fromString(IRecord record, String value, boolean doubleByteEncoded) throws RecordConversionFailureException {
        try {
            byte[] valueBytes = TerminalRecordConverterManager.convertStringToByteArray(value, doubleByteEncoded);
            return valueBytes;
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionFailureException();
        }
    }

    public int getAlignmentHint() {
        return 1;
    }

    public boolean getBoolean(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toBoolean(record, byteArray, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString());
    }

    public byte getByte(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toByte(record, byteArray, this.getDoubleByteEncoded());
    }

    public char getChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toChar(record, byteArray, this.getDoubleByteEncoded());
    }

    public byte getDelimiterByte() {
        return this.delimiterByte;
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toDouble(record, byteArray, this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public boolean getDoubleByteEncoded() {
        return this.doubleByteEncoded;
    }

    public String getFalseString() {
        return this.falseString;
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toFloat(record, byteArray, this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toInt(record, byteArray, this.getDoubleByteEncoded());
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toLong(record, byteArray, this.getDoubleByteEncoded());
    }

    public int getMantissaLength() {
        return this.mantissaLength;
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toObject(record, byteArray, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength(), this.getPreferredType());
    }

    public Class getPreferredType() {
        return this.preferredType;
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toShort(record, byteArray, this.getDoubleByteEncoded());
    }

    public int getSize() {
        return -1;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.toString(record, byteArray, this.getDoubleByteEncoded());
    }

    public String getTrueString() {
        return this.trueString;
    }

    public byte[] packageBytes(IRecord record, byte[] byteArray) {
        byte[] result = new byte[byteArray.length + 1];
        System.arraycopy(byteArray, 0, result, 0, byteArray.length);
        result[byteArray.length] = this.getDelimiterByte();
        return result;
    }

    public TypeData retrieveBytes(IRecord record, byte[] byteArray, int offset) {
        int delimiterOffset = offset;
        while (delimiterOffset < byteArray.length && byteArray[delimiterOffset] != this.getDelimiterByte()) {
            ++delimiterOffset;
        }
        boolean isDelimited = delimiterOffset < byteArray.length;
        int length = delimiterOffset - offset;
        byte[] bytes = new byte[length];
        System.arraycopy(byteArray, offset, bytes, 0, length);
        return new TypeData(bytes, isDelimited ? length + 1 : length);
    }

    public byte[] setBoolean(IRecord record, boolean value) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromBoolean(record, value, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString());
    }

    public byte[] setByte(IRecord record, byte value) {
        return VariableLengthTerminalFieldType.fromByte(record, value, this.getDoubleByteEncoded());
    }

    public byte[] setChar(IRecord record, char value) {
        return VariableLengthTerminalFieldType.fromChar(record, value, this.getDoubleByteEncoded());
    }

    public void setDelimiterByte(byte delimiterByte) {
        this.delimiterByte = delimiterByte;
    }

    public byte[] setDouble(IRecord record, double value) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromDouble(record, value, this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public void setDoubleByteEncoded(boolean doubleByteEncoded) {
        this.doubleByteEncoded = doubleByteEncoded;
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }

    public byte[] setFloat(IRecord record, float value) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromFloat(record, value, this.getDoubleByteEncoded(), this.getMantissaLength());
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromInitialValue(record, initialValue, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength());
    }

    public byte[] setInt(IRecord record, int value) {
        return VariableLengthTerminalFieldType.fromInt(record, value, this.getDoubleByteEncoded());
    }

    public byte[] setLong(IRecord record, long value) {
        return VariableLengthTerminalFieldType.fromLong(record, value, this.getDoubleByteEncoded());
    }

    public void setMantissaLength(int mantissaLength) {
        this.mantissaLength = mantissaLength;
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromObject(record, value, this.getDoubleByteEncoded(), this.getTrueString(), this.getFalseString(), this.getMantissaLength(), this.getPreferredType());
    }

    public void setPreferredType(Class preferredType) {
        Class oldValue = this.preferredType;
        this.preferredType = preferredType;
        if (((AnyType)this).changes_ != null) {
            ((AnyType)this).changes_.firePropertyChange("preferredType", oldValue, preferredType);
        }
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        if (this.canConvertFromShort()) {
            return VariableLengthTerminalFieldType.fromShort(record, value, this.getDoubleByteEncoded());
        }
        throw new RecordConversionUnsupportedException();
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException {
        return VariableLengthTerminalFieldType.fromString(record, value, this.getDoubleByteEncoded());
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }

    public static boolean testConstantValue(IRecord record, byte[] bytes, Object constantValue, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            Object value = VariableLengthTerminalFieldType.toObject(record, bytes, doubleByteEncoded, trueString, falseString, mantissaLength, constantValue.getClass());
            return value.equals(constantValue);
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionFailureException();
        }
    }

    public static boolean toBoolean(IRecord record, byte[] bytes, boolean doubleByteEncoded, String trueString, String falseString) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToBoolean(stringValue, trueString, falseString);
    }

    public static byte toByte(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToByte(stringValue);
    }

    public static char toChar(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToChar(stringValue);
    }

    public static double toDouble(IRecord record, byte[] bytes, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToDouble(stringValue, mantissaLength);
    }

    public static float toFloat(IRecord record, byte[] bytes, boolean doubleByteEncoded, int mantissaLength) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToFloat(stringValue, mantissaLength);
    }

    public static int toInt(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToInt(stringValue);
    }

    public static long toLong(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToLong(stringValue);
    }

    public static Object toObject(IRecord record, byte[] bytes, boolean doubleByteEncoded, String trueString, String falseString, int mantissaLength, Class valueClass) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            try {
                clazz = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz) {
            String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
            return stringValue;
        }
        Class<?> clazz2 = class$java$lang$Long;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$Long = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz2) {
            long longValue = VariableLengthTerminalFieldType.toLong(record, bytes, doubleByteEncoded);
            return new Long(longValue);
        }
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz3) {
            int intValue = VariableLengthTerminalFieldType.toInt(record, bytes, doubleByteEncoded);
            return new Integer(intValue);
        }
        Class<?> clazz4 = class$java$lang$Short;
        if (clazz4 == null) {
            try {
                clazz4 = class$java$lang$Short = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz4) {
            short shortValue = VariableLengthTerminalFieldType.toShort(record, bytes, doubleByteEncoded);
            return new Short(shortValue);
        }
        Class<?> clazz5 = class$java$lang$Byte;
        if (clazz5 == null) {
            try {
                clazz5 = class$java$lang$Byte = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz5) {
            byte byteValue = VariableLengthTerminalFieldType.toByte(record, bytes, doubleByteEncoded);
            return new Byte(byteValue);
        }
        Class<?> clazz6 = class$java$lang$Character;
        if (clazz6 == null) {
            try {
                clazz6 = class$java$lang$Character = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz6) {
            char charValue = VariableLengthTerminalFieldType.toChar(record, bytes, doubleByteEncoded);
            return new Character(charValue);
        }
        Class<?> clazz7 = class$java$lang$Boolean;
        if (clazz7 == null) {
            try {
                clazz7 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz7) {
            boolean booleanValue = VariableLengthTerminalFieldType.toBoolean(record, bytes, doubleByteEncoded, trueString, falseString);
            return new Boolean(booleanValue);
        }
        Class<?> clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            try {
                clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz8) {
            double doubleValue = VariableLengthTerminalFieldType.toDouble(record, bytes, doubleByteEncoded, mantissaLength);
            return new Double(doubleValue);
        }
        Class<?> clazz9 = class$java$lang$Float;
        if (clazz9 == null) {
            try {
                clazz9 = class$java$lang$Float = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (valueClass == clazz9) {
            float floatValue = VariableLengthTerminalFieldType.toFloat(record, bytes, doubleByteEncoded, mantissaLength);
            return new Float(floatValue);
        }
        throw new RecordConversionUnsupportedException();
    }

    public static short toShort(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        String stringValue = VariableLengthTerminalFieldType.toString(record, bytes, doubleByteEncoded);
        return TerminalRecordConverterManager.convertStringToShort(stringValue);
    }

    public static String toString(IRecord record, byte[] bytes, boolean doubleByteEncoded) throws RecordConversionFailureException {
        try {
            return TerminalRecordConverterManager.convertByteArrayToString(bytes, doubleByteEncoded);
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionFailureException();
        }
    }
}

