!EpImage privateMethods !

copyMethod: method compact: compact

 "Answer a copy of method, which shares the instance variables."

 | newCm literal |
 (compact and: [self createIC]) ifTrue: [
  (newCm := EpCompactMethod new)
   methodId: method methodId;
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy).
  1 to: method size do: [:i |
   ((literal := method at: i) class == BlockContextTemplate or: [
    literal class == EsCompactBlockContextTemplate])
   ifTrue: [
    translate at: literal put: (self uncompressContext: literal method:   
newCm).
   ].
  ].
 ] ifFalse: [
  (newCm := CompiledMethod new: method size)
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy);
   methodClass: method methodClass;
   selector: method selector;
   filePointer: method filePointer.
  1 to: method size do: [:i |
   ((literal := method at: i) class == BlockContextTemplate or: [
    literal class == EsCompactBlockContextTemplate])
   ifTrue: [
    literal := translate at: literal put: (self uncompressContext:   
literal method: newCm).
   ].
   newCm at: i put: literal].
  ].
 ^newCm!

replaceSelectorIn: replacement with: selector

 ^(replacement class == EsCompactMethod
  ifTrue: [uncompressedMethods at: replacement methodId put: (self   
copyMethod: replacement compact: false)]
  ifFalse: [replacement copy]) selector: selector! !