EpROMer becomeDefault!

!EsDumper privateMethods !

addCompiledMethod: compiledMethod in: determinedSpace
  "Add the compiledMethod to aSpace."

 (compiledMethods includes: compiledMethod) ifTrue: [^self].
 (self translate: compiledMethod in: determinedSpace) ifTrue: [^self].

 "Add the object to instanceSpace."
 compiledMethods add: compiledMethod.
 compiledMethod PackagerAddFieldsTo: self in: determinedSpace.

 image progressStep: 1.!

compactMethods: classCounts

 | cmCount bcCount space firstIndex index target cm nextCm offset sizes   
size newCodes address |

 cmCount := classCounts at: CompiledMethod ifAbsentPut: [
  (Array new: 4) atAllPut: 0].
 bcCount := classCounts at: EsByteCodeArray ifAbsentPut: [
  (Array new: 4) atAllPut: 0].
 space := image spaceNamed: 'CODE'.  "$NON-NLS$"
 space currentAddress: space currentAddress + 1.

 index := 1.
 [index <= compiledMethods size] whileTrue: [
  firstIndex := index.
  cm := compiledMethods at: index.
  target := self convertBC: (EsByteCodeArray
   compressBytecodeArray: cm bytecodes copy meta: cm methodClass   
isMetaclass
   bigEndian: System bigEndian).
  offset := 8 + (cm size - (cm hasFilePointer ifTrue: [1] ifFalse: [0]) *   
4).
  (sizes := OrderedCollection new) add: offset.
  [
   "Break at 64K - 1 boundaries."
   ((index + 1 \\ 16rFFFF) ~= 1 and: [index < compiledMethods size])   
ifTrue: [
    nextCm := compiledMethods at: index + 1.
    newCodes := self convertBC: (EsByteCodeArray
     compressBytecodeArray: nextCm bytecodes copy meta: nextCm   
methodClass isMetaclass
     bigEndian: System bigEndian).
    size := 8 + (nextCm size - (nextCm hasFilePointer ifTrue: [1]   
ifFalse: [0]) * 4).
    (target epByteCodeEquals: newCodes) and: [offset + size <= 65536]]
   ifFalse: [false]]
  whileTrue: [
   sizes last = size ifFalse: [self error: (NlsCatEPa indexedMsg: 19)].   
 "$NLS$ Shared bytecodes with different literals size"
   sizes add: size.
   offset := offset + size.
   index := index + 1.
  ].
  firstIndex to: index - 1 do: [:i |
   size := sizes removeFirst.
   nextCm := compiledMethods at: i.
   (address := space add: nextCm ofSize: size) isNil ifTrue: [self error:   
space errorString].
   objects at: nextCm put: address.
   cmCount at: 2 put: (cmCount at: 2) + size.
   (space add: offset - 1 ofSize: 0) isNil ifTrue: [self error: space   
errorString].
   offset := offset - size.
   nextCm do: [:lit |
    | template |
    lit epIsBCT ifTrue: [
     template := translate keyIfAbsentAt: lit.
     (lit == template and: [template isReadOnly]) ifTrue: [self error:   
(NlsCatEPa indexedMsg: 20)].  "$NLS$ Attempt to modify running image"
     template markReadOnly: false.
     template startPC: template climStartPC + (offset // 2).
     template markReadOnly: true]].
  ].
  (address := space add: (compiledMethods at: index) ofSize: (size :=   
sizes removeFirst)) isNil ifTrue: [
   self error: space errorString].
  objects at: (compiledMethods at: index) put: address.
  cmCount at: 1 put: (cmCount at: 1) + index - firstIndex + 1.
  cmCount at: 2 put: (cmCount at: 2) + size.
  (space add: target ofSize: (size := target size + (4 - (target size \\   
4) \\ 4))) isNil ifTrue: [
   self error: space errorString].
  bcCount at: 1 put: (bcCount at: 1) + 1.
  bcCount at: 2 put: (bcCount at: 2) + size.
  index := index + 1.
 ].

 space currentAddress: space currentAddress - 1.!

fixMappings
  "Fix up the symbol table. This structure changes depending on
   what classes and symbols are written in the new image."

 | sharedLibs atomTable cmInfo newPointers |

 image localSteps: 4.

 image logMessage: '  Fix shared libraries' bench: [  "$NON-NLS$"
  sharedLibs := PlatformLibrary classPool at: 'SharedLibraries'.   
 "$NON-NLS$"
  (translate at: sharedLibs) == nil ifTrue: [
   translateSpaces at: sharedLibs ifPresent: [:aSpace |
    | newLibs aliases newAliases |
    newLibs := Set new: sharedLibs size.
    aliases := PlatformLibrary classPool at: 'Aliases'.  "$NON-NLS$"
    newAliases :=  aliases class new.
    objects keysDo: [:object |
     object epIsPlatformFunction ifTrue: [
      newLibs add: object library]]. "Assumes adding nil has no effect."
    (sharedLibraryMap := Dictionary new: newLibs size + 1)
     at: 0 put: 0.
    (newLibs := newLibs asArray) do: [:lib |
     aliases at: lib logicalName ifPresent: [:physicalName |
      newAliases at: lib logicalName put: physicalName].
     sharedLibraryMap at: (PlatformLibrary libraryIndex: lib name) put:
      (newLibs findFirst: [:newLib | newLib name = lib name])].
    newLibs := (Array new: (newLibs size > 64 ifTrue: [sharedLibs size]   
ifFalse: [64]))
     replaceFrom: 1 to: newLibs size with: newLibs startingAt: 1.
    (translate at: aliases) == nil ifTrue: [
     translateSpaces at: aliases ifPresent: [:aliasSpace |
      translate at: aliases put: newAliases.
      self addObject: newAliases in: aliasSpace]].
    translate at: sharedLibs put: newLibs.
    self addObject: newLibs in: aSpace.
    self dumpQ]].
 ].
 image progressStep: 1.

 image logMessage: '  Fix atom table' bench: [  "$NON-NLS$"
  atomTable := EsAtom atomTable.
  (translate at: atomTable) == nil ifTrue: [
   translateSpaces at: atomTable ifPresent: [:aSpace |
    | newAtomTable |
    newAtomTable := self atomTableClass new.
    objects keysAndValuesDo: [:object :space |
     | atomString |
     (object class == EsAtom and: [space epIsOutputDesignation]) ifTrue:   
[
      newAtomTable add: object]].
    (self class isComponentImageDumper and: [self class   
isSingleDependentComponent])
     ifTrue: [newAtomTable := newAtomTable asArray].
    newAtomTable notEmpty ifTrue: [
     translate at: atomTable put: newAtomTable.
     self addObject: newAtomTable in: aSpace.
     self dumpQ]]].
 ].
 image progressStep: 1.

 "Ensure that the startup process will be dumped,
  even if instances of Process are excluded."
 registry size >= 6 ifTrue: [
  self addIncludedObject: (registry at: 6) in: EpImage.
  self dumpQ].

 image compressCode ifTrue: [
  image logMessage: '  Compress code' bench: [  "$NON-NLS$"
   compiledMethods := compiledMethods asSortedCollection: [:a :b | a   
epByteCodeLessThan: b].
   (image includesSpaceNamed: 'CMINFO') ifTrue: [  "$NON-NLS$"
    cmInfo := OrderedCollection new: compiledMethods size +   
(compiledMethods size - 1 quo: 16rFFFF) * 2].
   (image includesSpaceNamed: 'FILEPOINTERS') ifTrue: [  "$NON-NLS$"
    newPointers := OrderedCollection new: compiledMethods size +   
(compiledMethods size - 1 quo: 16rFFFF)].
   (cmInfo notNil or: [newPointers notNil]) ifTrue: [
    compiledMethods doWithIndex: [:cm :index |
     cmInfo notNil ifTrue: [
      (index - 1 \\ 16rFFFF = 0 and: [index > 1]) ifTrue: [cmInfo add:   
nil; add: nil].
      cmInfo add: cm methodClass; add: cm selector].
     cm compiledCorrectly ifFalse: [
      self error: (NlsCatEPe indexedMsg: 54)].  "$NLS$ Cannot package   
incorrectly compiled method"
     newPointers notNil ifTrue: [
      (index - 1 \\ 16rFFFF = 0 and: [index > 1]) ifTrue: [newPointers   
add: nil].
      newPointers add: (cm isPrivate ifTrue: [1] ifFalse: [0])].
    ].
   ].
   cmInfo size > 0 ifTrue: [self addObject: cmInfo asArray in: (image   
spaceNamed: 'CMINFO')].  "$NON-NLS$"
   newPointers size > 0 ifTrue: [self addObject: newPointers asArray in:   
(image spaceNamed: 'FILEPOINTERS')].  "$NON-NLS$"
   self dumpQ.
  ].
 ].

 image logMessage: '  Process associations' bench: [  "$NON-NLS$"
  self processAssociations.
 ].
 image progressStep: 1.

 "Mapping for the symbol table."
 image logMessage: '  Fix symbol table' bench: [  "$NON-NLS$"
  (translate at: Symbol symbolTable) isNil ifTrue: [
   translateSpaces at: Symbol symbolTable ifPresent: [:aSpace |
    | symbolTable |
    symbolTable := self symbolTableClass new.
    objects keysAndValuesDo: [:object :space |
     (object class == Symbol and: [space epIsOutputDesignation]) ifTrue:   
[
      symbolTable add: object].
    ].
    symbolTable class == EsLargeSymbolSet ifTrue: [
     symbolTable extendedBin: EsSymbolSet new].
    symbolTable notEmpty ifTrue: [
     translate at: Symbol symbolTable put: symbolTable.
     self addObject: symbolTable in: aSpace].
    self dumpQ]].
 ].
 image progressStep: 1.

 (image snapshotID notNil and: [image class ~~ EpImage]) ifTrue: [
  self addObject: image snapshotID in: (image spaceNamed: 'SNAPSHOT').   
 "$NON-NLS$"
 ].
! !

!EsRomerImageDumper publicMethods !

dump
  "Dump the objects to create a new image."

 | classCounts spaces classTable |

 image componentMap notNil ifTrue: [
  classTable := self gatherExternalObjects.
 ].

 classCounts := self assignAddresses.
 image compressCode ifTrue: [
  self compactMethods: classCounts].

 spaces := OrderedCollection new.
 image memorySpaces do: [:aSpace | aSpace addSpacesTo: spaces].

 spaces := self breakupSpaces: spaces.

 (image componentMap isNil or: [image romStart notNil]) ifTrue: [
  self assignRomAddresses: spaces].

 image componentMap notNil ifTrue: [
  classTable isNil ifTrue: [
   image componentMap assignClassAddressesDo: [:cl | objects at: cl].
  ] ifFalse: [
   classTable notEmpty ifTrue: [
    classTable := (objects at: classTable) + self objectHeaderSize.
    image componentMap assignClassAddressesDo: [:cl |
     (image componentMap classIndexies at: cl symbol) - 1 * 2 +
      (cl isClass ifTrue: [0] ifFalse: [1]) * 4 + classTable]].
  ].
  image componentMap assignAddressesDo: [:object | objects at: object]].

 self dumpStats: classCounts forSpaces: spaces.

 aStream := image newStatsFileNamed: image imageFileName.
 aStream := EpOutputStream on: aStream fileDescriptor bufferSize: 4096.
 System bigEndian == self bigEndian ifFalse: [aStream reverseEndian:   
true].
 [
  image logMessage: 'Writing the image' bench: [  "$NON-NLS$"
   | objectCount |
   self
    dumpImageHeader: spaces size + (self methodSpaces: spaces) + self   
additionalSpacesCount;
    dumpRegistry;
    dumpSegmentHeaders: spaces.

   image epProgressLocalFraction: 21/73.
   image localSteps: objects size // 100.
   objectCount := 0.

   "Dump the spaces."
   spaces do: [ :aSpace |
    romSpace := aSpace.
    aSpace name = 'CODE' ifTrue: [  "$NON-NLS$"
     self dumpCodeSpace: aSpace.
    ] ifFalse: [
     aSpace objectsDo: [:anObject |
      (objectCount := objectCount + 1) \\ 100 = 0
       ifTrue: [image progressStep: 1].
      anObject PackagerClass isPointers
       ifTrue: [self dumpPointerObject: anObject]
       ifFalse: [self dumpByteObject: anObject]].
    ].
   ].
  ].
 ] when: ExError do: [:sig |
  aStream close.
  sig signal.
 ].
 aStream close.

 image componentMap notNil ifTrue: [
  image componentMap memoryDescriptors: (self memoryDescriptors:   
spaces)].
! !

!EsRomerImageDumper privateMethods !

dumpCodeSpace: aSpace

 | mapStream spaceId methodId |
 methodId := 1.
 spaceId := 0.
 mapStream := image newStatsFileNamed: 'map.es'.  "$NON-NLS$"
 1 to: aSpace objects size by: 2 do: [:index |
  | cm bytes cmSize |
  cm := aSpace objects at: index.
  bytes := aSpace objects at: index + 1.
  aStream nextPutLong: (((cm flags bitAnd: 16r7FF8) + (bytes isInteger   
ifTrue: [16r8000] ifFalse: [0])) bitShift: 16) + methodId.
  mapStream
   nextPutAll: (spaceId epHexPaddedTo: 2); nextPutAll: (methodId   
epHexPaddedTo: 4); tab; nextPutAll: cm printString; cr.

  cmSize := cm size - (cm hasFilePointer ifTrue: [1] ifFalse: [0]).
  bytes isInteger
   ifTrue: [aStream nextPutLong: (bytes bitShift: 16) + (cmSize * 4)]
   ifFalse: [
    bytes size > 16rFFFF ifTrue: [self error: (NlsCatEPa indexedMsg:   
21)].  "$NLS$ Maximum compact bytecode size exceeded"
    aStream nextPutLong: (bytes size bitShift: 16) + (cmSize * 4)].
  1 to: cmSize do: [:litIndex | self dumpObjectPointer: (cm at:   
litIndex)].

  bytes isInteger ifFalse: [
   aStream nextPutBytes: (self bigEndian == System bigEndian
    ifTrue: [bytes]
    ifFalse: [bytes copy epSwapWords]).
   aStream next: (4 - (bytes size \\ 4)) \\ 4 put: 0.
  ].
  (methodId := methodId + 1) = 16r10000 ifTrue: [
   methodId := 1.
   spaceId := spaceId + 1].
 ].

 mapStream close.!

dumpSegmentHeaders: spaces

 | id |
 self dumpNewSpace.

 id := self startId.
 spaces do: [:aSpace |
  | nextAddress length offset newSpace index |

  aSpace id: id.

  aSpace name = 'CODE' ifTrue: [
   length := offset := index := 0.
   nextAddress := objects at: aSpace objects first.
   "Break at 64K - 1 object boundaries."
   1 to: aSpace objects size by: 16r1FFFE do: [:i |
    | firstAddress |
    firstAddress := nextAddress.
    i + 16r1FFFE > aSpace objects size ifTrue: [
     nextAddress := aSpace currentAddress + 1.
    ] ifFalse: [
     nextAddress := objects at: (aSpace objects at: i + 16r1FFFE).
    ].
    length := nextAddress - firstAddress.
    (newSpace := aSpace copy)
     id: (index bitShift: 16) + id;
     startAddress: aSpace startAddress + offset;
     length: length;
     currentAddress: newSpace startAddress + length.
    offset := offset + length.
    self dumpSpace: newSpace.
    id := id + 1.
    index := index + 1.
   ].
  ] ifFalse: [
   self dumpSpace: aSpace.
   id := id + 1.
  ].
 ].!

methodSpaces: spaces

 spaces do: [:aSpace |
  aSpace name = 'CODE' ifTrue: [
   ^(aSpace objects size - 2 quo: 16r1FFFE)]].

 ^0! !

EsRomerImageDumper categoriesFor: #methodSpaces: are: #('EP-Internal')!