/*----------------------------------------------------------------------------
 *
 *  mainvio.c
 *  ---------
 *
 *  Purpose: Provide the startup processing for VisualAge Smalltalk Enterprise
 *           when operating in a headless environment
 *
 *  Commandline switches:
 *     -singleinstance  Disallow multiple copies of the executable running
 *                at the same time
 *
 *  Licensed Materials - Property of IBM
 *
 *  (C) Copyright International Business Machines Corp., 1999
 *  All rights reserved
 *
 *  US Government Users Restricted Rights -
 *  Use, duplication, or disclosure restricted
 *  by GSA ADP Schedule Contract with IBM Corp.
 *
 *  Modifications:
 *     5.0.1.0 24Jan00(jok) Update to 5.0.1
 *                          Update parse.c for tenureFailedGCCount option
 *
 *----------------------------------------------------------------------------*/

#define PRODUCT_NAME    "VisualAge Smalltalk Enterprise"
#define PRODUCT_VERSION "Version 5.0.1"
#define PRODUCT_STATUS  ""
#define PRODUCT_EDITION "01/24/2000"
#define PRODUCT_COPYR   "(C) Copyright International Business Machines Corporation  1994, 2000.\nAll Rights Reserved."

#include <windows.h>
#include "esuser.h"

/*--------------------------------------------------------------------------*/
/*      DEBUG support                                                       */
/*--------------------------------------------------------------------------*/

#ifdef DEBUG01
#define dbg_printf( x ) { printf x ; fflush( stdout ); }
#else
#define dbg_printf( x )
#endif

EsDefinePrimitiveTable(EsExePrimitiveTable)
EsEndPrimitiveTable 

/* function prototypes */
BOOLEAN EsParseCommandLineOptions(int argc, char *argv[], char *envp[], EsGlobalInfo * info);
void EsSetGlobalHInstance(ESGlobalInfo *ginfo, HINSTANCE hInst);

static HINSTANCE hInstanceCur;

#define MAX_ARGV 20



int main(int argc, char ** argv, char ** envp)
{
	I_32 rc;
	EsGlobalInfo *globalInfo;
	int i;
	int argc2 = 0;
	char *argv2[MAX_ARGV];
	BOOLEAN mutexEnabled = FALSE;
	void *startupMutex;
	char mutexNameBuffer[1024], *exeName, *exeExtension, *ptr;

   /*
    * On OS/2, -lcon is needed to get the TranscriptTTY output to go to stdout.
    * On Windows, it will go there by default, so drop the -lcon to maintain
    * common syntax.
    */

	for (i=0; i<MAX_ARGV; i++) argv2[i] = NULL;
	for (i=0; i<argc; i++) {
		if (stricmp( argv[i], "-lcon" ) == 0 ||	stricmp( argv[i], "/lcon" ) == 0)
            continue;
		else argv2[argc2++] = argv[i];
		}

	/* Walk the command line looking VA specific command line options */
   dbg_printf( ("Entering main, %d commandline arguements\n", argc) );
	for(i=1; i < argc; i++) {
      dbg_printf( ("\t%s\n", argv[i]) );
		if(strcmp(argv[i],"-singleinstance") == 0)
			mutexEnabled = TRUE;
		}

   dbg_printf( ("mutexEnabled: %d\n", mutexEnabled) );
	
	/* single start mutex acquisition */
	if(mutexEnabled) {
		/* strip the path name and extension from the file */
		exeName = strrchr(argv[0], '\\');
		if(exeName)
			exeName++;
		else
			exeName = argv[0];

		strcpy(mutexNameBuffer, exeName);
		for (ptr = mutexNameBuffer; *ptr; ptr++)
			*ptr = toupper(*ptr);
		exeExtension = strrchr(mutexNameBuffer, '.');
		if (exeExtension && 0 == strcmp(exeExtension, ".EXE"))
			*exeExtension = '\0';
		strcat(mutexNameBuffer, "_SINGLE_START_MUTEX");

		SetLastError(0);	/* reset the Win32 error status */
		startupMutex = CreateMutex(NULL, FALSE, mutexNameBuffer);
		if(ERROR_ALREADY_EXISTS == GetLastError()) {	/* mutex already exists */
			CloseHandle(startupMutex);
			return 0;
			}
		}

	globalInfo = EsInitializeImage();
	if (globalInfo == NULL) {
		EsReportError( EsPrimErrNotEnoughMemory, globalInfo );
		if (mutexEnabled)
			CloseHandle(startupMutex);
		return EsPrimErrNotEnoughMemory;
		}

	globalInfo->imagePrimitives = (U_32) EsExePrimitiveTable;

	/* Set the desired level of messaging */
	globalInfo->messageLevel = ESVM_MSG_LEVEL_NONE;

	EsSetGlobalHInstance(globalInfo, hInstanceCur);

	rc = EsInitializeTargetInterface(argc2, argv2, envp, globalInfo);
	if (rc != EsPrimErrNoError) {
		EsReportError(rc, globalInfo);
		EsShutdownImage(globalInfo);
		if (mutexEnabled)
			CloseHandle(startupMutex);
		return rc;
		}

	EsPrintf ("\n%s, %s %s - %s\nVM Timestamp: %s\n%s\n",
		PRODUCT_NAME,PRODUCT_VERSION,PRODUCT_STATUS,PRODUCT_EDITION,
        	EsVMVersionString(),
        	PRODUCT_COPYR,
        	0,0,0,0);

	if(!EsParseCommandLineOptions(argc2, argv2, envp, globalInfo)) {
		EsReportError(EsPrimErrImageFileOpenError, globalInfo);
		EsShutDownTargetInterface (globalInfo);
		EsShutdownImage(globalInfo);
		if (mutexEnabled)
			CloseHandle(startupMutex);
		return EsPrimErrImageFileOpenError;
		}

	rc = EsLoadFileImage(argc2, argv2, envp, globalInfo);
	if (rc != EsPrimErrNoError) {
		EsReportError( rc, globalInfo );
		EsShutDownTargetInterface (globalInfo);
		EsShutdownImage(globalInfo);
		if (mutexEnabled)
			CloseHandle(startupMutex);
		return rc;
		}

	rc = EsExecuteImage(globalInfo);
	if (rc != EsPrimErrNoError)
		EsReportError (rc, globalInfo);
	EsShutDownTargetInterface (globalInfo);
	EsShutdownImage(globalInfo);
	if (mutexEnabled)
		CloseHandle(startupMutex);
	return rc;
	}
