package com.ibm.vap.Isolation;

/**
 * ExternalLockingIsolationImplementor
 * 
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public class ExternalLockingIsolationImplementor extends ExternalNonLockingIsolationImplementor implements ExternalIsolationImplementor
{
	private static ExternalLockingIsolationImplementor singleton;
/**
 * Acquire a update (write) lock for the version
 */
public void acquireLockFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	aVersion.lockWith(this.createLockFor(aVersion));
}
/**
 * Read all instances from a home
 */
public Vector allInstancesWithLockFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primAllInstancesWithLock();
}
/**
 * Answer a new lock object
 */
public ExternalObjectLock createLockFor(Version aVersion)
{
	return new ExternalObjectLock(aVersion);
}
/**
 * Execute aQueryName from a home
 */
public Vector customQueryWithLockFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	return aHome.primCustomQueryWithLock(aQueryName, args);
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKeyWithLock(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primFindByPrimaryKeyWithLock(aKey);
}
/**
 * Aswer the singleton instance of the receiver
 */
public static ExternalIsolationImplementor getSingleton()
{
	if (singleton == null)
		singleton = new ExternalLockingIsolationImplementor();

	return singleton;
}
/**
 * Mark the versiont externally locked after a db read.
 */
public void markExternallyLocked(Version aVersion)
{
	if (aVersion.isBusinessObjectVersion())
		if (!aVersion.hasExternalLock())
			aVersion.setExternalLock(this.createLockFor(aVersion));
}
/**
 * Promote the locks from the child transaction to the parent transaction
 */
public void promoteLock(Version aChildVersion, Version aParentVersion)
{
	if (aChildVersion.isBusinessObjectVersion())
		aChildVersion.promoteExternalLockTo(aParentVersion);
}
/**
 * Release the version's lock
 */
public void releaseLockFor(Version aVersion)
{
	if (aVersion.isBusinessObjectVersion())
		if (aVersion.getTransaction().isChild())
			aVersion.promoteExternalLockTo(aVersion.getParentVersion());
		else
			aVersion.releaseExternalLock();
}
/**
 * Transfer the ownership of a lock to a new version when converting
 * from a read only version to an updatable version
 */
public void transferLock(Version anOldVersion, Version aNewVersion)
{
	if (anOldVersion.isBusinessObjectVersion())
		anOldVersion.transferExternalLockTo(aNewVersion);
}
}