package com.ibm.vap.Isolation;


/**
 * ExternalNonLockingIsolationImplementor
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public class ExternalNonLockingIsolationImplementor extends AbstractIsolationImplementor implements ExternalIsolationImplementor
{
	private static ExternalNonLockingIsolationImplementor singleton;
/**
 * Read all instances from a home
 */
public Vector allInstancesWithLockFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primAllInstances();
}
/**
 * Execute aQueryName from a home
 */
public Vector customQueryWithLockFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	return aHome.primCustomQuery(aQueryName, args);
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKeyWithLock(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primFindByPrimaryKey(aKey);
}
/**
 * Aswer the singleton instance of the receiver
 */
public static ExternalIsolationImplementor getSingleton()
{
	if (singleton == null)
		singleton = new ExternalNonLockingIsolationImplementor();

	return singleton;
}
/**
 * Mark the versiont externally locked after a db read.
 */
public void markExternallyLocked(Version aVersion)
{
}
}