package com.ibm.vap.Isolation;

/**
 * ObjectIsolationImplementor
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.util.Vector; 
import java.rmi.RemoteException;
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public class ObjectIsolationImplementor extends java.lang.Object
{
	protected InternalIsolationImplementor internalIsolationImplementor = null;
	protected ExternalIsolationImplementor externalIsolationImplementor = null;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * ObjectIsolationImplementor constructor
 */
public ObjectIsolationImplementor(InternalIsolationImplementor anInternalImplementor, ExternalIsolationImplementor anExternalImplementor)
{
	this.setInternalIsolationImplementor(anInternalImplementor);
	this.setExternalIsolationImplementor(anExternalImplementor);
}
/**
 * Acquire a update (write) lock for the version
 */
public void acquireLockFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	this.getInternalIsolationImplementor().acquireLockFor(aVersion);
	this.getExternalIsolationImplementor().acquireLockFor(aVersion);
}
/**
 * Read all instances from a home
 */
public Vector allInstancesWithLockFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return this.getExternalIsolationImplementor().allInstancesWithLockFrom(aHome) ;
}
/**
 * Answer a new instance of a isolation implementor
 * that is capable of locking objects
 */
public static ObjectIsolationImplementor createLockingImplementor()
{
	return new ObjectIsolationImplementor(
		InternalLockingIsolationImplementor.getSingleton(),
		ExternalLockingIsolationImplementor.getSingleton());
}
/**
 * Answer a new instance of a isolation implementor
 * that does not lock objects
 */
public static ObjectIsolationImplementor createNonLockingImplementor()
{
	return new ObjectIsolationImplementor(
		InternalNonLockingIsolationImplementor.getSingleton(),
		ExternalNonLockingIsolationImplementor.getSingleton());
}
/**
 * Execute aQueryName from a home
 */
public Vector customQueryWithLockFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	return this.getExternalIsolationImplementor().customQueryWithLockFrom(aHome, aQueryName, args) ;
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKeyWithLock(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return this.getExternalIsolationImplementor().findByPrimaryKeyWithLock(aKey,aHome) ;
}
/**
 * Answer the external isolation implementor
 */
public ExternalIsolationImplementor getExternalIsolationImplementor()
{
	if (externalIsolationImplementor == null)
		externalIsolationImplementor = new ExternalNonLockingIsolationImplementor();

	return externalIsolationImplementor;
}
/**
 * Answer the internal isolation implementor
 */
public InternalIsolationImplementor getInternalIsolationImplementor()
{
	if (internalIsolationImplementor == null)
		internalIsolationImplementor = new InternalNonLockingIsolationImplementor();

	return internalIsolationImplementor;
}
/**
 * Acquire a update (write) lock for the version
 */
public void notifyRegistrationFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	this.getInternalIsolationImplementor().acquireLockFor(aVersion);
	this.getExternalIsolationImplementor().markExternallyLocked(aVersion);
}
/**
 * Promote the locks from the child transaction to the parent transaction
 */
public void promoteLock(Version aChildVersion, Version aParentVersion)
{
	this.getInternalIsolationImplementor().promoteLock(aChildVersion,aParentVersion);
	this.getExternalIsolationImplementor().promoteLock(aChildVersion,aParentVersion);
}
/**
 * Release the version's locks
 */
public void releaseLockFor(Version aVersion)
{
	this.getInternalIsolationImplementor().releaseLockFor(aVersion);
	this.getExternalIsolationImplementor().releaseLockFor(aVersion);
}
/**
 * Set the external isolation implementor
 */
public void setExternalIsolationImplementor(ExternalIsolationImplementor anImplementor)
{
	externalIsolationImplementor = anImplementor;
}
/**
 * Set the internal isolation implementor
 */
public void setInternalIsolationImplementor(InternalIsolationImplementor anImplementor)
{
	internalIsolationImplementor = anImplementor;
}
/**
 * Transfer the ownership of a lock to a new version when converting
 * from a read only version to an updatable version
 */
public void transferLock(Version anOldVersion, Version aNewVersion)
{
	this.getInternalIsolationImplementor().transferLock(anOldVersion,aNewVersion);
	this.getExternalIsolationImplementor().transferLock(anOldVersion,aNewVersion);;
}
}