package com.ibm.vap.Isolation;


/**
 * TransactionPessimisticLockingPolicy
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public class TransactionPessimisticLockingPolicy extends TransactionPassiveLockingPolicy implements TransactionLockingPolicy
{
	protected static TransactionPessimisticLockingPolicy singleton;
/**
 * Read all instances from a home
 */
public Vector allInstancesFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	Transaction transaction;

	transaction = Transaction.getCurrent();

	if (transaction.isShared() || transaction.isReadOnly())
		return aHome.primAllInstances();
	else
		return aHome.allInstancesWithLock();
}
/**
 * Execute aQueryName from a home
 */
public Vector customQueryFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	Transaction transaction;

	transaction = Transaction.getCurrent();

	if (transaction.isShared() || transaction.isReadOnly())
		return aHome.primCustomQuery(aQueryName, args);
	else
		return aHome.customQueryWithLock(aQueryName, args);
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKey(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	Transaction transaction;

	transaction = Transaction.getCurrent();

	if (transaction.isShared() || transaction.isReadOnly())
		return aHome.primFindByPrimaryKey(aKey);
	else
		return (VapEJBObject)aHome.findByPrimaryKeyWithLock(aKey);
}
/**
 * Aswer the singleton instance of the receiver
 */
public static TransactionLockingPolicy getSingleton()
{
	if (singleton == null)
		singleton = new TransactionPessimisticLockingPolicy();

	return (TransactionLockingPolicy)singleton;
}
/**
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeVersion(Version aChildVersion, Version aParentVersion) throws RemoteException
{
	aChildVersion.initializeForRepeatableReadFrom(aParentVersion);
}
/**
 * The version is accessed first time
 */
public void notifyFirstAccessFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	Transaction transaction;

	transaction = Transaction.getCurrent();

	if (!(transaction.isShared() || transaction.isReadOnly()))
		aVersion.acquireLock();
}
/**
 * The version is registered into a view
 */
public void notifyRegistrationFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	Transaction transaction;

	transaction = Transaction.getCurrent();

	if (!(transaction.isShared() || transaction.isReadOnly()))
		aVersion.notifyRegistration();
}
/**
 * Answer true if the policy supports repeatable reads
 */
public boolean supportsRepeatableReads()
{
	return true;
}
}