package com.ibm.vap.Persistence;

/**
 * BOInjector
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */
import java.util.*;
import com.ibm.vap.Transactions.*;
public abstract class BOInjector {
	private Object sourceObject;
	private Vector queryCollection = new Vector();
	private DataStore dataStore;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/* 
 *
 */
	public BOInjector()
	{
		return;
	}	
/* 
 *
 */
	public BOInjector(Object aSource)
	{
		setSource(aSource);
	}	
/* 
 * An accessor for dataStore
 */
	public String convert(Object anObject)
	{
		return anObject.toString();
	}	
/* 
 * Convert a collection of objects into strings
 */
public Vector convertAll(Object[] values){
	int max = values.length - 1;
	Object anObject;
	Vector newVector = new Vector();
	for (int i = 0; i <= max; i++) {
		newVector.addElement((Object)convert(values[i]));
	}
	return newVector;
}	
/* 
 * Convert a collection of objects into strings
 */
public Vector convertAll(Enumeration enum){
	Object anObject;
	Vector newVector = new Vector();
	while (enum.hasMoreElements()) {
		anObject = enum.nextElement();
		newVector.addElement((Object)convert(anObject));
	}
	return newVector;
}		
/* 
 * Convert a collection of objects into strings
 */
public Vector convertAll(Vector aVector){
	Object anObject;
	Vector newVector = new Vector();
	Enumeration enum = aVector.elements();
	while (enum.hasMoreElements()) {
		anObject = enum.nextElement();
		newVector.addElement((Object)convert(anObject));
	}
	return newVector;
}	
	public DataStore getDataStore()
	{
		return dataStore;
	}	
	public Vector getQueries()
	{
		if (queryCollection == null)
			queryCollection = new Vector();
		return queryCollection;
	}	
	public Object getSource()
	{
		return sourceObject;
	}	
	public DataObject getSourceAsDataObject()
	{
		return (DataObject)sourceObject;
	}	
	public Key getSourceAsKeyObject()
	{
		return (Key)sourceObject;
	}	
/*
 * Return a Vector containing the sourceData
 */

public Vector getSourceAsVector() {
	return (Vector) sourceObject;
}	
/* 
 * A test as whether this particular injector is applicable or not.
 * For answers of false, the result should be to do nothing.
 */
	public abstract boolean isApplicable(Object anObject);
	public void setDataStore(DataStore aDataStore)
	{
		dataStore = aDataStore;
	}	
public void setSource(Object anObject){

		sourceObject = anObject;
}	
}