package com.ibm.vap.Persistence;

/**
 */
 import java.lang.*;
 import java.util.*;
 import javax.ejb.*;
 import com.ibm.vap.RuntimeTools.*;
 import com.ibm.vap.Persistence.*;
 import com.ibm.vap.Transactions.*;
 import com.ibm.vap.common.VapRemoteObjectLockedException;
 
 public abstract class ServiceObject extends GeneralServiceObject implements ServiceObjectIfc  {
	
	private Vector inputKeys;
	private Vector inputPredicates;
	private PersistentHomeCollection home;
/**
 * Factory method.
 */
protected ServiceObject( ) {
	 return;
}
/**
 * Factory method.
 */
public ServiceObject(PersistentHomeCollection aHome) {
	super();
	this.setHome(aHome);
	return;
}
/**
 * Add a key to the input key collection.
 */
public  void addInputKey(Key aKey ) 
 {
		this.getInputKeys().addElement(aKey);
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult allInstances() 
 {
	 Trace.show(">>>>executing allInstances");
	if (isToRunAsync())
		{
			createNewAllInstancesThread();
			getServiceThread().start();
		}
			else {
				executeAllInstances();
				setToCompleted();
				};
	return result();
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult allInstancesWithLock()
 {
	Trace.show(">>>>executing allInstancesWithLock");
	
	if (isToRunAsync())
	{
		this.createNewAllInstancesWithLockThread();
		this.getServiceThread().start();
	}
	else
	{
		this.executeLockAll();
		if (this.result().isError())
			this.result().setToLockError();
		else
			this.executeAllInstances();

		this.setToCompleted();
	}

	return result();
}
/**
 * Clone the SO. 
 * 
 */
public Object clone( ) 
{
		ServiceObject aClone = (ServiceObject)super.clone();
		aClone.cloneReset();
		return aClone;
}
/**
 * Wipe out any internal values that should not be kept in a clone. 
 * 
 */
public void cloneReset( ) 
{
		super.cloneReset();
		inputKeys = null;
		inputPredicates = null;
		return;
}
/**
 * Create a new instace of a DO with data take from the entity bean.
 */
public DataObject createDOFromBean(EntityBean aBean) {
	DataObject aDO = createNewDO();
	initializeFromBean(aDO, aBean);
	return aDO;
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewAllInstancesThread() {
	setServiceThread(new Thread(new AllInstancesRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewAllInstancesWithLockThread() {
	setServiceThread(new Thread(new AllInstancesWithLockRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewCustomQueryThread(String aQueryName, Object[] args) {

	Runnable newRunnable = new CustomQueryRunnable(this, aQueryName, args);
	
	setServiceThread(new Thread(newRunnable));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewCustomQueryWithLockThread(String aQueryName, Object[] args) {

	Runnable newRunnable = new CustomQueryWithLockRunnable(this, aQueryName, args);
	
	setServiceThread(new Thread(newRunnable));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewDeleteThread() {
	setServiceThread(new Thread(new DeleteRunnable(this)));
}
/**
 * 
 */
public abstract DataObject createNewDO();
/**
 * Create a new thread to run the service on.
 */
protected  void createNewFindByKeyThread() {
	setServiceThread(new Thread(new FindByKeyRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewFindByKeyWithLockThread() {
	setServiceThread(new Thread(new FindByKeyWithLockRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewInsertThread() {
	setServiceThread(new Thread(new InsertRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewLockThread() {
	setServiceThread(new Thread(new LockRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewSingleLockThread() {
	setServiceThread(new Thread(new SingleLockRunnable(this)));  
}
/**
 * Create a new thread to run the service on.
 */
protected  void createNewUpdateThread() {
	setServiceThread(new Thread(new UpdateRunnable(this)));  
}
/**
 * Method used for custom queries with pessimistic locking disabled.
 */
public ServiceResult customQuery(String aQueryName, Object[] args) 
 {
	if (isToRunAsync()) {
		createNewCustomQueryThread(aQueryName, args);
		getServiceThread().start();
	} else {
		executeCustomQuery(aQueryName, args);
		setToCompleted();
	}
	
	return result();
}
/**
 *  * Method used for custom queries with pessimistic locking enabled.
 */
public ServiceResult customQueryWithLock(String aQueryName, Object[] args)
 {
	if (isToRunAsync()) {
		this.createNewCustomQueryWithLockThread(aQueryName, args);
		this.getServiceThread().start();
	} else	{
		this.executeCustomQueryLock(aQueryName, args);
		if (this.result().isError())
			this.result().setToLockError();
		else
			this.executeCustomQuery(aQueryName, args);

		this.setToCompleted();
	}

	return result();
}
/**
 * This method is one of the generic CRUD services.  Note this version of delete
 * assumes that what is to be deleted has already been set in the input.
 */
public ServiceResult delete() 
 {
	Trace.show(">>>>executing delete");
	if (isToRunAsync())
		{
			createNewDeleteThread();
			getServiceThread().start();
		}
			else {
				executeDelete();
				setToCompleted();
				}
	return result();
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult delete(Vector aCollection ) 
 {
	inputs(aCollection);
	return delete();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult delete(EntityBean bo) 
 {
	addInput(bo);
	return delete();
}
/**
 * To be implemented in subclasses.  Default is to do nothing.
 */
public void executeAllInstances() {}	
/**
 * To be implemented in subclasses.  Default is to do nothing.
 */
public void executeCustomQuery(String aQueryName, Object[] args) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public  void executeCustomQueryLock(String aQueryName, Object[] args) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public  void executeDelete( ) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public void executeFindByKey( ) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public void executeInsert( ) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public  void executeLockAll( ) {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public void executeSingleLock() {}	
/**
 * To be implemented in subclasses. Default is to do nothing.
 */
public  void executeUpdate( ) {}	
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult findByKey() 
 {
	Trace.show(">>>>executing find by key");
	if (isToRunAsync())
		{
			createNewFindByKeyThread();
			getServiceThread().start();
		}
			else {
				executeFindByKey();
				setToCompleted();
				}
	return result();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult findByKey(Key aKey) 
 {
	addInput(aKey);
	return findByKey();

}
/**
 * This method is one of the generic CRUD services.
 */
public  ServiceResult findByKey( Vector aCollection) 
 {
	inputs(aCollection);
	return findByKey();
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult findByKeyWithLock()
 {
	Trace.show(">>>>executing find by key with lock");

	if (this.isToRunAsync())
	{
		this.createNewFindByKeyWithLockThread();
		this.getServiceThread().start();
	}
	else
	{
		this.executeSingleLock();
		if (this.result().isError())
			this.result().setToLockError();
		else
			this.executeFindByKey();

		this.setToCompleted();
	}

	return this.result();
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult findByKeyWithLock(Key aKey)
 {
	addInput(aKey);
	return findByKeyWithLock();

}
/**
 * This method is one of the generic CRUD services.
 */
public  ServiceResult findByKeyWithLock( Vector aCollection) throws VapRemoteObjectLockedException 
 {
	inputs(aCollection);
	return findByKeyWithLock();
}
/**
 * 
 */
public DOCache getCache( ) 
 {
 	return this.getHome().getCache();
	}
/**
 * An accessor.
 */
protected  DataStore getDataStore() 
{
	return this.getHome().getDataStore();
}
/**
 * An accessor.
 */
protected  PersistentHomeCollection getHome() 
{
	return home;
}
/**
 * accessor.
 */
protected  Vector getInputKeys() 
 {
 	if (inputKeys == null)
 		inputKeys = new Vector(5);
 	return inputKeys;
}
/**
 * accessor.
 */
protected  Vector getInputPredicates() 
 {
 	if (inputPredicates == null)
 		inputPredicates = new Vector(5);
 	return inputPredicates;
}
/**
 * Answer the default isolation implementor
 * Subclasses with locking services can override
 * to return a locking policy.
 */
public com.ibm.vap.Isolation.ObjectIsolationImplementor getIsolationImplementor()
{
	return getHome().createDefaultIsolationImplementor();
}
/**
 * An accessor.
 */
public Session getSession() 
{
	if (super.getSession() == null)
		this.setSession(this.getHome().getSession());
	return super.getSession();
}
/**
 * To be overridden in subclasses. Default is to update predicates.
 * Subclasses should invoke super AFTER populating data fields
 */
public void initializeFromBean(DataObject aDO, EntityBean aBean) {
	aDO.updatePredicateValues();
}
/**
 * This method is one of the generic CRUD services.  This method assumes that
 * what is to updated is already set in the input ivar.
 */
public ServiceResult insert() 
 {
	Trace.show(">>>>executing insert");
	if (isToRunAsync())
		{
			createNewInsertThread();
			getServiceThread().start();
		}
			else {
				executeInsert();
				setToCompleted();
				}
	return result();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult insert(Vector aCollection ) 
 {
	inputs(aCollection);
	return insert();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult insert(EntityBean bo) 
 {
	addInput(bo);
	return insert();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult lock() 
{
  	Trace.show(">>>>executing lock all");

	if (this.isToRunAsync())
	{
		this.createNewLockThread();
		this.getServiceThread().start();
	}
	else
	{
		this.executeLockAll();
		if (this.result().isError())
			this.result().setToLockError();
		this.setToCompleted();
	}

	return this.result();
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult lock(Vector aCollection ) 
 {
	inputs(aCollection);
	return singleLock();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult lock(EntityBean bo) 
 {
	addInput(bo);
	return singleLock();

}
/**
 * This just pass through to the result collection.
 */
public synchronized Vector oids( ) 
{	
	return this.result().results();
}
/**
 * An accessor.
 */
public  void setHome(PersistentHomeCollection aHome) 
{
	home = aHome;
}
/**
 * A setter.
 */
protected  void setInputKeys(Vector aCollection) 
{
	inputKeys = aCollection;
}
/**
 * A setter.
 */
protected  void setInputPredicates(Vector aCollection) 
{
	inputPredicates = aCollection;
}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult singleLock() 
 {
	Trace.show(">>>>executing single lock");

	if (this.isToRunAsync())
	{
		this.createNewSingleLockThread();
		this.getServiceThread().start();
	}
	else
	{
		this.executeSingleLock();
		if (this.result().isError())
			this.result().setToLockError();
		this.setToCompleted();
	}

	return this.result();
}
/**
 * This method is one of the generic CRUD services.  Note that this assumes
 * that what is to be updated is set in the input arguments.
 */
public ServiceResult update() 
 {
	Trace.show(">>>>executing update");
	if (isToRunAsync())
		{
			createNewUpdateThread();
			getServiceThread().start();
		}
			else {
				executeUpdate();
				setToCompleted();
				}
	return result();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult update(Vector aCollection ) 
 {
	inputs(aCollection);
	return update();

}
/**
 * This method is one of the generic CRUD services.
 */
public ServiceResult update(EntityBean bo) 
 {
	addInput(bo);
	return update();
}
}