package com.ibm.vap.Transactions;

/**
 * This type was created in VisualAge.
 */

 import java.util.Enumeration;
 import java.util.Vector;
 import java.rmi.RemoteException;
 import com.ibm.vap.common.VapSet;
 import com.ibm.vap.common.Association;
 
public abstract class CollectionChange {

	protected VapSet items;

	public static final int ReasonRemovedElements = 1;
	public static final int ReasonAddedElements = 2;
	public static final int ReasonReplacedElements = 3;
	public static final int ReasonModifiedElements = 4;
	public static final int ReasonReplacedCollection = 5;
	public static final int ReasonCollectionChangeSet = 6;
/**
 * CollectionChange constructor comment.
 */
public CollectionChange() {
	super();
}
/**
 * This method was created in VisualAge.
 */
protected abstract int changeType() ;
/**
 * This method was created in VisualAge.
 */
public Enumeration elements() {

	return getItems().elements();
}
/**
 * Return the business objects which are contained within an VapSet
 */
protected VapSet getItems() {

	if (items == null)
		items = new VapSet();
	return items;
}
/**
 * See whether the argument exists in our collection of Associations
 */
public boolean includes(Object anObject) {

	return getItems().contains(anObject);
}
/**
 * Return a set of associations between all of our elements and their indicies 
 * in the linkCollection argument
 */
protected Vector indicesForData(LinkCollection aLinkCollection) {

	Vector result = new Vector(getItems().size());
	VapEJBObject anEJBObject;
	Object value;

	Enumeration enum = this.elements();
	while (enum.hasMoreElements()) {
		anEJBObject = (VapEJBObject) enum.nextElement();
		try {
			value = new Integer(aLinkCollection.indexOf(anEJBObject));
		} catch (RemoteException e) {
			value = null;
		}
		result.addElement(new Association(anEJBObject, value));
	}

	return result;
}
/**
 * Combine the elements of the argument with our elements
 */
public void merge(CollectionChange aCollectionChange) {

	this.getItems().addAll(aCollectionChange.getItems());
}
/**
 * Defer to our set of business objects, taking care not to lazy initialize the creation of the set
 */
public void remove(Object anObject) {

	getItems().remove(anObject);
}
/**
 * Answer the size of our VapSet.  Note that nil size = 0
 */
public int size() {

	return getItems().size();
}
}