package com.ibm.vap.Transactions;

/**
 * This type was created in VisualAge.
 */

 import java.util.Vector;
 
public class CollectionChangesSignaller {

	private LinkCollectionShell shell;
	private Transaction transaction;
	private Vector addedIndices, removedIndices;
/**
 * CollectionChangesSignaller constructor comment.
 */
public CollectionChangesSignaller(LinkCollectionShell aShell, Transaction aTransaction, Vector newAddedIndices, Vector newRemovedIndices) {
	shell = aShell;
	transaction = aTransaction;
	addedIndices = newAddedIndices;
	removedIndices = newRemovedIndices;
}
/**
 * CollectionChangesSignaller constructor comment.
 */
public CollectionChangesSignaller(LinkCollectionShell aShell, Vector newAddedIndices, Vector newRemovedIndices) {
	shell = aShell;
	addedIndices = newAddedIndices;
	removedIndices = newRemovedIndices;
}
/**
 * Signal the events.
 * First broadcase the removes, and then the adds
 */
public void signalEvents() {
	
	shell.abtSignalRemovesWithIndices(removedIndices, transaction);
	shell.abtSignalAddsWithIndices(addedIndices, transaction);

	Transaction current = Transaction.getCurrent();
	if ((current.isReadOnly()) || (current.isShared()))
		try {
			shell.getItems().resetChangedLinks();
		} catch (java.rmi.RemoteException e) { }
}
}