package com.ibm.vap.Transactions;


/**
 * ManyLink
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */
import java.util.Enumeration;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.ibm.vap.common.VapAccessException;

public class ManyLink extends AbstractLink implements Cloneable
{
	private LinkCollectionShell targetCollection;
	private VapEJBObject source;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Create a properly initialized Many Link
 */
public ManyLink(VapEJBObject anEjbObject,Relationship aRelationship)
{
	this.setRelationship(aRelationship);
	this.setSource(anEjbObject);
}
public Object clone() {
	try 
	{ 
		return super.clone();
	} 
	catch (CloneNotSupportedException e) {
		return null;
	};		
}
/**
 * Forward to my target collection
 */
public void connectTo(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().connectTo(anEjbObject); 
}
/**
 * Answer a version of myself.  This is a copy to be used by the transaction
 * 'versioning' framework.  
 * Now that our target is versioned, we don't have to deal with this.
 */
public ManyLink copyLink(){
	return this;
}
/**
 * Forward to my target collection
 */
public void disconnectFrom(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().disconnectFrom(anEjbObject); 
}
/**
 * Forward to my target collection
 */
public void disconnectFromRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().disconnectFromRetrieved(anEjbObject); 
}
/**
 * Private - Answer object which indicates that a link is in initial state
 */
private LinkCollectionShell getInitialTarget()
{
	return new LinkCollectionShell(this); 
}
/**
 * Answer my source busines object
 */
public VapEJBObject getSource()
{
	return source; 
}
/**
 * Answer my target BO
 */
public LinkCollectionShell getTarget()
{
	return this.getTargetCollection(); 
}
/**
 * Answer my target BO
 */
public LinkCollectionShell getTargetCollection()
{
	if (targetCollection == null)
		targetCollection = this.getInitialTarget();

	return targetCollection; 
}
/**
 * Answer my value.  This is the API by which BO accessors provide
	the target of the relationship.
 */
public LinkCollectionShell getValue()
{
	return this.getTargetCollection(); 
}
/**
 * Initialize our target collection (registers its version)
 */
public void initializeTarget()
{
	this.setTargetCollection(this.getInitialTarget());
}
/**
 * Answer true if my target contains a businessObject
 */
public boolean isConnected()
{
	if (targetCollection != null)
		return targetCollection.isConnected();
	else
		return false;
}
/**
 * Answer true if I am a single link
 */
public boolean isSingleLink()
{
	return false;
}
/**
 * Mark the link to be removed: disconnect from the target. Just forward
 */
public void markRemoved() throws RemoteException, RemoveException
{
	this.getTargetCollection().remove(); 
}
/**
 * anEJBObject, which is part of our collection, has signalled that it has changed
 */
public void primChangeSignalledForTarget(VapEJBObject anEJBObject) throws RemoteException {

	this.getTargetCollection().modified(anEJBObject);
}
/**
 * Reconcile links between old version and new version after
 *	refreshing from the database
 */
public void reconcileFromRetrievedWith(AbstractLink anOldLink)
{
	this.reconcileWith(anOldLink);
}
/**
 * Reconcile links between old version and new version after
 *	refreshing from the database
 */
public void reconcileWith(AbstractLink anOldLink)
{
	ManyLink oldLink;

	oldLink = (ManyLink)anOldLink;
	this.setSource (oldLink.getSource());
	if (oldLink.isConnected())
		this.setTargetCollection(oldLink.getTargetCollection());
}
/**
 * Just forward
 */
public void secondaryConnectTo(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().secondaryConnectTo(anEjbObject); 
}
/**
 * Just forward
 */
public void secondaryConnectToRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().secondaryConnectToRetrieved(anEjbObject); 
}
/**
 * Just forward
 */
public void secondaryDisconnectFrom(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().secondaryDisconnectFrom(anEjbObject);
}
/**
 * Just forward
 */
public void secondaryDisconnectFromRetrieved(VapEJBObject anEjbObject) throws RemoteException
{
	this.getTargetCollection().secondaryDisconnectFromRetrieved(anEjbObject);
}
/**
 * Set my source to a business object
 */
public void setSource(VapEJBObject anEjbObject) 
{
	source = anEjbObject;
}
/**
 * Set my target BO
 */
private void setTargetCollection(LinkCollectionShell aCollection)
{
	targetCollection = aCollection;
}
}