package com.ibm.vap.Transactions;

/***
 * Version
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 **/

import java.util.Vector;
import java.util.Enumeration;
import javax.ejb.EntityBean;
import javax.ejb.RemoveException;
import java.rmi.RemoteException;
import com.ibm.vap.Persistence.DataStore;
import com.ibm.vap.Persistence.Session;
import com.ibm.vap.Persistence.ServiceResult;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.common.VapAccessException;
import com.ibm.vap.common.VapObjectLockedException;
import com.ibm.vap.common.VapLocalObjectLockedException;
import com.ibm.vap.common.VapRemoteObjectLockedException;
import com.ibm.vap.common.VapReadOnlyException;
import com.ibm.vap.Isolation.InternalObjectLock;
import com.ibm.vap.Isolation.ExternalObjectLock;
import com.ibm.vap.Isolation.ObjectIsolationImplementor;
import com.ibm.vap.Isolation.InternalIsolationImplementor;
import com.ibm.vap.Isolation.ExternalIsolationImplementor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class Version extends Object
{
	private EntityBean bean = null;
	private VapEJBObject ejbObject = null;
	private VersionState state = null;
	private boolean isRealized = true;
	private TransactionView view = null;
	private long modificationLevel = -1;
	private long parentModificationLevel = -1;
	protected transient PropertyChangeSupport implPropertyChange = null;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Version constructor
 **/
public Version(TransactionView aView)
{
	this.setState(this.getInitialState());
	this.setModificationLevel(-1);
	this.setParentModificationLevel(-1);
	this.setView(aView);
}
/**
* Acquire a update (write) lock for the version
**/
public void acquireLock() throws RemoteException, VapObjectLockedException
{
	this.getIsolationImplementor().acquireLockFor(this);
}
/**
 * Add a deferred message to tell our business object that some data was merged into it.
 * This is used to signal generic events and also to allow the business object to tell any many links it
 * belongs to that it has changes so they can refresh themselves
 */
public void addMergedIntoDeferredMessages()
{
	if (!this.isRemoved() && (getEjbObject().isBusinessObject())) {
		String selector;
		selector = (getTransaction().isReadOnly() || getTransaction().isShared()) ?
						"mergedIntoReadOnly" : "mergedInto";
		getTransaction().addDeferredMessage(new VapDeferredMessage(getEjbObject(), selector));
	}
}
/* The version's change listener is to support the impl's listeners */
public void addPropertyChangeListener(PropertyChangeListener aListener){
	implPropertyChange.addPropertyChangeListener(aListener);
}
/**
 * Mark the version  realized (someone has accessed the version)
 */
public void beRealized()
{
	isRealized = true;
}
/**
 * Mark the version not realized the version has accessed only for registering dependants)
 */
public void beUnrealized()
{
	isRealized = false;
}
/**
* Answer true if the child version can be merged
**/
protected boolean canMerge(Version aChildVersion)
{
	return getState().canMerge(this, aChildVersion);
}
	public static VersionState createNewPersistentState() {
		return new com.ibm.vap.Persistence.NewPersistentState();
	}
	public static VersionState createNewTransientState() {
		return new NewState();
	}
	public static VersionState createOldPersistentState() {
		return new com.ibm.vap.Persistence.OldPersistentState();
	}
/**
 * Discard the version
 */
protected void discard()
{
	if (this.getEjbObject() != null)
	{
		this.releaseLock();
		this.getBom().resetCachedItemsFor(this);
		if (this.isTopLevel())
			this.getBom().resetTemporaryIdentifier();
		this.setBean(null);
		this.setView(null);
		this.setEjbObject(null);
	}
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, char oldValue, char newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, double oldValue, double newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, float oldValue, float newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, int oldValue, int newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, long oldValue, long newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue)); }
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This overloaded method here is for SingLinks ( the target of ..1 relationships.  We must
 * get the values from the link and then forward these to the impl
 * Is is possible the link fails to get the value in which case we throw the exception
 */
public void firePropertyChange(String propertyName, SingleLink oldLink, SingleLink newLink) throws java.rmi.RemoteException {
	implPropertyChange.firePropertyChange(propertyName, oldLink.getValue(), newLink.getValue());
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	implPropertyChange.firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Support for reporting bound property changes.
 * The version's property change handlers are for the impl
 * This is overloaded to support the different primitive types as well as Object and its subclasses
 */
public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
	if ( oldValue != newValue ) {
	implPropertyChange.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue)); }
}
/**
 * Answer version's bean
 */
public EntityBean getBean()
{
	return bean;
}
/**
 * Answer version's Bom
 */
public BOManager getBom()
{
	return this.getEjbObject().getBom();
}
/**
 * Answer the datastore
 */
public DataStore getDataStore()
{
	return this.getHome().getDataStore();
}
/**
 * Answer version's EJObject
 */
public VapEJBObject getEjbObject()
{
	return ejbObject;
}
/**
 * Answer the external isolation implementor
 */
protected ExternalIsolationImplementor getExternalIsolationImplementor()
{
	return this.getIsolationImplementor().getExternalIsolationImplementor();
}
/**
 * Answer the external lock
 */
public ExternalObjectLock getExternalLock()
{
	return this.getBom().getExternalLock();
}
public VapHome getHome()
{
	return this.getBom().getHome();
}
/**
 * Answer the initial state
 */
protected VersionState getInitialState()
{
	return InitialState.getSingleton();
}
/**
 * Answer the internal isolation implementor
 */
protected InternalIsolationImplementor getInternalIsolationImplementor()
{
	return this.getIsolationImplementor().getInternalIsolationImplementor();
}
/**
 * Answer the internal lock
 */
public InternalObjectLock getInternalLock()
{
	return this.getBom().getInternalLock();
}
/**
 * Answer the isolation implementor
 */
protected ObjectIsolationImplementor getIsolationImplementor()
{
	return this.getBom().getIsolationImplementor();
}
/**
 * Answer the bean's links
 */

public Vector getLinks()
{
	return this.getEjbObject().getLinksFor(this.getBean());
}
/**
 * Answer version's modification level
 **/
public long getModificationLevel()
{
	return modificationLevel;
}
/**
 * Answer version's name
 **/
public String getName()
{
	return this.getView().getName();
}
/**
 * Answer the version's identifier
 */
public OID getObjectIdentifier()
{
	return this.getBom().getObjectIdentifierFor(this.getBean());
}
/**
 * Answer the initial parent modification level
 **/
public long getParentModificationLevel()
{
	return parentModificationLevel;
}
/**
 * Answer the version's parent version
 */
public Version getParentVersion()
{
	return this.getParentView().primGetVersion(this.getVersionIdentifier());
}
/**
 * Answer the version's parent view
 */
protected TransactionView getParentView()
{
	return this.getView().getParent();
}
/* Return the property change ivar */
protected PropertyChangeSupport getPropertyChange() {
	return implPropertyChange ;
}
	public VersionState getState() {
		return state;
	}
	protected OID getTemporaryIdentifier() {
		return getBom().getTemporaryIdentifier();
	}
/**
 * Answer the transaction of the version
 */
public Transaction getTransaction()
{
	return this.getView().getTransaction();
}
public OID getVersionIdentifier()
{
	return getState().getVersionIdentifier(this);
}
/**
 * Answer the view of the version
 */
protected TransactionView getView()
{
	return view;
}
/**
 * Answer true if the version's bo has an external lock
 */
public boolean hasExternalLock()
{
	return this.getBom().hasExternalLock();
}
/**
 * Answer true if the version's bo has an internal lock
 */
public boolean hasInternalLock()
{
	return this.getBom().hasInternalLock();
}
/**
 * Answer true if the version has insert/delete presedence over
	a relationship's target
 */
public boolean hasPrecedenceOver(AbstractLink aLink)
{
	return (aLink.isConstrained()) && (this.getState().hasPrecedenceOver(aLink));
}
public long incrementModificationLevel()
{
	return (modificationLevel = modificationLevel + 1);
}
/*
 * Initialize an initial version for the passed BO and state.
 */
public void initialize(VapEJBObject anEjbObject, EntityBean aBean, VersionState aState)
{
	this.setEjbObject(anEjbObject);
	this.setState(aState);
	aState.initializeIn(this);
	this.setBean(aBean);
}
/*
 * Copy the essential state from another version.
 */
public void initializeAsIsFrom(Version anOldVersion) throws RemoteException
{
	EntityBean oldBean;

	oldBean = anOldVersion.getBean();
	this.primInitializeFrom(anOldVersion);
	// Reset our state, it may have been reset to synchronized by the above initialization
	this.setState(anOldVersion.getState().createCopyForNewVersion());
	this.setBean(this.getEjbObject().copyBean(oldBean));
}
/*
 * Copy the essential state from another version
 * and reset the synchronized state
 */
public void initializeAsSynchronizedFrom(Version anOldVersion) throws RemoteException
{
	EntityBean oldBean;

	oldBean = anOldVersion.getBean();
	this.primInitializeFrom(anOldVersion);
	this.setParentModificationLevel(anOldVersion.getModificationLevel());
	this.setBean(this.getEjbObject().copyBean(oldBean));
	this.getState().setInternallySynchronized(true);
	this.getState().setExternallySynchronized(true);
}
/*
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeForRepeatableReadFrom(Version aParentVersion) throws RemoteException
{
	aParentVersion.getInternalIsolationImplementor().initializeForRepeatableRead(this,aParentVersion);
}
/*
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeForUnrepeatableReadFrom(Version aParentVersion) throws RemoteException
{
	aParentVersion.getInternalIsolationImplementor().initializeForUnrepeatableRead(this,aParentVersion);
}
/*
 * Initialize version's links
 */
public void initializeLinks()
{
	Enumeration links;
	AbstractLink link;

	links = this.getLinks().elements();
	while (links.hasMoreElements())
	{
		link = (AbstractLink)links.nextElement();
		link.initializeTarget();
	}	
}
/**
 * Answer true if the version represents a non-collection business object
 */
public boolean isBusinessObjectVersion()
{
	return this.getEjbObject().isBusinessObject();
}
/**
 * Test if the version is descendant of another version
 */
public boolean isDescendantOf(Version aVersion)
{
	return this.getTransaction().isDescendantOf(aVersion.getTransaction());
}
/**
 * Answer the internal synchronization status
 */
public boolean isInternallySynchronized()
{
	return this.getState().isInternallySynchronized();
}
/**
 * Answer the modification status
 */
public boolean isModified()
{
	return this.getModificationLevel() != this.getParentModificationLevel();
}
/**
 * Answer true if the version is new
 **/
public boolean isNew()
{
	return this.getState().isNew();
}
/**
 * Answer true if the version is old
 **/
public boolean isOld()
{
	return this.getState().isOld();
}
/**
 * Answer the parent version's modification status
 */
public boolean isParentModified(Version aParentVersion)
{
	return aParentVersion.getModificationLevel() != this.getParentModificationLevel();
}
/**
 * Test if the version is a read-only version
 */
protected boolean isReadOnlyVersion()
{
	return false;
}
/**
 * Answer true if the version has been realized
 **/
public boolean isRealized()
{
	return isRealized;
}
public boolean isRemoved()
{
	return this.getState().isRemoved();
}
/**
 * Answer true if the version is a shared version
 */
public boolean isSharedVersion()
{
	return false;
}
/**
 * Answer true if the version is a top level version
 */
public boolean isTopLevel()
{
	return this.getTransaction().isTopLevel();
}
/**
 * Answer true if the version has not been realized
 **/
public boolean isUnrealized()
{
	return !this.isRealized();
}
/**
 * Lock a version with a lock
 */
public void lockWith(ExternalObjectLock aLock) throws RemoteException, VapRemoteObjectLockedException
{
	DataStore datastore;
	Session session;

	if (!this.isSharedVersion())
		if (this.isBusinessObjectVersion())
			if (!this.hasExternalLock())
				if ((datastore = this.getDataStore()) != null)
				{
					session = this.getTransaction().getSessionOn(datastore);
					if (this.synchronizeLock(session).isError())
						throw new VapRemoteObjectLockedException(this.getEjbObject());
					this.setExternalLock(aLock);
				}
}
/**
 * Lock a version with a lock
 */
public void lockWith(InternalObjectLock aLock) throws VapLocalObjectLockedException
{
	InternalObjectLock oldLock;

	if ((oldLock = this.getInternalLock()) == null)
		this.setInternalLock(aLock);
	else
		oldLock.attemptToLockWith(aLock);
}
/**
 * Mark the version to removed
 **/
public void markLocallyRemoved() throws RemoteException,RemoveException
{
	this.notifyUpdate();
	this.getState().markRemoved(this);
}
/**
 * Mark version modified
 */
public void markModified() throws VapAccessException
{
	this.notifyUpdate();
	this.primMarkModified();
}
/**
* Mark the version to have been read
**/
public void markRead() throws VapObjectLockedException
{
	this.notifyRead();
}
/**
 * Mark the version to removed
 **/
public void markRemoved() throws RemoteException,RemoveException
{
	this.notifyUpdate();
	this.getState().markRemoved(this);
}
/**
 * Merge version with a child version
 **/
protected void merge(Version childVersion)
{
	this.getState().merge(this, childVersion);
}
/**
* Merge a child version to self
* Tell the transaction to add us ( the parent version )
* as a deferred signaller so we can broadcast the fact that some data
* is merged into us
*/
protected void mergeEventDependents(Version aChildVersion) {
	getTransaction().addDeferredSignaller(this);
}
/**
 * The version is read
 */
public void notifyRead() throws VapLocalObjectLockedException
{
	InternalObjectLock lock;

	if ((lock = this.getInternalLock()) != null)
		lock.readAccessFor(this);
}
/**
* The version is registered into a view
**/
public void notifyRegistration() throws RemoteException, VapObjectLockedException
{
	this.getIsolationImplementor().notifyRegistrationFor(this);
}
/**
 * The version is updated
 */
public void notifyUpdate() throws VapLocalObjectLockedException
{
	InternalObjectLock lock;

	if ((lock = this.getInternalLock()) != null)
		lock.updateAccessFor(this);
}
/**
* Post-commit operations
**/
public void postCommit()
{
/*
	self data dataObject notNil ifTrue: [self data dataObject updatePredicateValues]
*/
}
/**
 * Copy the essential state from another version
 **/
public void primInitializeFrom(Version anOldVersion)
{
	VersionState newState;

	newState = anOldVersion.getState().createCopyForNewVersion();

	this.setEjbObject(anOldVersion.getEjbObject());
	this.setState(newState);
	this.setIsRealized(anOldVersion.isRealized());
	this.setModificationLevel(anOldVersion.getModificationLevel());
	this.setParentModificationLevel(anOldVersion.getParentModificationLevel());
	this.setPropertyChange(anOldVersion.getPropertyChange());

	newState.initializeIn(this);
}
/**
 * Mark version modified
 */
public void primMarkModified() throws VapAccessException
{
	this.getState().markModified(this);
}
/**
 * Remove the version and its components
 **/
public void primMarkRemoved() throws RemoteException, RemoveException
{
	AbstractLink link;
	Enumeration links;

	if (this.isBusinessObjectVersion())
	{
		links = this.getLinks().elements();
		while (links.hasMoreElements())
		{
			link = (AbstractLink)links.nextElement();
			link.markRemoved();
		}	
	}
}
/**
* Merge a child version to self
*/
protected void primMerge(Version aChildVersion)
{
	this.setEjbObject(aChildVersion.getEjbObject());
	aChildVersion.getBom().resetCachedItemsFor(aChildVersion);

	if (!aChildVersion.isInternallySynchronized())
	{
		this.mergeEventDependents(aChildVersion);
		this.addMergedIntoDeferredMessages();
		this.setModificationLevel(aChildVersion.getModificationLevel());
		this.getEjbObject().merge(this,aChildVersion);
	}

	this.getInternalIsolationImplementor().mergeLocks(aChildVersion,this);
}
/**
 * Promote child version's external lock to the parent version
 */
public void promoteExternalLockTo(Version aParentVersion)
{
	ExternalObjectLock lock;

	if ((lock = this.getExternalLock()) != null)
		lock.promote(this,aParentVersion);
}
/**
 * Promote child version's internal lock to the parent version
 */
public void promoteInternalLockTo(Version aParentVersion)
{
	InternalObjectLock lock;

	if ((lock = this.getInternalLock()) != null)
		lock.promote(this,aParentVersion);
}
/**
 * Promote child version's  locks to the parent version
 */
public void promoteLockTo(Version aParentVersion)
{
	this.getIsolationImplementor().promoteLock(this,aParentVersion);
}
/**
 * Reconcile links between old version and new version after
 * refreshing from the database
 **/
public void reconcileLinksWith(Version anOldVersion)
{
	AbstractLink newLink, oldLink;
	Enumeration newLinks, oldLinks;

	newLinks = this.getLinks().elements();
	oldLinks = anOldVersion.getLinks().elements();
	while (newLinks.hasMoreElements())
	{
		newLink = (AbstractLink)newLinks.nextElement();
		oldLink = (AbstractLink)oldLinks.nextElement();
		newLink.reconcileWith(oldLink);
	}	
}
/**
 * Synchronize version's state from the database
 **/
public ServiceResult refresh(Session aSession)
{
	return getState().refresh(this,aSession);
}
/**
 * Release the version's external lock
 */
public void releaseExternalLock()
{
	ExternalObjectLock lock;

	if ((lock = this.getExternalLock()) != null)
		lock.releaseFor(this);
}
/**
 * Release the version's internal lock
 */
public void releaseInternalLock()
{
	InternalObjectLock lock;

	if ((lock = this.getInternalLock()) != null)
		lock.releaseFor(this);
}
/**
 * Release the version's locks
 */
public void releaseLock()
{
	this.getIsolationImplementor().releaseLockFor(this);
}
/* The version has the property change support for the impl */
public void removePropertyChangeListener(PropertyChangeListener aListener) {
	implPropertyChange.removePropertyChangeListener(aListener);
}
/**
 * Set version's bean
 */
public void setBean(EntityBean aBean)
{
	bean = aBean;
}
/**
 * Set version's EJBObject
 * This is also going to be the source of any signalling that we do
 * ( we hold the property change support for the impl )
 * so we should initialize the property change support source to be the ejbObject
 */
public void setEjbObject(VapEJBObject anObject)
{
	ejbObject = anObject;
	if (anObject != null)
		implPropertyChange = new PropertyChangeSupport(ejbObject);
}
/**
 * Set the external lock
 */
public void setExternalLock(ExternalObjectLock aLock)
{
	this.getBom().setExternalLock(aLock);
}
/**
 * Set the internal lock
 */
protected void setInternalLock(InternalObjectLock aLock)
{
	this.getBom().setInternalLock(aLock);
}
/**
 * Set the realization flag
 **/
public void setIsRealized(boolean aFlag)
{
	isRealized = aFlag;
}
/**
 * Set version's modification level
 **/
protected void setModificationLevel(long aNumber)
{
	modificationLevel = aNumber;
}
/**
 * Set the initial parent modification level
 **/
protected void setParentModificationLevel(long aNumber)
{
	parentModificationLevel = aNumber;
}
/* Set the property change ivar */
protected void setPropertyChange(PropertyChangeSupport propertyChange) 
{
	implPropertyChange = propertyChange;
}
	public void setState(VersionState aVersionState) {
		state = aVersionState;
	}
/**
 * Set the view of the version
 */
protected void setView(TransactionView aView)
{
	view = aView;
}
/*
 * Copy the essential state from another version.
 */
public void shallowInitializeAsIsFrom(Version anOldVersion)
{
	this.primInitializeFrom(anOldVersion);
	this.setBean(anOldVersion.getBean());
}
/*
 * Copy the essential state from another version
 * and reset the synchronized state
 */
public void shallowInitializeAsSynchronizedFrom(Version anOldVersion)
{
	this.primInitializeFrom(anOldVersion);
	this.setParentModificationLevel(anOldVersion.getModificationLevel());
	this.setBean(anOldVersion.getBean());
	this.getState().setInternallySynchronized(true);
	this.getState().setExternallySynchronized(true);
}
	/**
	 * @return  a string short name for this class
	 */
	public static String shortClassName() {
		return "Version";
	}
public void signalEvents(){
}
/**
 * Synchronize version's state into the database
 **/
public ServiceResult synchronize(Session aSession)
{
	return getState().synchronize(this,aSession);
}
/**
 * Synchronize version's lock into the database
 **/
public ServiceResult synchronizeLock(Session aSession)
{
	return getState().synchronizeLock(this,aSession);
}
	/**
	 * @return  a string representation of the object.
	 * @since   JDK1.0
	 */
	public String toString() {
		return this.shortClassName() + "{" + this.getName() + 
				"\n	(" + this.getState().internalStateString() + ")" +
				"\n	(" + this.getModificationLevel() + "," + this.getParentModificationLevel() + ")}";
	}
/**
 * Transfer the ownership of a lock to a new version when converting
 * from a read only version to an updatable version
 */
public void transferExternalLockTo(Version aNewVersion)
{
	ExternalObjectLock lock;

	if ((lock = this.getExternalLock()) != null)
		lock.transfer(this,aNewVersion);
}
/**
 * Transfer the ownership of a lock to a new version when converting
 * from a read only version to an updatable version
 */
public void transferInternalLockTo(Version aNewVersion)
{
	InternalObjectLock lock;

	if ((lock = this.getInternalLock()) != null)
		lock.transfer(this,aNewVersion);
}
/**
 * Transfer the ownership of a lock to a new version when converting
 * from a read only version to an updatable version
 **/
public void transferLockTo(Version aNewVersion)
{
	this.getIsolationImplementor().transferLock(this,aNewVersion);
}
}