package com.ibm.vap.common;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;
/**
 * This type was created in VisualAge.
 */
public class VapMethodInvocation {
	private static java.util.ResourceBundle resobjectExtender = java.util.ResourceBundle.getBundle("objectExtender");  //$NON-NLS-1$
/**
 * VapMethodInvocation constructor comment.
 */
public VapMethodInvocation() {
	super();
}
/**
 * Return the method named aMethodName from aClass with arguments, args
 */
public static Method getMethod(String aMethodName, Class aClass, Class[] argTypes) {

	Method aMethod;

	try {
		return aClass.getMethod(aMethodName, argTypes);
	} 
	catch (NoSuchMethodException e) {throw new RuntimeException(resobjectExtender.getString("ch_noMethod") + aClass);} //$NON-NLS-1$
	
}
/**
 * Return the method named aMethodName from aClass with arguments, args
 */
public static Method getMethod(String aMethodName, Class aClass, Object[] args) {


	Class[] argTypes;
	
	argTypes = (args == null) ? null : (new VapMethodInvocation()).typeArray(args);
	
	return getMethod(aMethodName, aClass, argTypes);
}
/**
 * Return the method named aMethodName from anObject
 */
public static Method getMethod(String aMethodName, Object anObject) {
	return getMethod(aMethodName, anObject, null);
}
/**
 * Return the method named aMethodName from anObject with arguments args
 */
public static Method getMethod(String aMethodName, Object anObject, Class[] types) {

	Class aClass;	
	aClass = anObject.getClass();
	return getMethod(aMethodName, aClass, types);
}

/**
 * Return the method named aMethodName from anObject with arguments args
 */
public static Method getMethod(String aMethodName, Object anObject, Object[] args) {

	Class aClass;	
	aClass = anObject.getClass();
	return getMethod(aMethodName, aClass, args);
}

/**
 * Perform the method named aMethodName on anObject with arguments, args
 */
public static Object performMethod(String aMethodName, Class aClass, Object anObject, Object[] args) {

	return performMethod(aMethodName, aClass, anObject, args, null);
}
/**
 * Perform the method named aMethodName on anObject with arguments, args
 */
public static Object performMethod(String aMethodName, Class aClass, Object anObject, Object[] args, Class[] types) {

	Method aMethod;
	
	if (types == null)
		aMethod = getMethod(aMethodName, aClass, args);
	else
		aMethod = getMethod(aMethodName, aClass, types);

	try {
		return aMethod.invoke(anObject, args);
	} 
	catch (InvocationTargetException e) {throw new RuntimeException(resobjectExtender.getString("ch_invocation") + aClass);}		 //$NON-NLS-1$
	catch (IllegalAccessException e3) {throw new RuntimeException(resobjectExtender.getString("ch_illegalAcess") + aClass);} //$NON-NLS-1$
	
}
/**
 * Perform the method named aMethodName on anObject
 */
public static Object performMethod(String aMethodName, Object anObject) {
	return performMethod(aMethodName, anObject, null);
}
/**
 * Perform the method named aMethodName on anObject with arguments, args
 */
public static Object performMethod(String aMethodName, Object anObject, Object[] args) {

	Class aClass;	
	aClass = anObject.getClass();
	return performMethod(aMethodName, aClass, anObject, args);
}

/**
 * Perform the method named aMethodName on anObject with arguments, args
 */
public static Object performMethod(String aMethodName, Object anObject, Object[] args, Class[] types) {

	Class aClass;	
	aClass = anObject.getClass();
	return performMethod(aMethodName, aClass, anObject, args, types);
}

/**
 * Perform the static method named aMethodName for aClass
 */
public static Object performStaticMethod(String aMethodName, Class aClass) {
	return performStaticMethod(aMethodName, aClass, null);
}
/**
 * Perform the static method named aMethodName for aClass
 */
public static Object performStaticMethod(String aMethodName, Class aClass, Object[] args) {
	return performMethod(aMethodName, aClass, (Object)null, args);
}
/**
 * Return a class array containing the classes for each object in args.
 */
private Class[] typeArray(Object[] args) {

	Vector argVector;
	Enumeration argEnum;
	Class[] argTypes = null;
	
	if (args != null) {
		argVector = ArrayVectorTransform.toVector(args);
		argTypes = new Class[argVector.size()];
		argEnum = argVector.elements();
		int i = 0;
		while (argEnum.hasMoreElements()) {
			argTypes[i] = argEnum.nextElement().getClass();
			i++;
		}
	}
	return argTypes;
}
}