package com.ibm.vap.swing.list;

import java.util.Enumeration;
import java.util.Vector;
import com.ibm.vap.common.ArrayVectorTransform;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEvent;
import com.ibm.vap.Transactions.VapActionListener;
import com.ibm.vap.Transactions.VapTransactionalEvent;
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.VapSwingCollectionShell;

/**
 * This type was created in VisualAge.
 */

public class VapDefaultListModel extends VapAbstractListModel {
	private VapSwingCollectionShell delegate = new VapSwingCollectionShell((VapActionListener)this);
	private PersistentHomeCollection home;
	public boolean shouldQueryAfterMergedIntoEvent = true;
/**
 * VapDefaultListModel constructor comment.
 */
public VapDefaultListModel() {
	super();
}
/**
 * Create a ListModel for a PersistenctHomeCollection setting the delegate to allInstances
 * from aHome.  Keep a reference to aHome.
 */
public VapDefaultListModel(PersistentHomeCollection aHome) {
	super();
	setHome(aHome);
}
/**
 * Do not fire an interval change when adding aVector to the list.
 */
public VapDefaultListModel(Vector aVector) {
	super();
	this.addElements(aVector);
}
/**
 * This is the callback that one of our dependents has signalled an event
 */
public void actionPerformed(VapEvent event) {

	if ((event.getSource() == delegate) && (event.getEventName() == "objectChanged")) {
		fireContentAtIndexChanged(event);
		return ;
	}

	if ((event.getSource() == delegate) && (event.getEventName() == "replacedItems")) {
		fireContentsChanged(event);
		return ;
	}

	if ((event.getSource() == transaction) && (event.getEventName() == "mergedInto")) {
		this.queryHome();
		return ;
	}
}

public void add(int index, Object element) {
	delegate.insertElementAt(element, index);
	fireIntervalAdded(this, index, index);
}
public void addElement(Object obj) {
	int index = delegate.size();
	delegate.addElement(obj);
	fireIntervalAdded(this, index, index);
}
public void addElements(Vector aVector) {
	this.clearSelection();
	int index = aVector.size() - 1;
	Enumeration e = aVector.elements();
	while (e.hasMoreElements()) 
		delegate.addElement(e.nextElement());
	if (index >= 0)
		fireIntervalAdded(this, 0, index);
	
}
/**
 * Inform the list of the changed element from a VapEvent.
 */
protected void fireContentsChanged(VapEvent event) {

	int first, last;
	Vector data, indices;

	data = (Vector)event.getEventData();
	indices = (Vector)data.lastElement();
	first = ((Integer)indices.firstElement()).intValue();
	last = ((Integer)indices.lastElement()).intValue();

	fireContentsChanged(this, first, last);

}
public Object get(int index) {
	return this.getElementAt(index);
}
public Object getElementAt(int index) {

	Object result;
	
	Transaction current = cacheCurrentAndResumeTransaction();
	result = delegate.elementAt(index);
	this.resumeTransaction(current);
	return result;
	
}
/**
 * Return an Enumeration of the delegate's elements.
 */

public Enumeration getElements() {

	return delegate.elements();
}

public boolean getShouldQueryAfterMergedIntoEvent() {

	return shouldQueryAfterMergedIntoEvent;
		
}
public int getSize() {
	return delegate.size();
}
public int indexOf(Object elem) {
	return delegate.indexOf(elem);
}
public void insertElementAt(Object obj, int index) {
	delegate.insertElementAt(obj, index);
	fireIntervalAdded(this, index, index);
}
public boolean isEmpty() {
	return delegate.isEmpty();
}
/**
 * Query the home.
 */
protected void newTransactionObtained() {
	this.queryHome();
}
/**
 * Remove the object at index from the relationship.
 * Return the object at index.
 * The object is not markedRemoved().
 */

protected Object primRemove(int index) {

	Object rv = delegate.elementAt(index);
	delegate.removeElementAt(index);
	return rv;
}
/**
 *  Requery the home that is set with the delegate.
 */
protected void queryHome() {
	
	delegate.queryHome();
	fireContentsChanged(this, 0, delegate.size());
}
public void removeAllElements() {
	this.clearSelection();
	int index1 = delegate.size()-1;
	delegate.removeAllElements();
	if (index1 >= 0) {
	    fireIntervalRemoved(this, 0, index1);
	}
}
public boolean removeElement(Object obj) {
	int index = indexOf(obj);
	boolean rv = delegate.removeElement(obj);
	if (index >= 0) {
	    fireIntervalRemoved(this, index, index);
	}
	return rv;
}
public void removeElementAt(int index) {
	delegate.removeElementAt(index);
	fireIntervalRemoved(this, index, index);
}
public void removeRange(int fromIndex, int toIndex) {
	for(int i = toIndex; i >= fromIndex; i--) {
	    delegate.removeElementAt(i);
	}
	fireIntervalRemoved(this, fromIndex, toIndex);
}
public Object set(int index, Object element) {
	Object rv = delegate.elementAt(index);
	delegate.setElementAt(element, index);
	fireContentsChanged(this, index, index);
	return rv;
}
public void setHome(PersistentHomeCollection aHome) {
	//this.removeAllElements();
	Transaction current = cacheCurrentAndResumeTransaction();
	delegate.setHome(aHome);
	this.resumeTransaction(current);
	list.repaint();
	this.clearSelection();
	int index = getSize() - 1;
	if (index >= 0)
		fireIntervalAdded(this, 0, index);
	home = aHome;
}

public void setShouldQueryAfterMergedIntoEvent(boolean aBoolean) {

	shouldQueryAfterMergedIntoEvent = aBoolean;
		
}
/**
 * set the transaction
 */
public void setTransaction(Transaction aTransaction) {
	
	if (transaction != null)
		transaction.removeActionListener(this);
		
	super.setTransaction(aTransaction);

	if (aTransaction != null)
		aTransaction.addActionListener(this);
}
public int size() {
	return delegate.size();
}
public String toString() {
	return delegate.toString();
}
}