/*     Update Visual Age Test : Auto Test Performer   */
/*     CSD  (Upgrade to ATP V1.11)                    */
/*                                                    */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Parse arg vat_dir .;
vat_dir = strip(vat_dir);
if length(vat_dir) <= 0 then do;
   Say "Specify the drive and directory where VA Test is installed"
   Say "example:"
   Say "Atp_up  C:\VATEST"
   exit 4;
   end;
Say "Update Auto Test Performer in directory "vat_dir;
"PAUSE";
rc = SysFileTree( vat_dir, tmp_dir, "D" )
if  rc <> 0 | tmp_dir.0 = 0 then err_no_dir();
   cur_dir = directory()
   vat_dir_bin = vat_dir || "\bin"
   vat_dir_dll = vat_dir || "\dll"
   vat_dir_hlp = vat_dir || "\help"
   call rename_bin
   call rename_dll
   call rename_hlp
   new_dir = directory( cur_dir )
   "unpack atp111a " || vat_dir || "\BIN"
   if rc <> 0 then signal Err
   "unpack atp111b " || vat_dir || "\DLL"
   if rc <> 0 then signal Err
   "unpack atp111c " || vat_dir || "\HELP"
   if rc <> 0 then signal Err
   Say "Update completed."
exit 0;

Err:
   Say "Fail to update, rc="rc
   exit rc;

rename_bin:
   new_dir = directory( vat_dir_bin )
   "copy iwbm*.exe *.or0"
   "copy iwbn*.exe *.or0"
   "copy iwbo*.exe *.or0"
   "copy iwbp*.exe *.or0"
   "copy *.cmd *.or0"
   return

rename_dll:
   new_dir = directory( vat_dir_dll )
   "copy iwbm*.dll *.or0"
   "copy iwbn*.dll *.or0"
   "copy iwbo*.dll *.or0"
   "copy iwbp*.dll *.or0"
   "copy iwbqadrs.dll *.or0"
   "copy iwbqcmn.dll *.or0"
   "copy iwbr*.dll *.or0"
   return

rename_hlp:
   new_dir = directory( vat_dir_hlp )
   "copy iwbq.hlp *.or0"
   return

err_no_dir:
   say "No such directory. Please re-try.";
   exit
