/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.ejs.oa.InvalidUserKeyException;
import com.ibm.ejs.oa.Utility;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;

public final class UserKey
extends ByteArray
implements Cloneable,
com.ibm.CORBA.iiop.UserKey {
    public static final int MAGIC_OFFSET = 0;
    public static final int VERSION_OFFSET = 4;
    public static final int REFTYPE_OFFSET = 5;
    public static final int HASH_OFFSET = 6;
    public static final int NAME_LENGTH_OFFSET_V1 = 6;
    public static final int NAME_LENGTH_OFFSET_V2 = 10;
    public static int NAME_LENGTH_OFFSET = 10;
    public static final int NAME_OFFSET_V1 = 7;
    public static final int NAME_OFFSET_V2 = 11;
    public static int NAME_OFFSET;
    public static int HEADER_LENGTH;
    public static final int NAME_LENGTH_SIZE = 1;
    public static final int OA_NAME_LENGTH_SIZE = 1;
    public static final int SERVANT_NAME_LENGTH_SIZE = 4;
    public static final byte PLAIN_REF = 0;
    public static final byte SGAWARE_REF = 1;
    public static final int MAGIC = 1229277776;
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    public static byte VERSION;
    private static final TraceComponent tc;

    public static void enableVersion1CompatibilityMode() {
        VERSION = 1;
        NAME_LENGTH_OFFSET = 6;
        HEADER_LENGTH = NAME_OFFSET = 7;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ObjectIDVersionCompatibility = 1");
        }
    }

    public UserKey(String string, boolean bl, byte[] byArray, byte[] byArray2) throws InvalidUserKeyException {
        byte[] byArray3 = string.getBytes();
        if (byArray3.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (byArray.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] byArray4 = new byte[this.computeKeyLength(byArray3.length, byArray.length, byArray2.length)];
        Utility.intToBytes(1229277776, byArray4, 0);
        byArray4[4] = VERSION;
        byArray4[5] = bl ? (byte)1 : 0;
        byArray4[UserKey.NAME_LENGTH_OFFSET] = (byte)byArray3.length;
        System.arraycopy(byArray3, 0, byArray4, NAME_OFFSET, byArray3.length);
        byArray4[UserKey.getOAKeyLengthOffset((byte[])byArray4)] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray4, UserKey.getOAKeyOffset(byArray4), byArray.length);
        Utility.intToBytes(byArray2.length, byArray4, UserKey.getServantKeyLengthOffset(byArray4));
        System.arraycopy(byArray2, 0, byArray4, UserKey.getServantKeyOffset(byArray4), byArray2.length);
        this.updateBytes(byArray4, UserKey.getServantKeyOffset(byArray4));
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), byArray4, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[1] : length = " + byArray4.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] byArray, boolean bl, byte[] byArray2, byte[] byArray3) throws InvalidUserKeyException {
        if (byArray.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (byArray2.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] byArray4 = new byte[this.computeKeyLength(byArray.length, byArray2.length, byArray3.length)];
        Utility.intToBytes(1229277776, byArray4, 0);
        byArray4[4] = VERSION;
        byArray4[5] = bl ? (byte)1 : 0;
        byArray4[UserKey.NAME_LENGTH_OFFSET] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray4, NAME_OFFSET, byArray.length);
        byArray4[UserKey.getOAKeyLengthOffset((byte[])byArray4)] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, UserKey.getOAKeyOffset(byArray4), byArray2.length);
        Utility.intToBytes(byArray3.length, byArray4, UserKey.getServantKeyLengthOffset(byArray4));
        System.arraycopy(byArray3, 0, byArray4, UserKey.getServantKeyOffset(byArray4), byArray3.length);
        this.updateBytes(byArray4, UserKey.getServantKeyOffset(byArray4));
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), byArray4, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[2] : length = " + byArray4.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] byArray, boolean bl, byte[] byArray2, ByteArray byteArray) throws InvalidUserKeyException {
        if (byArray.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (byArray2.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] byArray3 = new byte[this.computeKeyLength(byArray.length, byArray2.length, byteArray.length())];
        Utility.intToBytes(1229277776, byArray3, 0);
        byArray3[4] = VERSION;
        byArray3[5] = bl ? (byte)1 : 0;
        byArray3[UserKey.NAME_LENGTH_OFFSET] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, NAME_OFFSET, byArray.length);
        byArray3[UserKey.getOAKeyLengthOffset((byte[])byArray3)] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, UserKey.getOAKeyOffset(byArray3), byArray2.length);
        byte[] byArray4 = byteArray.getBytes();
        Utility.intToBytes(byArray4.length, byArray3, UserKey.getServantKeyLengthOffset(byArray3));
        System.arraycopy(byArray4, 0, byArray3, UserKey.getServantKeyOffset(byArray3), byArray4.length);
        this.updateBytes(byArray3, UserKey.getServantKeyOffset(byArray3), byteArray.hashCode());
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), byArray3, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[3] : length = " + byArray3.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] byArray) throws InvalidUserKeyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        this.data = byArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "length    : " + byArray.length);
        }
        if (this.getMagicNumber() != 1229277776) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: EyeCatcher " + this.getMagicNumber() + " not supported.");
            }
            throw new InvalidUserKeyException("EyeCatcher " + this.getMagicNumber() + " not supported.");
        }
        byte by = this.getVersionNumber();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version   : " + by);
        }
        if (by > 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Version " + by + " not supported.");
            }
            throw new InvalidUserKeyException("Version " + by + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "refType   : " + this.getWLMObjectRefTypeString());
        }
        if (this.getWLMObjectRefType() != 0 && this.getWLMObjectRefType() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Ref Type " + this.getWLMObjectRefType() + " not supported.");
            }
            throw new InvalidUserKeyException("Ref Type " + this.getWLMObjectRefType() + " not supported.");
        }
        if (by > 1) {
            int n = this.getHashValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "hashcode  : " + n);
            }
            if (VERSION == 1) {
                byte[] byArray2 = new byte[byArray.length - 4];
                System.arraycopy(byArray, 0, byArray2, 0, 6);
                System.arraycopy(byArray, 10, byArray2, 6, byArray.length - 10);
                byArray = byArray2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compatibility Mode : Version 2 -> Version 1");
                }
            }
            this.updateBytes(byArray, UserKey.getServantKeyOffset(byArray), n);
        } else if (VERSION == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compatibility Mode : Version 1 -> Version 1");
            }
            this.updateBytes(byArray, UserKey.getServantKeyOffset(byArray));
        } else {
            byte[] byArray3 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray3, 0, 6);
            System.arraycopy(byArray, 6, byArray3, 10, byArray.length - 6);
            byArray = byArray3;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Converted : Version 1 -> Version 2");
            }
            this.updateBytes(byArray, UserKey.getServantKeyOffset(byArray));
            Utility.intToBytes(this.hashCode(), byArray, 6);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "hashcode  : " + this.getHashValue());
            }
        }
        if (this.data[NAME_LENGTH_OFFSET] < 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Server/Group name length " + this.data[NAME_LENGTH_OFFSET] + " not supported.");
            }
            throw new InvalidUserKeyException("Server/Group name length " + this.data[NAME_LENGTH_OFFSET] + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Server    : " + this.getName());
        }
        if (this.getOAKeyLength() < 1 || this.getOAKeyOffset() + this.getOAKeyLength() >= byArray.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: ObjectAdapter length " + this.getOAKeyLength() + ", or offset " + this.getOAKeyOffset() + " not supported.");
            }
            throw new InvalidUserKeyException("ObjectAdapter length " + this.getOAKeyLength() + ", or offset " + this.getOAKeyOffset() + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA Name   : " + this.getOAName());
        }
        if (this.getServantKeyLength() < 1 || this.getServantKeyOffset() + this.getServantKeyLength() != byArray.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Servant Key length " + this.getServantKeyLength() + ", or offset " + this.getServantKeyOffset() + " not supported.");
            }
            throw new InvalidUserKeyException("Servant Key length " + this.getServantKeyLength() + ", or offset " + this.getServantKeyOffset() + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    private UserKey(UserKey userKey) {
        super((ByteArray)userKey);
    }

    public Object clone() {
        return new UserKey(this);
    }

    public byte[] getOAKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOAKey");
        }
        byte[] byArray = new byte[this.getOAKeyLength()];
        System.arraycopy(this.data, this.getOAKeyOffset(), byArray, 0, byArray.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOAKey", byArray);
        }
        return byArray;
    }

    public byte[] getServantKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantKey");
        }
        byte[] byArray = new byte[this.getServantKeyLength()];
        System.arraycopy(this.data, this.getServantKeyOffset(), byArray, 0, byArray.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantKey", byArray);
        }
        return byArray;
    }

    public int getMagicNumber() {
        return Utility.bytesToInt(this.data, 0);
    }

    public byte getVersionNumber() {
        return this.data[4];
    }

    public byte getWLMObjectRefType() {
        return this.data[5];
    }

    private String getWLMObjectRefTypeString() {
        if (this.data[5] == 0) {
            return "PLAIN_REF";
        }
        if (this.data[5] == 1) {
            return "SGAWARE_REF";
        }
        return "INVALID:" + this.data[5];
    }

    public int getHashValue() {
        return Utility.bytesToInt(this.data, 6);
    }

    public String getName() {
        return new String(this.data, NAME_OFFSET, (int)this.data[NAME_LENGTH_OFFSET]);
    }

    public String getOAName() {
        return new String(this.data, this.getOAKeyOffset(), (int)this.getOAKeyLength());
    }

    public void setPlainRef(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setPlainRef : " + string);
        }
        this.data[5] = 0;
        if (string != null) {
            this.setName(string);
        }
    }

    public void setName(String string) {
        if (!string.equals(this.getName())) {
            byte[] byArray = string.getBytes();
            if (byArray.length != this.data[NAME_LENGTH_OFFSET]) {
                byte[] byArray2 = new byte[this.computeKeyLength(byArray.length, this.getOAKeyLength(), this.getServantKeyLength())];
                System.arraycopy(this.data, 0, byArray2, 0, HEADER_LENGTH);
                System.arraycopy(this.data, this.getOAKeyLengthOffset(), byArray2, NAME_OFFSET + byArray.length, this.data.length - this.getOAKeyLengthOffset());
                byArray2[UserKey.NAME_LENGTH_OFFSET] = (byte)byArray.length;
                this.data = byArray2;
            }
            System.arraycopy(byArray, 0, this.data, NAME_OFFSET, byArray.length);
        }
    }

    public final boolean equals(Object object) {
        try {
            ByteArray byteArray = (ByteArray)object;
            return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), byteArray);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(com.ibm.CORBA.iiop.UserKey userKey) {
        try {
            ByteArray byteArray = (ByteArray)userKey;
            return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), byteArray);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(ByteArray byteArray) {
        return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), byteArray);
    }

    public void dump() {
        Tr.debug(tc, "UserKey dump : ", new Object[]{new Integer(this.getMagicNumber()), new Byte(this.getVersionNumber()), new Byte(this.getWLMObjectRefType()), new Integer(this.getHashValue()), this.getName(), this.getOAName(), super.toString()});
    }

    private static final int getOAKeyLengthOffset(byte[] byArray) {
        return NAME_OFFSET + byArray[NAME_LENGTH_OFFSET];
    }

    private static final int getOAKeyOffset(byte[] byArray) {
        return UserKey.getOAKeyLengthOffset(byArray) + 1;
    }

    private static final byte getOAKeyLength(byte[] byArray) {
        return byArray[UserKey.getOAKeyLengthOffset(byArray)];
    }

    private static final int getServantKeyLengthOffset(byte[] byArray) {
        return UserKey.getOAKeyOffset(byArray) + UserKey.getOAKeyLength(byArray);
    }

    private static final int getServantKeyOffset(byte[] byArray) {
        return UserKey.getServantKeyLengthOffset(byArray) + 4;
    }

    private static final int getServantKeyLength(byte[] byArray) {
        return Utility.bytesToInt(byArray, UserKey.getServantKeyLengthOffset(byArray));
    }

    private int getOAKeyLengthOffset() {
        return UserKey.getOAKeyLengthOffset(this.data);
    }

    private int getOAKeyOffset() {
        return UserKey.getOAKeyOffset(this.data);
    }

    private byte getOAKeyLength() {
        return UserKey.getOAKeyLength(this.data);
    }

    private int getServantKeyLengthOffset() {
        return UserKey.getServantKeyLengthOffset(this.data);
    }

    private int getServantKeyOffset() {
        return UserKey.getServantKeyOffset(this.data);
    }

    private int getServantKeyLength() {
        return UserKey.getServantKeyLength(this.data);
    }

    private int computeKeyLength(int n, int n2, int n3) {
        return HEADER_LENGTH + n + n2 + 1 + n3 + 4;
    }

    static {
        HEADER_LENGTH = NAME_OFFSET = 11;
        VERSION = (byte)2;
        tc = Tr.register(UserKey.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    }
}

