/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

abstract class SharedLogBase
implements SharedLogConstants {
    private static TraceComponent tc = Tr.register(SharedLogBase.class);

    SharedLogBase() throws RasException {
    }

    static synchronized void acquireHostLock(File file, boolean bl) throws SharedLogLockException {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        File file2 = file;
        try {
            while (!bl2) {
                bl2 = RasHelper.createNewFile(file2);
                if (bl2) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Contention detected attempting to get SharedLog lock");
                }
                if (!bl || n == 600) {
                    long l;
                    long l2 = System.currentTimeMillis();
                    if (l2 - (l = RasHelper.fileLastModified(file2)) > 300000L && bl3) {
                        bl3 = false;
                        SharedLogBase.releaseHostLock(file);
                        n = 0;
                    } else {
                        SharedLogLockException sharedLogLockException = new SharedLogLockException("Unable to obtain Shared Log Lock file " + file2.getPath());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception detected attempting to get Host Lock", sharedLogLockException);
                        }
                        throw sharedLogLockException;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            SharedLogLockException sharedLogLockException = new SharedLogLockException("Unable to obtain Shared Log Lock file " + file2.getPath(), throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception detected attempting to get Host Lock", sharedLogLockException);
            }
            throw sharedLogLockException;
        }
    }

    static synchronized void acquireHostLock(File file) throws SharedLogLockException {
        SharedLogBase.acquireHostLock(file, true);
    }

    static void releaseHostLock(File file) {
        try {
            RasHelper.deleteFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    File copyLogFile(String string) throws IOException {
        File file = null;
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            file = this.createTemporaryFile();
            randomAccessFile = this.createRandomAccessFile(file.getPath(), "rw");
            randomAccessFile2 = this.createRandomAccessFile(string, "r");
            this.copyFile(randomAccessFile2, randomAccessFile);
            randomAccessFile2.close();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (randomAccessFile2 != null) {
                    randomAccessFile2.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw iOException;
        }
        return file;
    }

    private File createTemporaryFile() throws IOException {
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return File.createTempFile("wsal", ".log");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    RandomAccessFile createRandomAccessFile(String string, String string2) throws IOException {
        final String string3 = string;
        final String string4 = string2;
        try {
            return (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new RandomAccessFile(string3, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void copyFile(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        long l = randomAccessFile.length();
        boolean bl = false;
        randomAccessFile.seek(0L);
        randomAccessFile2.seek(0L);
        do {
            if (l > (long)n) {
                randomAccessFile.readFully(byArray);
                randomAccessFile2.write(byArray);
                l -= (long)n;
                continue;
            }
            byte[] byArray2 = new byte[(int)l];
            randomAccessFile.readFully(byArray2);
            randomAccessFile2.write(byArray2);
            bl = true;
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTemporaryFile(RandomAccessFile randomAccessFile, File file) {
        try {
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            RasHelper.deleteFile(file);
        }
    }
}

