/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = -2497823480436618075L;
    private boolean accessOrder = false;
    private LinkedList keyList = new LinkedList();

    public LinkedHashMap() {
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    public LinkedHashMap(Map m) {
        this.putAll(m);
    }

    public void clear() {
        super.clear();
        this.keyList.clear();
    }

    public Object remove(Object key) {
        int index;
        Object value2 = super.remove(key);
        if (value2 == null && (index = this.getKeyIndex(key)) >= 0) {
            this.keyList.remove(index);
        }
        return value2;
    }

    public Object get(Object key) {
        int index;
        Object value2 = super.get(key);
        if (this.accessOrder && (index = this.getKeyIndex(key)) >= 0 && index != this.keyList.size() - 1) {
            this.keyList.remove(index);
            this.keyList.addLast(key);
        }
        return value2;
    }

    public void putAll(Map m) {
        Set keySet = m.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value2 = m.get(key);
            this.put(key, value2);
        }
    }

    public Object put(Object key, Object value2) {
        Object eldestValue;
        Object eldestKey;
        MapEntry entry;
        Object oldValue = super.put(key, value2);
        int index = this.getKeyIndex(key);
        if (index >= 0) {
            if (index != this.keyList.size() - 1) {
                this.keyList.remove(index);
                this.keyList.addLast(key);
            }
        } else {
            this.keyList.addLast(key);
        }
        if (this.removeEldestEntry(entry = new MapEntry(eldestKey = this.keyList.getFirst(), eldestValue = super.get(eldestKey)))) {
            this.keyList.removeFirst();
            super.remove(eldestKey);
        }
        return oldValue;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    private int getKeyIndex(Object key) {
        int index = -1;
        for (int i = 0; i < this.keyList.size(); ++i) {
            Object o = this.keyList.get(i);
            if (!o.equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected static class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private MapEntry(Object key, Object value2) {
            this.key = key;
            this.value = value2;
        }

        public boolean equals(Object o) {
            Object otherKey = ((Map.Entry)o).getKey();
            Object otherValue = ((Map.Entry)o).getValue();
            return this.key.equals(otherKey) && this.value.equals(otherValue);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            Object oldValue = this.value;
            this.value = value2;
            return oldValue;
        }
    }
}

