/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ffdc;

import com.ibm.nws.ffdc.FFDCHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configure {
    static final int NO_PROCESSING = 0;
    static final int EXCEPTION_PATH_ONLY = 1;
    static final int CALL_STACK_DUMP = 2;
    static final int DIAGNOSE_CURRENT_LEVEL = 3;
    static final int DIAGNOSE_USE_DM_CURRENT_LEVEL = 4;
    static final int DIAGNOSE_CURRENT_TO_TOP = 5;
    static final int DIAGNOSE_ENTIRE_STACK = 6;
    static final int ADVANCED_PROCESSING = 7;
    private static final String LEVEL = "Level";
    private static final String INCLUDE = "IncludeList";
    private static final String EXCLUDE = "ExcludeList";
    private static final String NUMBERTODUMP = "TimesToDump";
    private static final String TIMEBETWEEN = "TimeBetween";
    private static final String LAE = "LAE";
    private static final String INCIDENTSTREAMPOOLSIZE = "IncidentStreamPoolSize";
    private static final String INTROSPECTDEPTH = "IntrospectDepth";
    private static final String INTROSPECTSIZE = "IntrospectMaxSize";
    private static final String EXCEPTIONFILESIZE = "ExceptionFileSize";
    private static final String EXCEPTIONFILEBACKUP = "ExceptionBackUpFiles";
    private static final String REFRESHINTERVAL = "RefreshInterval";
    private static final String ALLOWDEBUG = "Debug";
    static int processLevel = 0;
    boolean useLogAnalysisEngine = false;
    String[] inclusionList = null;
    String[] exclusionList = null;
    long timeBetweenProcessing = 0L;
    int numberOfTimesToProcess = 1;
    int incidentStreamPoolSize = 30;
    int introspectDepth = 1;
    int introspectMaxSize = 1024;
    int exceptionFileSize = 1024;
    int exceptionFileBackup = 1;
    int refreshInterval = 0;
    boolean debugMode = false;
    String propertyFile = null;
    int currentState = 0;
    private static String serverName = null;
    static String processLevelProperty = System.getProperty("FFDCProcessLevel");
    static String baseFileDir = System.getProperty("FFDCLogDirectory");

    Configure() {
    }

    public static Configure newConfiguration(int n) {
        boolean bl = false;
        Configure configure = new Configure();
        bl = configure.processPropertyFile(n);
        if (!bl) {
            configure = null;
        }
        return configure;
    }

    private static boolean convertBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    private static int convertInt(String string, int n) {
        int n2 = n;
        if (string == null) {
            return n;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    private static int convertInt(String string, int n, int n2) {
        int n3 = 0;
        n3 = Configure.convertInt(string, n);
        if (n3 < n2) {
            n3 = n;
        }
        return n3;
    }

    private boolean processPropertyFile(int n) {
        String[] stringArray = new String[]{"", "ffdcStart.properties", "ffdcRun.properties", "ffdcStop.properties"};
        Properties properties = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        InputStream inputStream = null;
        if (n < 1 || n > 3) {
            n = 1;
        }
        if (serverName == null) {
            serverName = FFDCHelper.getServerName();
        }
        this.currentState = n;
        try {
            properties = new Properties();
            this.propertyFile = serverName + '_' + stringArray[n];
            inputStream = FFDCHelper.getResourceAsStream(this.propertyFile);
            if (inputStream == null) {
                this.propertyFile = stringArray[n];
                inputStream = FFDCHelper.getResourceAsStream(this.propertyFile);
            }
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.propertyFile = this.propertyFile + " (Default values)";
        }
        catch (Throwable throwable) {
            this.propertyFile = this.propertyFile + " (Default values)";
        }
        try {
            string = properties.getProperty(LEVEL);
            processLevel = Configure.convertInt(string, 0);
            string2 = properties.getProperty(INCLUDE);
            this.inclusionList = FFDCHelper.split(string2, 124);
            string3 = properties.getProperty(EXCLUDE);
            this.exclusionList = FFDCHelper.split(string3, 124);
            string4 = properties.getProperty(LAE);
            this.useLogAnalysisEngine = Configure.convertBoolean(string4, false);
            string5 = properties.getProperty(NUMBERTODUMP);
            this.numberOfTimesToProcess = Configure.convertInt(string5, 1);
            string6 = properties.getProperty(TIMEBETWEEN);
            this.timeBetweenProcessing = Configure.convertInt(string6, 0);
            string7 = properties.getProperty(INCIDENTSTREAMPOOLSIZE);
            this.incidentStreamPoolSize = Configure.convertInt(string7, 30);
            string9 = properties.getProperty(INTROSPECTDEPTH);
            this.introspectDepth = Configure.convertInt(string9, 1);
            string8 = properties.getProperty(INTROSPECTSIZE);
            this.introspectMaxSize = Configure.convertInt(string8, 1024);
            string10 = properties.getProperty(EXCEPTIONFILESIZE);
            this.exceptionFileSize = Configure.convertInt(string10, 1024, 10);
            string11 = properties.getProperty(EXCEPTIONFILEBACKUP);
            this.exceptionFileBackup = Configure.convertInt(string11, 1, 1);
            string13 = properties.getProperty(REFRESHINTERVAL);
            this.refreshInterval = Configure.convertInt(string13, 0, 0);
            string12 = properties.getProperty(ALLOWDEBUG);
            this.debugMode = Configure.convertBoolean(string12, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debugMode) {
            this.printObject();
        }
        return true;
    }

    void printObject() {
        int n;
        System.out.println("*************** Start of dump *********************");
        System.out.println("Properties for : " + this.propertyFile);
        System.out.println("The Level : " + processLevel);
        System.out.println("number : " + this.numberOfTimesToProcess);
        System.out.println("time : " + this.timeBetweenProcessing);
        System.out.println("LAE : " + this.useLogAnalysisEngine);
        System.out.println("Incident Stream pool : " + this.incidentStreamPoolSize);
        System.out.println("introspection depth : " + this.introspectDepth);
        System.out.println("introspection size : " + this.introspectMaxSize);
        System.out.println("Exception file size : " + this.exceptionFileSize);
        System.out.println("Exception backup files : " + this.exceptionFileBackup);
        System.out.println("Refresh interval : " + this.refreshInterval);
        System.out.println("Allow for debug : " + this.debugMode);
        if (this.inclusionList != null) {
            for (n = 0; n < this.inclusionList.length; ++n) {
                System.out.println("inclusionList[" + n + "] : " + this.inclusionList[n]);
            }
        } else {
            System.out.println("inclusionList is null");
        }
        if (this.exclusionList != null) {
            for (n = 0; n < this.exclusionList.length; ++n) {
                System.out.println("exclusionList[" + n + "] : " + this.exclusionList[n]);
            }
        } else {
            System.out.println("exclusionList is null");
        }
        System.out.println("*************** End of dump *********************");
    }

    static {
        if (processLevelProperty != null) {
            processLevel = new Integer(processLevelProperty);
            if (processLevel < 0 || processLevel > 4) {
                processLevel = 0;
            }
        } else {
            processLevel = 0;
        }
    }
}

