/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASHandler;
import com.ibm.ras.RASUtil;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Hashtable;

public class RASSocketHandler
extends RASHandler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 2940626756544830743L;
    private static final int DEFAULT_PORT = 9991;
    private static final String DEFAULT_SERVER = "localhost";
    private int port = 9991;
    private String server = "localhost";
    private transient Socket socket = null;

    public RASSocketHandler() {
    }

    public RASSocketHandler(String string) {
        super(string);
    }

    public RASSocketHandler(String string, String string2) {
        super(string, string2);
    }

    public RASSocketHandler(String string, String string2, String string3, int n) {
        super(string, string2);
        this.setServer(string3);
        this.setPort(n);
    }

    protected void init() {
        super.init();
        this.port = 9991;
        this.server = DEFAULT_SERVER;
        this.socket = null;
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("socketPort", new Integer(this.getPort()).toString());
        hashtable.put("socketServer", this.getServer());
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("socketPort")) {
            String string = ((String)hashtable.get("socketPort")).trim();
            this.setPort(new Integer(string));
        }
        if (hashtable.containsKey("socketServer")) {
            this.setServer((String)hashtable.get("socketServer"));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        if (string != null) {
            this.server = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        this.closeDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            block5: {
                try {
                    this.socket = new Socket(this.getServer(), this.getPort());
                    DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(dataOutputStream);
                    this.pWriter = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), true);
                    this.deviceOpen = true;
                }
                catch (Exception exception) {
                    if (++this.deviceFailures > 2) break block5;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_SOCKET", this.getServer(), new Integer(this.getPort())));
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

