/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DescriptionA
implements Description {
    private static final TraceComponent tc = Tr.register(DescriptionA.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descMgr = DescriptionManagerFactory.getDescriptionManager();
    private Map listeners = Collections.synchronizedMap(new HashMap(3));
    private boolean local = false;
    private final DescriptionKey key;
    private Description.Memento memento = null;

    protected DescriptionA(DescriptionKey descriptionKey) {
        this.key = descriptionKey;
        this.memento = this.createMemento();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "<init>", new Object[]{this, this.getDefinitionKey()});
        }
    }

    public DescriptionKey getKey() {
        return this.key;
    }

    public boolean isLocal() {
        return this.local;
    }

    void setLocal() {
        this.local = true;
    }

    public Description.Memento getMemento() {
        return this.memento;
    }

    public void setMemento(Description.Memento memento) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemento", memento);
        }
        this.memento = memento;
        this.notifyListeners("type.memento.updated", memento);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemento");
        }
    }

    public final void updateMemento() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMemento", this.key);
        }
        descMgr.publish(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMemento", this.local ? "local" : "distributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNotificationListener(DescriptionModificationListener descriptionModificationListener, String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNotificationListener", new Object[]{descriptionModificationListener.getClass().getName(), string, object});
        }
        WeakHashMap<DescriptionModificationListener, Object> weakHashMap = null;
        WeakHashMap<DescriptionModificationListener, Object> weakHashMap2 = this.listeners;
        synchronized (weakHashMap2) {
            weakHashMap = (WeakHashMap<DescriptionModificationListener, Object>)this.listeners.get(string);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<DescriptionModificationListener, Object>();
                this.listeners.put(string, weakHashMap);
            }
        }
        weakHashMap2 = weakHashMap;
        synchronized (weakHashMap2) {
            weakHashMap.put(descriptionModificationListener, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener " + Integer.toString(this.listeners.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNotificationListener(DescriptionModificationListener descriptionModificationListener, String string) {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterNotificationListener", new Object[]{descriptionModificationListener.getClass().getName(), string});
        }
        if ((map = (Map)this.listeners.get(string)) != null) {
            Map map2 = map;
            synchronized (map2) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "removing listener pair", map);
                }
                map.remove(descriptionModificationListener);
                if (map.isEmpty()) {
                    this.listeners.remove(string);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No registered listeners for this type");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterNotificationListener " + Integer.toString(this.listeners.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(String string, Object object) {
        Map map = (Map)this.listeners.get(string);
        if (map != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyListeners", new Object[]{string, object});
            }
            HashMap hashMap = null;
            Object object2 = map;
            synchronized (object2) {
                if (map.isEmpty()) {
                    this.listeners.remove(string);
                }
                hashMap = new HashMap(map);
            }
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = (Map.Entry)object2.next();
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "notifyListeners", entry);
                    }
                    ((DescriptionModificationListener)entry.getKey()).handleNotification(this.key, string, object, entry.getValue());
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, (class$com$ibm$websphere$cluster$topography$DescriptionA == null ? DescriptionA.class$("com.ibm.websphere.cluster.topography.DescriptionA") : class$com$ibm$websphere$cluster$topography$DescriptionA).getName() + ".notifyListeners", "133", this, new Object[]{this.key, string, object});
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyListeners " + Integer.toString(this.listeners.size()));
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + '#' + this.hashCode() + this.key + ']';
    }

    public abstract class MementoA
    implements Description.Memento {
        public Description.Memento delta() {
            if (this == DescriptionA.this.memento) {
                return null;
            }
            return DescriptionA.this.memento;
        }

        public String toString() {
            return "[" + this.getClass().getEnclosingClass().getSimpleName() + '$' + this.getClass().getSimpleName() + '#' + this.hashCode() + DescriptionA.this.key + ']';
        }
    }
}

