/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class EditionHelper {
    private static TraceComponent tc = Tr.register(EditionHelper.class, "AppEditions", "com.ibm.websphere.management.applications");
    public static final String ED = "-edition";
    public static final String EDITION_PROP_FILE = "ibm-edition-metadata.props";
    public static final String EDITION_PROP_DELIM = "-";
    public static final String BASE_EDITION = "BASE";
    public static final String DEFAULT_EDITION = "DEFAULT";
    public static final String ACTIVE_EDITION_PROP = "config.active";
    public static final String DEFAULT_EDITION_PROP = "config.default";
    public static final String STATE_EDITION_PROP = "config.state";
    public static final String Edition_INACTIVE = "INACTIVE";
    public static final String Edition_ACTIVE = "ACTIVE";
    public static final String Edition_VALIDATE = "VALIDATE";
    public static final String EDITION_PROP_HEADER = "File contains metadata for all editions of the application";
    public static final String DESC_EDITION_PROP = "edition.desc";
    private static Boolean isEditionSupportEnabled = null;
    private static Boolean isXDInstalled = null;

    public static String[] getAppAndEdition(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppAndEdition", string);
        }
        if ((n = string.indexOf(ED)) == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppAndEdition", new Object[]{string, ""});
            }
            return new String[]{string, ""};
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppAndEdition", new Object[]{string2, string3});
        }
        return new String[]{string2, string3};
    }

    public static String[] getAppAndEdition(String string, Hashtable hashtable) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppAndEdition", new Object[]{string, hashtable});
        }
        if ((n = string.indexOf(ED)) == -1) {
            String string2;
            String string3 = string2 = hashtable != null ? (String)hashtable.get("edition") : "";
            if (string2 == null) {
                string2 = "";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppAndEdition", new String[]{string, string2});
            }
            return new String[]{string, string2};
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppAndEdition", new String[]{string4, string5});
        }
        return new String[]{string4, string5};
    }

    public static String getCompositeName(String string, String string2) {
        if (EditionHelper.isEmpty(string2)) {
            return string;
        }
        if (string2.equalsIgnoreCase(BASE_EDITION)) {
            return string;
        }
        if (string.indexOf(ED) != -1) {
            return string;
        }
        return string + ED + string2;
    }

    public static String getCompositeName(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return string;
        }
        if (string.indexOf(ED) != -1) {
            return string;
        }
        return EditionHelper.getCompositeName(string, (String)hashtable.get("edition"));
    }

    public static String getAppEarName(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        if (string.indexOf(ED) != -1) {
            String[] stringArray = EditionHelper.getAppAndEdition(string);
            string3 = stringArray[0];
            string4 = stringArray[1];
        }
        return string3 + (EditionHelper.isEmpty(string4) ? "" : ED + string4) + ".ear";
    }

    public static String getAppEarName(String string, Hashtable hashtable) {
        if (string.indexOf(ED) != -1) {
            return EditionHelper.getAppEarName(string, (String)null);
        }
        return EditionHelper.getAppEarName(string, (String)hashtable.get("edition"));
    }

    public static String getEditionDescPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(DESC_EDITION_PROP, stringArray[1]);
    }

    public static String getActiveEditionPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(ACTIVE_EDITION_PROP, stringArray[1]);
    }

    public static String getDefaultEditionPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(DEFAULT_EDITION_PROP, stringArray[1]);
    }

    public static String getEditionPropSuffix(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName("", stringArray[1]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public static boolean isEditionSupportEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEditionSupportEnabled");
        }
        if (isEditionSupportEnabled == null) {
            boolean bl = false;
            boolean bl2 = EditionHelper.isXDInstalled();
            if (bl2) {
                bl = true;
            } else {
                String string = System.getProperty("edition.enable");
                if (string != null && string.equals("true")) {
                    bl = true;
                }
            }
            isEditionSupportEnabled = new Boolean(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEditionSupportEnabled", isEditionSupportEnabled);
        }
        return isEditionSupportEnabled;
    }

    public static boolean isXDInstalled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isXDInstalled");
        }
        if (isXDInstalled == null) {
            boolean bl;
            block9: {
                bl = false;
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.xd.appeditionmgr.XDInstalledMarker");
                    if (clazz != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "XD Marker Found!");
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof ClassNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "XD Marker NOT Found!");
                        }
                    }
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Error in Load of XD Marker. " + exception.toString());
                }
            }
            isXDInstalled = new Boolean(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isXDInstalled", isXDInstalled);
        }
        return isXDInstalled;
    }

    public static boolean checkIfEditionValid(String string) {
        boolean bl = true;
        if (string == null || string.trim().length() == 0) {
            bl = true;
        } else if (string.indexOf("]]>") != -1) {
            bl = false;
        } else if (string.endsWith(" ") || string.startsWith(" ")) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/,:;\"*?<>|=+&%'");
            if (stringTokenizer.hasMoreTokens() && !stringTokenizer.nextToken().equals(string)) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EditionInfo[] getApplicationEditions(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationEditions", string);
        }
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String string2 = AdminServiceFactory.getAdminService().getCellName();
        String string3 = "cells/" + string2 + "/applications/" + string + ".ear/";
        EditionInfo[] editionInfoArray = null;
        try {
            DocumentContentSource documentContentSource = configRepository.extract(string3 + EDITION_PROP_FILE);
            Properties properties = new Properties();
            properties.load(documentContentSource.getSource());
            Enumeration<?> enumeration = properties.propertyNames();
            Hashtable<String, EditionInfo> hashtable = new Hashtable<String, EditionInfo>();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = null;
                String string6 = null;
                String string7 = null;
                if (!string4.startsWith(STATE_EDITION_PROP)) continue;
                if (string4.startsWith("config.state-")) {
                    string5 = string4.substring(STATE_EDITION_PROP.length() + ED.length());
                    string6 = properties.getProperty("edition.desc-edition" + string5);
                    string7 = properties.getProperty("config.state-edition" + string5);
                } else {
                    string5 = string4.substring(STATE_EDITION_PROP.length());
                    string6 = properties.getProperty(DESC_EDITION_PROP);
                    string7 = properties.getProperty(STATE_EDITION_PROP);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Edition = " + string5 + ";Desc = " + string6 + ";State = " + string7);
                }
                EditionInfo editionInfo = new EditionInfo(EditionHelper.getCompositeName(string, string5), string2);
                editionInfo.setDescription(string6);
                editionInfo.setEditionState(string7);
                hashtable.put(string5, editionInfo);
            }
            editionInfoArray = hashtable.values().toArray(new EditionInfo[hashtable.size()]);
        }
        catch (RepositoryException repositoryException) {
            if (repositoryException instanceof DocumentNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "Failed to retrieve the edition meta-data from the Repository.");
                }
                if (string.equals("isclite") || string.equals("adminconsole") || string.equals("filetransfer") || string.equals("ManagementEJB")) {
                    if (tc.isDebugEnabled()) {
                        Tr.info(tc, string + " is a System Application.");
                    }
                    EditionInfo editionInfo = new EditionInfo(EditionHelper.getCompositeName(string, ""), string2);
                    editionInfo.setDescription("");
                    editionInfo.setEditionState(Edition_ACTIVE);
                    editionInfoArray = new EditionInfo[]{editionInfo};
                }
                String[] stringArray = configRepository.listResourceNames(string3, 255, Integer.MAX_VALUE);
                if (stringArray != null && stringArray.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.info(tc, "Assume only Base edition available for " + string + " and it is always ACTIVE.");
                    }
                    EditionInfo editionInfo = new EditionInfo(EditionHelper.getCompositeName(string, ""), string2);
                    editionInfo.setDescription("");
                    editionInfo.setEditionState(Edition_ACTIVE);
                    editionInfoArray = new EditionInfo[]{editionInfo};
                } else {
                    Tr.error(tc, "Unexpected Error: " + string + " -- The Application's Directory in the Repository is EMPTY.");
                    throw repositoryException;
                }
            }
            FFDCFilter.processException(repositoryException, "com.ibm.websphere.management.application.EditionHelper.getApplicationEditions", "444");
            Tr.error(tc, "Failed to read the edition meta-data for the application, " + string + ", due to RepositoryException.");
            editionInfoArray = null;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.websphere.management.application.EditionHelper.getApplicationEditions", "445");
            Tr.error(tc, "Failed to read the edition meta-data for the application, " + string + ", due to IOException.");
            editionInfoArray = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationEditions", editionInfoArray);
        }
        return editionInfoArray;
    }

    public static EditionInfo[] getApplicationEditions(String string, AppManagement appManagement) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationEditions(appName, appManagement)");
        }
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "appName = " + string);
        }
        EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationEditions(appName, appManagement)");
        }
        return editionInfoArray;
    }

    public static String getActiveEditionOnServer(String string, List list) {
        String string2 = "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveEditionOnServer");
            Tr.debug(tc, "appName " + string + " List " + list);
        }
        try {
            String string3 = null;
            EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions(string);
            for (int i = 0; i < editionInfoArray.length; ++i) {
                String string4 = editionInfoArray[i].getEditionState();
                if (string4.equalsIgnoreCase(Edition_ACTIVE)) {
                    String string5 = EditionHelper.getCompositeName(editionInfoArray[i].getAppName(), editionInfoArray[i].getEdition());
                    for (int j = 0; j < list.size(); ++j) {
                        String string6 = (String)list.get(j);
                        if (!string6.endsWith(string5)) continue;
                        string3 = editionInfoArray[i].getEdition();
                        break;
                    }
                }
                if (string3 != null) break;
            }
            if (string3 != null) {
                string2 = string3;
            }
        }
        catch (Exception exception) {
            System.out.println("In getActiveEditionOnServer " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveEditionOnServer -> active Edition " + string2);
        }
        return string2;
    }

    public static String getEditionStatePropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(STATE_EDITION_PROP, stringArray[1]);
    }

    public static boolean isAppActive(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEditionActive " + string);
        }
        boolean bl = false;
        try {
            String string2 = EditionHelper.getEditionState(string);
            bl = string2.equalsIgnoreCase(Edition_ACTIVE) || string2.equalsIgnoreCase(Edition_VALIDATE);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isEditionActive(" + string + ")=" + bl);
        }
        return bl;
    }

    public static String getEditionState(String string) throws Exception {
        String string2 = Edition_INACTIVE;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEditionState");
        }
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        AppManagement appManagement = null;
        appManagement = AppManagementProxy.getLocalProxy();
        EditionInfo editionInfo = appManagement.getEditionInfo(stringArray[0], stringArray[1], null, null)[0];
        string2 = editionInfo.getEditionState();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getEditionState(" + string + ")=" + string2);
        }
        return string2;
    }
}

